/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.base;

import com.jme3.network.ConnectionListener;
import com.jme3.network.Filter;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Server;
import com.jme3.network.base.KernelAdapter;
import com.jme3.network.base.MessageListenerRegistry;
import com.jme3.network.base.MessageProtocol;
import com.jme3.network.kernel.Endpoint;
import com.jme3.network.kernel.Kernel;
import com.jme3.network.message.ClientRegistrationMessage;
import com.jme3.network.message.DisconnectMessage;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServer
implements Server {
    static Logger log = Logger.getLogger(DefaultServer.class.getName());
    private boolean isRunning = false;
    private AtomicInteger nextId = new AtomicInteger(0);
    private String gameName;
    private int version;
    private Kernel reliable;
    private KernelAdapter reliableAdapter;
    private Kernel fast;
    private KernelAdapter fastAdapter;
    private Redispatch dispatcher = new Redispatch();
    private Map<Integer, HostedConnection> connections = new ConcurrentHashMap<Integer, HostedConnection>();
    private Map<Endpoint, HostedConnection> endpointConnections = new ConcurrentHashMap<Endpoint, HostedConnection>();
    private Map<Long, Connection> connecting = new ConcurrentHashMap<Long, Connection>();
    private MessageListenerRegistry<HostedConnection> messageListeners = new MessageListenerRegistry();
    private List<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();

    public DefaultServer(String gameName, int version, Kernel reliable, Kernel fast) {
        if (reliable == null) {
            throw new IllegalArgumentException("Default server reqiures a reliable kernel instance.");
        }
        this.gameName = gameName;
        this.version = version;
        this.reliable = reliable;
        this.fast = fast;
        this.reliableAdapter = new KernelAdapter(this, reliable, this.dispatcher, true);
        if (fast != null) {
            this.fastAdapter = new KernelAdapter(this, fast, this.dispatcher, false);
        }
    }

    @Override
    public String getGameName() {
        return this.gameName;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void start() {
        if (this.isRunning) {
            throw new IllegalStateException("Server is already started.");
        }
        this.reliable.initialize();
        if (this.fast != null) {
            this.fast.initialize();
        }
        this.reliableAdapter.start();
        if (this.fastAdapter != null) {
            this.fastAdapter.start();
        }
        this.isRunning = true;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void close() {
        if (!this.isRunning) {
            throw new IllegalStateException("Server is not started.");
        }
        try {
            if (this.fastAdapter != null) {
                this.fastAdapter.close();
            }
            this.reliableAdapter.close();
            this.isRunning = false;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while closing", e);
        }
    }

    @Override
    public void broadcast(Message message) {
        this.broadcast(null, message);
    }

    @Override
    public void broadcast(Filter<? super HostedConnection> filter, Message message) {
        FilterAdapter adapter;
        ByteBuffer buffer = MessageProtocol.messageToBuffer(message, null);
        FilterAdapter filterAdapter = adapter = filter == null ? null : new FilterAdapter(filter);
        if (message.isReliable() || this.fast == null) {
            this.reliable.broadcast(adapter, buffer, true, false);
        } else {
            this.fast.broadcast(adapter, buffer, false, false);
        }
    }

    @Override
    public HostedConnection getConnection(int id2) {
        return this.connections.get(id2);
    }

    @Override
    public Collection<HostedConnection> getConnections() {
        return Collections.unmodifiableCollection(this.connections.values());
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    @Override
    public void addMessageListener(MessageListener<? super HostedConnection> listener) {
        this.messageListeners.addMessageListener(listener);
    }

    @Override
    public void addMessageListener(MessageListener<? super HostedConnection> listener, Class ... classes) {
        this.messageListeners.addMessageListener(listener, classes);
    }

    @Override
    public void removeMessageListener(MessageListener<? super HostedConnection> listener) {
        this.messageListeners.removeMessageListener(listener);
    }

    @Override
    public void removeMessageListener(MessageListener<? super HostedConnection> listener, Class ... classes) {
        this.messageListeners.removeMessageListener(listener, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(HostedConnection source, Message m) {
        if (source == null) {
            this.messageListeners.messageReceived(source, m);
        } else {
            HostedConnection hostedConnection = source;
            synchronized (hostedConnection) {
                this.messageListeners.messageReceived(source, m);
            }
        }
    }

    protected void fireConnectionAdded(HostedConnection conn) {
        for (ConnectionListener l : this.connectionListeners) {
            l.connectionAdded(this, conn);
        }
    }

    protected void fireConnectionRemoved(HostedConnection conn) {
        for (ConnectionListener l : this.connectionListeners) {
            l.connectionRemoved(this, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerClient(KernelAdapter ka, Endpoint p, ClientRegistrationMessage m) {
        Connection addedConnection = null;
        Object bootedConnection = null;
        DefaultServer defaultServer = this;
        synchronized (defaultServer) {
            long tempId = m.getId();
            Connection c = this.connecting.remove(tempId);
            if (c == null) {
                c = new Connection();
                log.log(Level.FINE, "Registering client for endpoint, pass 1:{0}.", p);
            } else {
                log.log(Level.FINE, "Refining client registration for endpoint:{0}.", p);
            }
            if (ka == this.fastAdapter) {
                c.fast = p;
                if (c.reliable == null) {
                    this.connecting.put(tempId, c);
                }
            } else {
                c.reliable = p;
                if (!this.getGameName().equals(m.getGameName()) || this.getVersion() != m.getVersion()) {
                    log.log(Level.INFO, "Kicking client due to name/version mismatch:{0}.", c);
                    c.close("Server client mismatch, server:" + this.getGameName() + " v" + this.getVersion() + "  client:" + m.getGameName() + " v" + m.getVersion());
                    return;
                }
                if (c.fast == null && this.fastAdapter != null) {
                    this.connecting.put(tempId, c);
                }
            }
            if (!this.connecting.containsKey(tempId) && this.connections.put(c.getId(), c) == null) {
                if (c.fast != null) {
                    this.endpointConnections.put(c.fast, c);
                }
                this.endpointConnections.put(c.reliable, c);
                addedConnection = c;
            }
        }
        if (addedConnection != null) {
            log.log(Level.INFO, "Client registered:{0}.", addedConnection);
            m = new ClientRegistrationMessage();
            m.setId(addedConnection.getId());
            m.setReliable(true);
            addedConnection.send(m);
            this.fireConnectionAdded(addedConnection);
        }
    }

    protected HostedConnection getConnection(Endpoint endpoint) {
        return this.endpointConnections.get(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(Endpoint p) {
        log.log(Level.INFO, "Connection closed:{0}.", p);
        Connection removed = null;
        DefaultServer defaultServer = this;
        synchronized (defaultServer) {
            this.connecting.values().remove(p);
            removed = (Connection)this.endpointConnections.remove(p);
            if (removed != null) {
                this.connections.remove(removed.getId());
            }
        }
        if (removed != null) {
            log.log(Level.INFO, "Client closed:{0}.", removed);
            removed.closeConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FilterAdapter
    implements Filter<Endpoint> {
        private Filter<? super HostedConnection> delegate;

        public FilterAdapter(Filter<? super HostedConnection> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean apply(Endpoint input) {
            HostedConnection conn = DefaultServer.this.getConnection(input);
            if (conn == null) {
                return false;
            }
            return this.delegate.apply(conn);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Redispatch
    implements MessageListener<HostedConnection> {
        protected Redispatch() {
        }

        @Override
        public void messageReceived(HostedConnection source, Message m) {
            DefaultServer.this.dispatch(source, m);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Connection
    implements HostedConnection {
        private int id;
        private Endpoint reliable;
        private Endpoint fast;
        private boolean closed;
        private Map<String, Object> sessionData = new ConcurrentHashMap<String, Object>();

        public Connection() {
            this.id = DefaultServer.this.nextId.getAndIncrement();
        }

        @Override
        public Server getServer() {
            return DefaultServer.this;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getAddress() {
            return this.reliable == null ? null : this.reliable.getAddress();
        }

        @Override
        public void send(Message message) {
            ByteBuffer buffer = MessageProtocol.messageToBuffer(message, null);
            if (message.isReliable() || this.fast == null) {
                this.reliable.send(buffer);
            } else {
                this.fast.send(buffer);
            }
        }

        protected void closeConnection() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.reliable != null && this.reliable.isConnected()) {
                this.reliable.close();
            }
            if (this.fast != null && this.fast.isConnected()) {
                this.fast.close();
            }
            DefaultServer.this.fireConnectionRemoved(this);
        }

        @Override
        public void close(String reason) {
            DisconnectMessage m = new DisconnectMessage();
            m.setType("Kick");
            m.setReason(reason);
            m.setReliable(true);
            this.send(m);
            if (this.reliable != null) {
                this.reliable.close(true);
            }
        }

        @Override
        public Object setAttribute(String name, Object value) {
            if (value == null) {
                return this.sessionData.remove(name);
            }
            return this.sessionData.put(name, value);
        }

        @Override
        public <T> T getAttribute(String name) {
            return (T)this.sessionData.get(name);
        }

        @Override
        public Set<String> attributeNames() {
            return Collections.unmodifiableSet(this.sessionData.keySet());
        }

        public String toString() {
            return "Connection[ id=" + this.id + ", reliable=" + this.reliable + ", fast=" + this.fast + " ]";
        }
    }
}

