/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.niftygui;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.audio.AudioRenderer;
import com.jme3.input.InputManager;
import com.jme3.niftygui.InputSystemJme;
import com.jme3.niftygui.RenderDeviceJme;
import com.jme3.niftygui.SoundDeviceJme;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.sound.SoundDevice;
import de.lessvoid.nifty.tools.TimeProvider;
import de.lessvoid.nifty.tools.resourceloader.ResourceLoader;
import de.lessvoid.nifty.tools.resourceloader.ResourceLocation;
import java.io.InputStream;
import java.net.URL;

public class NiftyJmeDisplay
implements SceneProcessor {
    protected boolean inited = false;
    protected Nifty nifty;
    protected AssetManager assetManager;
    protected RenderManager renderManager;
    protected RenderDeviceJme renderDev;
    protected InputSystemJme inputSys;
    protected SoundDeviceJme soundDev;
    protected Renderer renderer;
    protected ViewPort vp;
    protected ResourceLocationJme resourceLocation;
    protected int w;
    protected int h;

    public NiftyJmeDisplay() {
    }

    public NiftyJmeDisplay(AssetManager assetManager, InputManager inputManager, AudioRenderer audioRenderer, ViewPort vp) {
        this.assetManager = assetManager;
        this.w = vp.getCamera().getWidth();
        this.h = vp.getCamera().getHeight();
        this.resourceLocation = new ResourceLocationJme();
        ResourceLoader.removeAllResourceLocations();
        ResourceLoader.addResourceLocation((ResourceLocation)this.resourceLocation);
        this.soundDev = new SoundDeviceJme(assetManager, audioRenderer);
        this.renderDev = new RenderDeviceJme(this);
        this.inputSys = new InputSystemJme(inputManager);
        if (inputManager != null) {
            inputManager.addRawInputListener(this.inputSys);
        }
        this.nifty = new Nifty((RenderDevice)this.renderDev, (SoundDevice)this.soundDev, (InputSystem)this.inputSys, new TimeProvider());
        this.inputSys.setNifty(this.nifty);
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        this.renderDev.setRenderManager(rm);
        this.inited = true;
        this.vp = vp;
        this.renderer = rm.getRenderer();
        this.inputSys.setHeight(vp.getCamera().getHeight());
    }

    public Nifty getNifty() {
        return this.nifty;
    }

    RenderDeviceJme getRenderDevice() {
        return this.renderDev;
    }

    AssetManager getAssetManager() {
        return this.assetManager;
    }

    RenderManager getRenderManager() {
        return this.renderManager;
    }

    int getHeight() {
        return this.h;
    }

    int getWidth() {
        return this.w;
    }

    Renderer getRenderer() {
        return this.renderer;
    }

    public void reshape(ViewPort vp, int w, int h) {
        this.w = w;
        this.h = h;
        this.inputSys.setHeight(h);
        this.nifty.resolutionChanged();
    }

    public boolean isInitialized() {
        return this.inited;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
        this.renderManager.setCamera(this.vp.getCamera(), true);
        this.nifty.render(false);
        this.renderManager.setCamera(this.vp.getCamera(), false);
    }

    public void postFrame(FrameBuffer out) {
    }

    public void cleanup() {
        this.inited = false;
    }

    protected class ResourceLocationJme
    implements ResourceLocation {
        protected ResourceLocationJme() {
        }

        public InputStream getResourceAsStream(String path) {
            AssetKey key = new AssetKey(path);
            AssetInfo info = NiftyJmeDisplay.this.assetManager.locateAsset(key);
            if (info != null) {
                return info.openStream();
            }
            throw new AssetNotFoundException(path);
        }

        public URL getResource(String path) {
            throw new UnsupportedOperationException();
        }
    }
}

