/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post;

import com.jme3.post.HDRRenderer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HDRConfig
extends JFrame {
    private float gamma;
    private float a;
    private float white;
    private int lod;
    private HDRRenderer hdrRender;
    private JComboBox jComboBox1;
    private JLabel lblA;
    private JLabel lblGamma;
    private JLabel lblLOD;
    private JLabel lblWhite;
    private JPanel pnlA;
    private JPanel pnlBright;
    private JPanel pnlGamma;
    private JPanel pnlLOD;
    private JSlider sldGamma;
    private JSlider sldLOD;
    private JSlider sldWhite;

    public HDRConfig(HDRRenderer hdrRender) {
        this.initComponents();
        this.hdrRender = hdrRender;
        this.sldWhiteStateChanged(null);
        this.sldGammaStateChanged(null);
        this.sldLODStateChanged(null);
        this.jComboBox1ActionPerformed(null);
    }

    public float getA() {
        return this.a;
    }

    public float getGamma() {
        return this.gamma;
    }

    public int getLod() {
        return this.lod;
    }

    public float getWhite() {
        return this.white;
    }

    private void updateHdr() {
        this.hdrRender.setWhiteLevel(this.getWhite());
        this.hdrRender.setThrottle(this.getLod());
        this.hdrRender.setExposure(this.getA());
    }

    private void initComponents() {
        this.pnlBright = new JPanel();
        this.lblWhite = new JLabel();
        this.sldWhite = new JSlider();
        this.pnlGamma = new JPanel();
        this.lblGamma = new JLabel();
        this.sldGamma = new JSlider();
        this.pnlA = new JPanel();
        this.lblA = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.pnlLOD = new JPanel();
        this.lblLOD = new JLabel();
        this.sldLOD = new JSlider();
        this.setDefaultCloseOperation(2);
        this.setTitle("HDR Configuration");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.lblWhite.setText("Maximum Brightness: ");
        this.pnlBright.add(this.lblWhite);
        this.sldWhite.setMaximum(1000);
        this.sldWhite.setValue(100);
        this.sldWhite.setPreferredSize(new Dimension(100, 23));
        this.sldWhite.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                HDRConfig.this.sldWhiteStateChanged(evt);
            }
        });
        this.pnlBright.add(this.sldWhite);
        this.getContentPane().add(this.pnlBright);
        this.lblGamma.setText("Output Gamma: ");
        this.pnlGamma.add(this.lblGamma);
        this.sldGamma.setMaximum(500);
        this.sldGamma.setMinimum(1);
        this.sldGamma.setValue(100);
        this.sldGamma.setPreferredSize(new Dimension(100, 23));
        this.sldGamma.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                HDRConfig.this.sldGammaStateChanged(evt);
            }
        });
        this.pnlGamma.add(this.sldGamma);
        this.getContentPane().add(this.pnlGamma);
        this.lblA.setText("Exposure: ");
        this.pnlA.add(this.lblA);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Dark", "Dim", "Normal", "Light"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HDRConfig.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.pnlA.add(this.jComboBox1);
        this.getContentPane().add(this.pnlA);
        this.lblLOD.setText("Leve of detail: ");
        this.pnlLOD.add(this.lblLOD);
        this.sldLOD.setMaximum(15);
        this.sldLOD.setMinimum(1);
        this.sldLOD.setValue(1);
        this.sldLOD.setPreferredSize(new Dimension(100, 23));
        this.sldLOD.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                HDRConfig.this.sldLODStateChanged(evt);
            }
        });
        this.pnlLOD.add(this.sldLOD);
        this.getContentPane().add(this.pnlLOD);
        this.pack();
    }

    private void sldWhiteStateChanged(ChangeEvent evt) {
        this.white = (float)this.sldWhite.getValue() / 100.0f;
        this.updateHdr();
    }

    private void sldGammaStateChanged(ChangeEvent evt) {
        this.gamma = (float)this.sldGamma.getValue() / 100.0f;
        this.updateHdr();
    }

    private void sldLODStateChanged(ChangeEvent evt) {
        this.lod = this.sldLOD.getValue();
        this.updateHdr();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        switch (this.jComboBox1.getSelectedIndex()) {
            case 0: {
                this.a = 0.09f;
                break;
            }
            case 1: {
                this.a = 0.18f;
                break;
            }
            case 2: {
                this.a = 0.36f;
                break;
            }
            case 3: {
                this.a = 0.72f;
            }
        }
        this.updateHdr();
    }
}

