/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import java.io.IOException;

public class ColorOverlayFilter
extends Filter {
    private ColorRGBA color = ColorRGBA.White;

    public ColorOverlayFilter() {
        super("Color Overlay");
    }

    public ColorOverlayFilter(ColorRGBA color) {
        this();
        this.color = color;
    }

    protected Material getMaterial() {
        this.material.setColor("Color", this.color);
        return this.material;
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public void setColor(ColorRGBA color) {
        this.color = color;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(manager, "Common/MatDefs/Post/Overlay.j3md");
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.color, "color", ColorRGBA.White);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.color = (ColorRGBA)ic.readSavable("color", ColorRGBA.White);
    }
}

