/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import java.io.IOException;

public class LightScatteringFilter
extends Filter {
    private Vector3f lightPosition;
    private Vector3f screenLightPos = new Vector3f();
    private int nbSamples = 50;
    private float blurStart = 0.02f;
    private float blurWidth = 0.9f;
    private float lightDensity = 1.4f;
    private boolean adaptative = true;
    Vector3f viewLightPos = new Vector3f();
    private boolean display = true;
    private float innerLightDensity;

    public LightScatteringFilter() {
        super("Light Scattering");
    }

    public LightScatteringFilter(Vector3f lightPosition) {
        this();
        this.lightPosition = lightPosition;
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    protected Material getMaterial() {
        this.material.setVector3("LightPosition", this.screenLightPos);
        this.material.setInt("NbSamples", this.nbSamples);
        this.material.setFloat("BlurStart", this.blurStart);
        this.material.setFloat("BlurWidth", this.blurWidth);
        this.material.setFloat("LightDensity", this.innerLightDensity);
        this.material.setBoolean("Display", this.display);
        return this.material;
    }

    protected void postQueue(RenderManager renderManager, ViewPort viewPort) {
        this.getClipCoordinates(this.lightPosition, this.screenLightPos, viewPort.getCamera());
        viewPort.getCamera().getViewMatrix().mult(this.lightPosition, this.viewLightPos);
        this.display = this.screenLightPos.x < 1.6f && this.screenLightPos.x > -0.6f && this.screenLightPos.y < 1.6f && this.screenLightPos.y > -0.6f && this.viewLightPos.z < 0.0f;
        this.innerLightDensity = this.adaptative ? Math.max(this.lightDensity - Math.max(this.screenLightPos.x, this.screenLightPos.y), 0.0f) : this.lightDensity;
    }

    private Vector3f getClipCoordinates(Vector3f worldPosition, Vector3f store, Camera cam) {
        float w = cam.getViewProjectionMatrix().multProj(worldPosition, store);
        store.divideLocal(w);
        store.x = (store.x + 1.0f) * (cam.getViewPortRight() - cam.getViewPortLeft()) / 2.0f + cam.getViewPortLeft();
        store.y = (store.y + 1.0f) * (cam.getViewPortTop() - cam.getViewPortBottom()) / 2.0f + cam.getViewPortBottom();
        store.z = (store.z + 1.0f) / 2.0f;
        return store;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(manager, "Common/MatDefs/Post/LightScattering.j3md");
    }

    public float getBlurStart() {
        return this.blurStart;
    }

    public void setBlurStart(float blurStart) {
        this.blurStart = blurStart;
    }

    public float getBlurWidth() {
        return this.blurWidth;
    }

    public void setBlurWidth(float blurWidth) {
        this.blurWidth = blurWidth;
    }

    public float getLightDensity() {
        return this.lightDensity;
    }

    public void setLightDensity(float lightDensity) {
        this.lightDensity = lightDensity;
    }

    public Vector3f getLightPosition() {
        return this.lightPosition;
    }

    public void setLightPosition(Vector3f lightPosition) {
        this.lightPosition = lightPosition;
    }

    public int getNbSamples() {
        return this.nbSamples;
    }

    public void setNbSamples(int nbSamples) {
        this.nbSamples = nbSamples;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.lightPosition, "lightPosition", Vector3f.ZERO);
        oc.write(this.nbSamples, "nbSamples", 50);
        oc.write(this.blurStart, "blurStart", 0.02f);
        oc.write(this.blurWidth, "blurWidth", 0.9f);
        oc.write(this.lightDensity, "lightDensity", 1.4f);
        oc.write(this.adaptative, "adaptative", true);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.lightPosition = (Vector3f)ic.readSavable("lightPosition", Vector3f.ZERO);
        this.nbSamples = ic.readInt("nbSamples", 50);
        this.blurStart = ic.readFloat("blurStart", 0.02f);
        this.blurWidth = ic.readFloat("blurWidth", 0.9f);
        this.lightDensity = ic.readFloat("lightDensity", 1.4f);
        this.adaptative = ic.readBoolean("adaptative", true);
    }
}

