/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer;

import com.jme3.renderer.GLObject;
import com.jme3.renderer.Renderer;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GLObjectManager {
    private static final Logger logger = Logger.getLogger(GLObjectManager.class.getName());
    private ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private ArrayList<GLObjectRef> refList = new ArrayList();

    public void registerForCleanup(GLObject obj) {
        GLObjectRef ref = new GLObjectRef(obj);
        this.refList.add(ref);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Registered: {0}", new String[]{obj.toString()});
        }
    }

    public void deleteUnused(Renderer r) {
        GLObjectRef ref;
        while ((ref = (GLObjectRef)this.refQueue.poll()) != null) {
            this.refList.remove(ref);
            ref.objClone.deleteObject(r);
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.log(Level.FINEST, "Deleted: {0}", ref.objClone);
        }
        return;
    }

    public void deleteAllObjects(Renderer r) {
        this.deleteUnused(r);
        for (GLObjectRef ref : this.refList) {
            ref.objClone.deleteObject(r);
            GLObject realObj = (GLObject)ref.realObj.get();
            if (realObj == null) continue;
            realObj.resetObject();
        }
        this.refList.clear();
    }

    public void resetObjects() {
        for (GLObjectRef ref : this.refList) {
            GLObject realObj = (GLObject)ref.realObj.get();
            if (realObj == null) continue;
            realObj.resetObject();
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.log(Level.FINEST, "Reset: {0}", realObj);
        }
        this.refList.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GLObjectRef
    extends PhantomReference<Object> {
        private GLObject objClone;
        private WeakReference<GLObject> realObj;

        public GLObjectRef(GLObject obj) {
            super(obj.handleRef, GLObjectManager.this.refQueue);
            assert (obj.handleRef != null);
            this.realObj = new WeakReference<GLObject>(obj);
            this.objClone = obj.createDestructableClone();
        }
    }
}

