/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.lwjgl;

import com.jme3.renderer.RendererException;
import com.jme3.texture.Image;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.ARBTextureMultisample;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLContext;

public class TextureUtil {
    private static boolean isFormatSupported(Image.Format fmt, ContextCapabilities caps) {
        switch (fmt) {
            case ARGB4444: {
                return false;
            }
            case BGR8: {
                return caps.OpenGL12 || caps.GL_EXT_bgra;
            }
            case DXT1: 
            case DXT1A: 
            case DXT3: 
            case DXT5: {
                return caps.GL_EXT_texture_compression_s3tc;
            }
            case Depth: 
            case Depth16: 
            case Depth24: 
            case Depth32: {
                return caps.OpenGL14 || caps.GL_ARB_depth_texture;
            }
            case Depth32F: 
            case Luminance16F: 
            case Luminance16FAlpha16F: 
            case Luminance32F: 
            case RGBA16F: 
            case RGBA32F: {
                return caps.OpenGL30 || caps.GL_ARB_texture_float;
            }
            case LATC: 
            case LTC: {
                return caps.GL_EXT_texture_compression_latc;
            }
            case RGB9E5: 
            case RGB16F_to_RGB9E5: {
                return caps.OpenGL30 || caps.GL_EXT_texture_shared_exponent;
            }
            case RGB111110F: 
            case RGB16F_to_RGB111110F: {
                return caps.OpenGL30 || caps.GL_EXT_packed_float;
            }
        }
        return true;
    }

    public static void checkFormatSupported(Image.Format fmt) {
        if (!TextureUtil.isFormatSupported(fmt, GLContext.getCapabilities())) {
            throw new RendererException("Image format '" + (Object)((Object)fmt) + "' is unsupported by the video hardware.");
        }
    }

    public static int convertTextureFormat(Image.Format fmt) {
        switch (fmt) {
            case Alpha16: {
                return 32830;
            }
            case Alpha8: {
                return 32828;
            }
            case DXT1: {
                return 33776;
            }
            case DXT1A: {
                return 33777;
            }
            case DXT3: {
                return 33778;
            }
            case DXT5: {
                return 33779;
            }
            case LATC: {
                return 35954;
            }
            case Depth: {
                return 6402;
            }
            case Depth16: {
                return 33189;
            }
            case Depth24: {
                return 33190;
            }
            case Depth32: {
                return 33191;
            }
            case Depth32F: {
                return 36012;
            }
            case Luminance8Alpha8: {
                return 32837;
            }
            case Luminance16Alpha16: {
                return 32840;
            }
            case Luminance16FAlpha16F: {
                return 34847;
            }
            case Intensity8: {
                return 32843;
            }
            case Intensity16: {
                return 32845;
            }
            case Luminance8: {
                return 32832;
            }
            case Luminance16: {
                return 32834;
            }
            case Luminance16F: {
                return 34846;
            }
            case Luminance32F: {
                return 34840;
            }
            case RGB10: {
                return 32850;
            }
            case RGB16: {
                return 32852;
            }
            case RGB111110F: {
                return 35898;
            }
            case RGB9E5: {
                return 35901;
            }
            case RGB16F: {
                return 34843;
            }
            case RGBA16F: {
                return 34842;
            }
            case RGB32F: {
                return 34837;
            }
            case RGB5A1: {
                return 32855;
            }
            case BGR8: {
                return 32849;
            }
            case RGB8: {
                return 32849;
            }
            case RGBA16: {
                return 32859;
            }
            case RGBA8: {
                return 32856;
            }
        }
        throw new UnsupportedOperationException("Unrecognized format: " + (Object)((Object)fmt));
    }

    public static void uploadTexture(Image img, int target, int index, int border, boolean tdc) {
        Image.Format fmt = img.getFormat();
        TextureUtil.checkFormatSupported(fmt);
        ByteBuffer data = index >= 0 && img.getData() != null && img.getData().size() > 0 ? img.getData(index) : null;
        int width = img.getWidth();
        int height = img.getHeight();
        int depth = img.getDepth();
        boolean compress = false;
        int internalFormat = -1;
        int format = -1;
        int dataType = -1;
        switch (fmt) {
            case Alpha16: {
                internalFormat = 32830;
                format = 6406;
                dataType = 5121;
                break;
            }
            case Alpha8: {
                internalFormat = 32828;
                format = 6406;
                dataType = 5121;
                break;
            }
            case DXT1: {
                compress = true;
                internalFormat = 33776;
                format = 6407;
                dataType = 5121;
                break;
            }
            case DXT1A: {
                compress = true;
                internalFormat = 33777;
                format = 6408;
                dataType = 5121;
                break;
            }
            case DXT3: {
                compress = true;
                internalFormat = 33778;
                format = 6408;
                dataType = 5121;
                break;
            }
            case DXT5: {
                compress = true;
                internalFormat = 33779;
                format = 6408;
                dataType = 5121;
                break;
            }
            case LATC: {
                compress = true;
                internalFormat = tdc ? 34871 : 35954;
                format = 6410;
                dataType = 5121;
                break;
            }
            case LTC: {
                compress = true;
                internalFormat = 35952;
                format = 6410;
                dataType = 5121;
                break;
            }
            case Depth: {
                internalFormat = 6402;
                format = 6402;
                dataType = 5121;
                break;
            }
            case Depth16: {
                internalFormat = 33189;
                format = 6402;
                dataType = 5121;
                break;
            }
            case Depth24: {
                internalFormat = 33190;
                format = 6402;
                dataType = 5121;
                break;
            }
            case Depth32: {
                internalFormat = 33191;
                format = 6402;
                dataType = 5121;
                break;
            }
            case Depth32F: {
                internalFormat = 36267;
                format = 6402;
                dataType = 5126;
                break;
            }
            case Luminance16FAlpha16F: {
                internalFormat = 34847;
                format = 6410;
                dataType = 5121;
                break;
            }
            case Intensity8: {
                internalFormat = 32843;
                format = 32841;
                dataType = 5121;
                break;
            }
            case Intensity16: {
                internalFormat = 32845;
                format = 32841;
                dataType = 5121;
                break;
            }
            case Luminance8: {
                internalFormat = 32832;
                format = 6409;
                dataType = 5121;
                break;
            }
            case Luminance8Alpha8: {
                internalFormat = 32837;
                format = 6410;
                dataType = 5121;
                break;
            }
            case Luminance16Alpha16: {
                internalFormat = 32840;
                format = 6410;
                dataType = 5121;
                break;
            }
            case Luminance16: {
                internalFormat = 32834;
                format = 6409;
                dataType = 5121;
                break;
            }
            case Luminance16F: {
                internalFormat = 34846;
                format = 6409;
                dataType = 5131;
                break;
            }
            case Luminance32F: {
                internalFormat = 34840;
                format = 6409;
                dataType = 5126;
                break;
            }
            case RGB10: {
                internalFormat = 32850;
                format = 6407;
                dataType = 5121;
                break;
            }
            case RGB16: {
                internalFormat = 32852;
                format = 6407;
                dataType = 5121;
                break;
            }
            case RGB111110F: {
                internalFormat = 35898;
                format = 6407;
                dataType = 35899;
                break;
            }
            case RGB16F_to_RGB111110F: {
                internalFormat = 35898;
                format = 6407;
                dataType = 5131;
                break;
            }
            case RGB16F_to_RGB9E5: {
                internalFormat = 35901;
                format = 6407;
                dataType = 5131;
                break;
            }
            case RGB9E5: {
                internalFormat = 35901;
                format = 6407;
                dataType = 35902;
                break;
            }
            case RGB16F: {
                internalFormat = 34843;
                format = 6407;
                dataType = 5131;
                break;
            }
            case RGBA16F: {
                internalFormat = 34842;
                format = 6408;
                dataType = 5131;
                break;
            }
            case RGB32F: {
                internalFormat = 34837;
                format = 6407;
                dataType = 5126;
                break;
            }
            case RGBA32F: {
                internalFormat = 34836;
                format = 6408;
                dataType = 5126;
                break;
            }
            case RGB5A1: {
                internalFormat = 32855;
                format = 6408;
                dataType = 5121;
                break;
            }
            case RGB8: {
                internalFormat = 32849;
                format = 6407;
                dataType = 5121;
                break;
            }
            case BGR8: {
                internalFormat = 32849;
                format = 32992;
                dataType = 5121;
                break;
            }
            case RGBA16: {
                internalFormat = 32859;
                format = 6408;
                dataType = 5121;
                break;
            }
            case RGBA8: {
                internalFormat = 32856;
                format = 6408;
                dataType = 5121;
                break;
            }
            case ABGR8: {
                internalFormat = 32856;
                format = 32768;
                dataType = 5121;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized format: " + (Object)((Object)fmt));
            }
        }
        if (data != null) {
            GL11.glPixelStorei((int)3317, (int)1);
        }
        int[] mipSizes = img.getMipMapSizes();
        int pos = 0;
        if (mipSizes == null) {
            mipSizes = data != null ? new int[]{data.capacity()} : new int[]{width * height * fmt.getBitsPerPixel() / 8};
        }
        boolean subtex = false;
        int samples = img.getMultiSamples();
        for (int i = 0; i < mipSizes.length; ++i) {
            int mipWidth = Math.max(1, width >> i);
            int mipHeight = Math.max(1, height >> i);
            int mipDepth = Math.max(1, depth >> i);
            if (data != null) {
                data.position(pos);
                data.limit(pos + mipSizes[i]);
            }
            if (compress && data != null) {
                if (target == 32879) {
                    GL13.glCompressedTexImage3D((int)target, (int)i, (int)internalFormat, (int)mipWidth, (int)mipHeight, (int)mipDepth, (int)border, (ByteBuffer)data);
                } else {
                    GL13.glCompressedTexImage2D((int)target, (int)i, (int)internalFormat, (int)mipWidth, (int)mipHeight, (int)border, (ByteBuffer)data);
                }
            } else if (target == 32879) {
                GL12.glTexImage3D((int)target, (int)i, (int)internalFormat, (int)mipWidth, (int)mipHeight, (int)mipDepth, (int)border, (int)format, (int)dataType, (ByteBuffer)data);
            } else if (target == 35866) {
                if (index == -1) {
                    GL12.glTexImage3D((int)target, (int)0, (int)internalFormat, (int)mipWidth, (int)mipHeight, (int)img.getData().size(), (int)border, (int)format, (int)dataType, (long)0L);
                } else {
                    GL12.glTexSubImage3D((int)target, (int)i, (int)0, (int)0, (int)index, (int)width, (int)height, (int)1, (int)format, (int)dataType, (ByteBuffer)data);
                }
            } else if (subtex) {
                if (samples > 1) {
                    throw new IllegalStateException("Cannot update multisample textures");
                }
                GL11.glTexSubImage2D((int)target, (int)i, (int)0, (int)0, (int)mipWidth, (int)mipHeight, (int)format, (int)dataType, (ByteBuffer)data);
            } else if (samples > 1) {
                ARBTextureMultisample.glTexImage2DMultisample((int)target, (int)samples, (int)internalFormat, (int)mipWidth, (int)mipHeight, (boolean)true);
            } else {
                GL11.glTexImage2D((int)target, (int)i, (int)internalFormat, (int)mipWidth, (int)mipHeight, (int)border, (int)format, (int)dataType, (ByteBuffer)data);
            }
            pos += mipSizes[i];
        }
    }
}

