/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.mesh;

import com.jme3.scene.Mesh;
import com.jme3.scene.mesh.IndexBuffer;
import java.nio.Buffer;

public class VirtualIndexBuffer
extends IndexBuffer {
    protected int numVerts = 0;
    protected int numIndices = 0;
    protected Mesh.Mode meshMode;

    public VirtualIndexBuffer(int numVerts, Mesh.Mode meshMode) {
        this.numVerts = numVerts;
        this.meshMode = meshMode;
        switch (meshMode) {
            case Points: {
                this.numIndices = numVerts;
                return;
            }
            case LineLoop: {
                this.numIndices = (numVerts - 1) * 2 + 1;
                return;
            }
            case LineStrip: {
                this.numIndices = (numVerts - 1) * 2;
                return;
            }
            case Lines: {
                this.numIndices = numVerts;
                return;
            }
            case TriangleFan: {
                this.numIndices = (numVerts - 2) * 3;
                return;
            }
            case TriangleStrip: {
                this.numIndices = (numVerts - 2) * 3;
                return;
            }
            case Triangles: {
                this.numIndices = numVerts;
                return;
            }
            case Hybrid: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public int get(int i) {
        if (this.meshMode == Mesh.Mode.Triangles || this.meshMode == Mesh.Mode.Lines || this.meshMode == Mesh.Mode.Points) {
            return i;
        }
        if (this.meshMode == Mesh.Mode.LineStrip) {
            return (i + 1) / 2;
        }
        if (this.meshMode == Mesh.Mode.LineLoop) {
            return i == this.numVerts - 1 ? 0 : (i + 1) / 2;
        }
        if (this.meshMode == Mesh.Mode.TriangleStrip) {
            boolean isBack;
            int triIndex = i / 3;
            int vertIndex = i % 3;
            boolean bl = isBack = i / 3 % 2 == 1;
            if (!isBack) {
                return triIndex + vertIndex;
            }
            switch (vertIndex) {
                case 0: {
                    return triIndex + 1;
                }
                case 1: {
                    return triIndex;
                }
                case 2: {
                    return triIndex + 2;
                }
            }
            throw new AssertionError();
        }
        if (this.meshMode == Mesh.Mode.TriangleFan) {
            int vertIndex = i % 3;
            if (vertIndex == 0) {
                return 0;
            }
            return i / 3 + vertIndex;
        }
        throw new UnsupportedOperationException();
    }

    public void put(int i, int value) {
        throw new UnsupportedOperationException("Does not represent index buffer");
    }

    public int size() {
        return this.numIndices;
    }

    public Buffer getBuffer() {
        return null;
    }
}

