/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.curves.BezierCurve;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArmatureHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ArmatureHelper.class.getName());
    protected Map<String, Integer> bonesMap = new HashMap<String, Integer>();
    protected Map<Bone, Long> bonesOMAs = new HashMap<Bone, Long>();
    protected List<BoneTransformationData> boneDataRoots = new ArrayList<BoneTransformationData>();

    public ArmatureHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public Long getBoneOMA(Bone bone) {
        Long result = this.bonesOMAs.get(bone);
        if (result == null) {
            result = 0L;
        }
        return result;
    }

    public Map<Integer, Integer> getGroupToBoneIndexMap(Structure defBaseStructure, BlenderContext blenderContext) throws BlenderFileException {
        HashMap<Integer, Integer> result = null;
        if (this.bonesMap != null && this.bonesMap.size() != 0) {
            result = new HashMap<Integer, Integer>();
            List<Structure> deformGroups = defBaseStructure.evaluateListBase(blenderContext);
            int groupIndex = 0;
            for (Structure deformGroup : deformGroups) {
                String deformGroupName = deformGroup.getFieldValue("name").toString();
                Integer boneIndex = this.bonesMap.get(deformGroupName);
                if (boneIndex != null) {
                    result.put(groupIndex, boneIndex);
                }
                ++groupIndex;
            }
        }
        return result;
    }

    protected Matrix4f getArmatureMatrix(Structure boneStructure) {
        DynamicArray boneMat = (DynamicArray)boneStructure.getFieldValue("arm_mat");
        Matrix4f m = new Matrix4f();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                m.set(i, j, ((Number)boneMat.get(j, i)).floatValue());
            }
        }
        if (this.fixUpAxis) {
            Vector3f translation = m.toTranslationVector();
            Quaternion rotation = m.toRotationQuat();
            float y = translation.y;
            translation.y = translation.z;
            translation.z = -y;
            rotation = this.upAxisRotationQuaternion.mult(rotation);
            m.setRotationQuaternion(rotation);
            m.setTranslation(translation);
        }
        return m;
    }

    public BoneTransformationData readBoneAndItsChildren(Structure boneStructure, BoneTransformationData parent, BlenderContext blenderContext) throws BlenderFileException {
        String name = boneStructure.getFieldValue("name").toString();
        Bone bone = new Bone(name);
        int bonesAmount = this.bonesOMAs.size();
        this.bonesOMAs.put(bone, boneStructure.getOldMemoryAddress());
        if (bonesAmount == this.bonesOMAs.size()) {
            throw new IllegalStateException("Two bones has the same hash value and thereforw a bone was overriden in the bones<->OMA map! Improve the hash algorithm!");
        }
        Matrix4f boneArmatureMatrix = this.getArmatureMatrix(boneStructure);
        DynamicArray sizeArray = (DynamicArray)boneStructure.getFieldValue("size");
        Vector3f size = new Vector3f(((Float)sizeArray.get(0)).floatValue(), ((Float)sizeArray.get(1)).floatValue(), ((Float)sizeArray.get(2)).floatValue());
        BoneTransformationData boneTransformationData = new BoneTransformationData(boneArmatureMatrix, size, bone, parent);
        blenderContext.addLoadedFeatures(boneStructure.getOldMemoryAddress(), name, boneStructure, bone);
        Structure childbase = (Structure)boneStructure.getFieldValue("childbase");
        List<Structure> children = childbase.evaluateListBase(blenderContext);
        for (Structure boneChild : children) {
            this.readBoneAndItsChildren(boneChild, boneTransformationData, blenderContext);
        }
        return boneTransformationData;
    }

    protected void assignBonesMatrices(BoneTransformationData btd, Matrix4f additionalRootBoneTransformation, List<Bone> boneList) {
        LOGGER.info("[" + btd.bone.getName() + "]  additionalRootBoneTransformation =\n" + additionalRootBoneTransformation);
        Matrix4f totalInverseParentMatrix = btd.parent != null ? btd.parent.totalInverseBoneParentMatrix : Matrix4f.IDENTITY;
        LOGGER.info("[" + btd.bone.getName() + "]  totalInverseParentMatrix =\n" + totalInverseParentMatrix);
        Matrix4f restMatrix = additionalRootBoneTransformation.mult(btd.boneArmatureMatrix);
        LOGGER.info("[" + btd.bone.getName() + "]  restMatrix =\n" + restMatrix);
        btd.totalInverseBoneParentMatrix = restMatrix.clone().invert();
        restMatrix = totalInverseParentMatrix.mult(restMatrix);
        LOGGER.info("[" + btd.bone.getName() + "]  resultMatrix =\n" + restMatrix);
        btd.bone.setBindTransforms(restMatrix.toTranslationVector(), restMatrix.toRotationQuat(), btd.size);
        boneList.add(btd.bone);
        this.bonesMap.put(btd.bone.getName(), boneList.size() - 1);
        if (btd.children != null && btd.children.size() > 0) {
            for (BoneTransformationData child : btd.children) {
                this.assignBonesMatrices(child, additionalRootBoneTransformation, boneList);
                btd.bone.addChild(child.bone);
            }
        }
    }

    public void addBoneDataRoot(BoneTransformationData dataRoot) {
        this.boneDataRoots.add(dataRoot);
    }

    public BoneTransformationData getBoneTransformationDataRoot(int index) {
        return this.boneDataRoots.get(index);
    }

    public int getBoneTransformationDataRootsSize() {
        return this.boneDataRoots.size();
    }

    public Bone[] buildBonesStructure(Long armatureOMA, Matrix4f additionalRootBoneTransformation) {
        ArrayList<Bone> bones = new ArrayList<Bone>(this.boneDataRoots.size() + 1);
        bones.add(new Bone(""));
        for (BoneTransformationData btd : this.boneDataRoots) {
            this.assignBonesMatrices(btd, additionalRootBoneTransformation, bones);
        }
        return bones.toArray(new Bone[bones.size()]);
    }

    @Override
    public void clearState() {
        this.bonesMap.clear();
        this.boneDataRoots.clear();
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }

    public BoneTrack[] getTracks(Structure actionStructure, BlenderContext blenderContext) throws BlenderFileException {
        if (this.blenderVersion < 250) {
            return this.getTracks249(actionStructure, blenderContext);
        }
        return this.getTracks250(actionStructure, blenderContext);
    }

    private BoneTrack[] getTracks250(Structure actionStructure, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.INFO, "Getting tracks!");
        int fps = blenderContext.getBlenderKey().getFps();
        Structure groups = (Structure)actionStructure.getFieldValue("groups");
        List<Structure> actionGroups = groups.evaluateListBase(blenderContext);
        if (actionGroups != null && actionGroups.size() > 0 && (this.bonesMap == null || this.bonesMap.size() == 0)) {
            throw new IllegalStateException("No bones found! Cannot proceed to calculating tracks!");
        }
        ArrayList<BoneTrack> tracks = new ArrayList<BoneTrack>();
        for (Structure actionGroup : actionGroups) {
            String name = actionGroup.getFieldValue("name").toString();
            Integer boneIndex = this.bonesMap.get(name);
            if (boneIndex == null) continue;
            List<Structure> channels = ((Structure)actionGroup.getFieldValue("channels")).evaluateListBase(blenderContext);
            BezierCurve[] bezierCurves = new BezierCurve[channels.size()];
            int channelCounter = 0;
            for (Structure c : channels) {
                BlenderInputStream bis = blenderContext.getInputStream();
                int currentPosition = bis.getPosition();
                Pointer pRnaPath = (Pointer)c.getFieldValue("rna_path");
                FileBlockHeader dataFileBlock = blenderContext.getFileBlock(pRnaPath.getOldMemoryAddress());
                bis.setPosition(dataFileBlock.getBlockPosition());
                String rnaPath = bis.readString();
                bis.setPosition(currentPosition);
                int arrayIndex = ((Number)c.getFieldValue("array_index")).intValue();
                int type = this.getCurveType(rnaPath, arrayIndex);
                Pointer pBezTriple = (Pointer)c.getFieldValue("bezt");
                List<Structure> bezTriples = pBezTriple.fetchData(blenderContext.getInputStream());
                bezierCurves[channelCounter++] = new BezierCurve(type, bezTriples, 2);
            }
            Ipo ipo = new Ipo(bezierCurves);
            tracks.add((BoneTrack)ipo.calculateTrack(boneIndex, 0, ipo.getLastFrame(), fps));
        }
        return tracks.toArray(new BoneTrack[tracks.size()]);
    }

    private BoneTrack[] getTracks249(Structure actionStructure, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.INFO, "Getting tracks!");
        IpoHelper ipoHelper = (IpoHelper)blenderContext.getHelper(IpoHelper.class);
        int fps = blenderContext.getBlenderKey().getFps();
        Structure chanbase = (Structure)actionStructure.getFieldValue("chanbase");
        List<Structure> actionChannels = chanbase.evaluateListBase(blenderContext);
        if (actionChannels != null && actionChannels.size() > 0 && (this.bonesMap == null || this.bonesMap.size() == 0)) {
            throw new IllegalStateException("No bones found! Cannot proceed to calculating tracks!");
        }
        ArrayList<BoneTrack> tracks = new ArrayList<BoneTrack>();
        for (Structure bActionChannel : actionChannels) {
            Pointer p;
            String name = bActionChannel.getFieldValue("name").toString();
            Integer boneIndex = this.bonesMap.get(name);
            if (boneIndex == null || (p = (Pointer)bActionChannel.getFieldValue("ipo")).isNull()) continue;
            Structure ipoStructure = p.fetchData(blenderContext.getInputStream()).get(0);
            Ipo ipo = ipoHelper.createIpo(ipoStructure, blenderContext);
            tracks.add((BoneTrack)ipo.calculateTrack(boneIndex, 0, ipo.getLastFrame(), fps));
        }
        return tracks.toArray(new BoneTrack[tracks.size()]);
    }

    protected int getCurveType(String rnaPath, int arrayIndex) {
        if (rnaPath.endsWith(".location")) {
            return 1 + arrayIndex;
        }
        if (rnaPath.endsWith(".rotation_quaternion")) {
            return 25 + arrayIndex;
        }
        if (rnaPath.endsWith(".scale")) {
            return 13 + arrayIndex;
        }
        throw new IllegalStateException("Unknown curve rna path: " + rnaPath);
    }

    public static class BoneTransformationData {
        private Matrix4f totalInverseBoneParentMatrix;
        private Matrix4f boneArmatureMatrix;
        private Vector3f size;
        private Bone bone;
        private BoneTransformationData parent;
        private List<BoneTransformationData> children;

        private BoneTransformationData(Matrix4f boneArmatureMatrix, Vector3f size, Bone bone, BoneTransformationData parent) {
            this.boneArmatureMatrix = boneArmatureMatrix;
            this.size = size;
            this.bone = bone;
            this.parent = parent;
            this.children = new ArrayList<BoneTransformationData>();
            if (this.parent != null) {
                this.parent.children.add(this);
            }
        }
    }
}

