/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.animation.BoneTrack;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintDistLimit
extends Constraint {
    private static final int LIMITDIST_INSIDE = 0;
    private static final int LIMITDIST_OUTSIDE = 1;
    private static final int LIMITDIST_ONSURFACE = 2;

    public ConstraintDistLimit(Structure constraintStructure, Long boneOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, boneOMA, influenceIpo, blenderContext);
    }

    public void affectAnimation(Animation animation, int targetIndex) {
        Vector3f targetLocation = this.getTargetLocation();
        BoneTrack boneTrack = (BoneTrack)this.getTrack(animation, targetIndex);
        if (boneTrack != null) {
            float dist = ((Number)this.data.getFieldValue("dist")).floatValue();
            int mode = ((Number)this.data.getFieldValue("mode")).intValue();
            int maxFrames = boneTrack.getTimes().length;
            Vector3f[] translations = boneTrack.getTranslations();
            for (int frame = 0; frame < maxFrames; ++frame) {
                Vector3f v = translations[frame].subtract(targetLocation);
                float currentDistance = v.length();
                float influence = this.ipo.calculateValue(frame);
                float modifier = 0.0f;
                switch (mode) {
                    case 0: {
                        if (!(currentDistance >= dist)) break;
                        modifier = (dist - currentDistance) / currentDistance;
                        break;
                    }
                    case 2: {
                        modifier = (dist - currentDistance) / currentDistance;
                        break;
                    }
                    case 1: {
                        if (!(currentDistance <= dist)) break;
                        modifier = (dist - currentDistance) / currentDistance;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown distance limit constraint mode: " + mode);
                    }
                }
                translations[frame].addLocal(v.multLocal(modifier * influence));
            }
            boneTrack.setKeyframes(boneTrack.getTimes(), translations, boneTrack.getRotations(), boneTrack.getScales());
        }
    }

    public ConstraintType getType() {
        return ConstraintType.CONSTRAINT_TYPE_DISTLIMIT;
    }
}

