/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.modifiers.ArmatureModifier;
import com.jme3.scene.plugins.blender.modifiers.ArrayModifier;
import com.jme3.scene.plugins.blender.modifiers.MirrorModifier;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.modifiers.ObjectAnimationModifier;
import com.jme3.scene.plugins.blender.modifiers.ParticlesModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifierHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ModifierHelper.class.getName());

    public ModifierHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public Collection<Modifier> readModifiers(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        Structure modifiersListBase = (Structure)objectStructure.getFieldValue("modifiers");
        List<Structure> modifiers = modifiersListBase.evaluateListBase(blenderContext);
        for (Structure modifierStructure : modifiers) {
            Modifier modifier = null;
            if ("ArrayModifierData".equals(modifierStructure.getType())) {
                modifier = new ArrayModifier(modifierStructure, blenderContext);
            } else if ("MirrorModifierData".equals(modifierStructure.getType())) {
                modifier = new MirrorModifier(modifierStructure, blenderContext);
            } else if ("ArmatureModifierData".equals(modifierStructure.getType())) {
                modifier = new ArmatureModifier(objectStructure, modifierStructure, blenderContext);
            } else if ("ParticleSystemModifierData".equals(modifierStructure.getType())) {
                modifier = new ParticlesModifier(modifierStructure, blenderContext);
            }
            if (modifier != null) {
                result.add(modifier);
                blenderContext.addModifier(objectStructure.getOldMemoryAddress(), modifier);
                continue;
            }
            LOGGER.log(Level.WARNING, "Unsupported modifier type: {0}", modifierStructure.getType());
        }
        Pointer pIpo = (Pointer)objectStructure.getFieldValue("ipo");
        if (pIpo.isNotNull()) {
            ObjectAnimationModifier modifier = new ObjectAnimationModifier(objectStructure, blenderContext);
            result.add(modifier);
            blenderContext.addModifier(objectStructure.getOldMemoryAddress(), modifier);
        }
        return result;
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }
}

