/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TextureGeneratorMusgrave
extends TextureGenerator {
    public TextureGeneratorMusgrave(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, int depth, BlenderContext blenderContext) {
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        TexturePixel texres = new TexturePixel();
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        int halfW = width >> 1;
        int halfH = height >> 1;
        int halfD = depth >> 1;
        int index = 0;
        float wDelta = 1.0f / (float)halfW;
        float hDelta = 1.0f / (float)halfH;
        float dDelta = 1.0f / (float)halfD;
        float[][] colorBand = this.computeColorband(tex, blenderContext);
        Image.Format format = colorBand != null ? Image.Format.RGBA8 : Image.Format.Luminance8;
        int bytesPerPixel = colorBand != null ? 4 : 1;
        MusgraveData musgraveData = new MusgraveData(tex);
        TextureGenerator.BrightnessAndContrastData bacd = new TextureGenerator.BrightnessAndContrastData(tex);
        byte[] data = new byte[width * height * depth * bytesPerPixel];
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i / noisesize;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j / noisesize;
                for (int k = -halfD; k < halfD; ++k) {
                    texvec[2] = dDelta * (float)k / noisesize;
                    NoiseGenerator.MusgraveFunction musgraveFunction = NoiseGenerator.musgraveFunctions.get(musgraveData.stype);
                    if (musgraveFunction == null) {
                        throw new IllegalStateException("Unknown type of musgrave texture: " + stype);
                    }
                    texres.intensity = musgraveData.outscale * musgraveFunction.execute(musgraveData, texvec[0], texvec[1], texvec[2]);
                    if (texres.intensity > 1.0f) {
                        texres.intensity = 1.0f;
                    } else if (texres.intensity < 0.0f) {
                        texres.intensity = 0.0f;
                    }
                    if (colorBand != null) {
                        int colorbandIndex = (int)(texres.intensity * 1000.0f);
                        texres.red = colorBand[colorbandIndex][0];
                        texres.green = colorBand[colorbandIndex][1];
                        texres.blue = colorBand[colorbandIndex][2];
                        this.applyBrightnessAndContrast(texres, bacd.contrast, bacd.brightness);
                        data[index++] = (byte)(texres.red * 255.0f);
                        data[index++] = (byte)(texres.green * 255.0f);
                        data[index++] = (byte)(texres.blue * 255.0f);
                        data[index++] = (byte)(colorBand[colorbandIndex][3] * 255.0f);
                        continue;
                    }
                    this.applyBrightnessAndContrast(bacd, texres);
                    data[index++] = (byte)(texres.intensity * 255.0f);
                }
            }
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(BufferUtils.createByteBuffer(data));
        return new Texture3D(new Image(format, width, height, depth, dataArray));
    }

    protected static class MusgraveData {
        public final int stype;
        public final float outscale;
        public final float h;
        public final float lacunarity;
        public final float octaves;
        public final int noisebasis;
        public final float offset;
        public final float gain;

        public MusgraveData(Structure tex) {
            this.stype = ((Number)tex.getFieldValue("stype")).intValue();
            this.outscale = ((Number)tex.getFieldValue("ns_outscale")).floatValue();
            this.h = ((Number)tex.getFieldValue("mg_H")).floatValue();
            this.lacunarity = ((Number)tex.getFieldValue("mg_lacunarity")).floatValue();
            this.octaves = ((Number)tex.getFieldValue("mg_octaves")).floatValue();
            this.noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
            this.offset = ((Number)tex.getFieldValue("mg_offset")).floatValue();
            this.gain = ((Number)tex.getFieldValue("mg_gain")).floatValue();
        }
    }
}

