/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.textures.UVCoordinatesGenerator;
import java.nio.FloatBuffer;

class UVProjectionGenerator {
    UVProjectionGenerator() {
    }

    public static float[] flatProjection(Mesh mesh, BoundingBox bb) {
        if (bb == null) {
            bb = UVCoordinatesGenerator.getBoundingBox(mesh);
        }
        Vector3f min = bb.getMin(null);
        float[] ext = new float[]{bb.getXExtent() * 2.0f, bb.getYExtent() * 2.0f};
        FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        float[] uvCoordinates = new float[positions.limit() / 3 * 2];
        int i = 0;
        int j = 0;
        while (i < positions.limit()) {
            uvCoordinates[j] = (positions.get(i) - min.x) / ext[0];
            uvCoordinates[j + 1] = (positions.get(i + 1) - min.y) / ext[1];
            i += 3;
            j += 2;
        }
        return uvCoordinates;
    }

    public static float[] cubeProjection(Mesh mesh, BoundingBox bb) {
        Triangle triangle = new Triangle();
        Vector3f x = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f y = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f z = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f min = bb.getMin(null);
        float[] ext = new float[]{bb.getXExtent() * 2.0f, bb.getYExtent() * 2.0f, bb.getZExtent() * 2.0f};
        float[] uvCoordinates = new float[mesh.getTriangleCount() * 6];
        float borderAngle = (float)Math.sqrt(2.0) / 2.0f;
        int pointIndex = 0;
        for (int i = 0; i < mesh.getTriangleCount(); ++i) {
            mesh.getTriangle(i, triangle);
            Vector3f n = triangle.getNormal();
            float dotNX = Math.abs(n.dot(x));
            float dorNY = Math.abs(n.dot(y));
            float dotNZ = Math.abs(n.dot(z));
            if (dotNX > borderAngle) {
                if (dotNZ < borderAngle) {
                    uvCoordinates[pointIndex++] = (triangle.get1().y - min.y) / ext[1];
                    uvCoordinates[pointIndex++] = (triangle.get1().z - min.z) / ext[2];
                    uvCoordinates[pointIndex++] = (triangle.get2().y - min.y) / ext[1];
                    uvCoordinates[pointIndex++] = (triangle.get2().z - min.z) / ext[2];
                    uvCoordinates[pointIndex++] = (triangle.get3().y - min.y) / ext[1];
                    uvCoordinates[pointIndex++] = (triangle.get3().z - min.z) / ext[2];
                } else {
                    uvCoordinates[pointIndex++] = (triangle.get1().x - min.x) / ext[0];
                    uvCoordinates[pointIndex++] = (triangle.get1().y - min.y) / ext[1];
                    uvCoordinates[pointIndex++] = (triangle.get2().x - min.x) / ext[0];
                    uvCoordinates[pointIndex++] = (triangle.get2().y - min.y) / ext[1];
                    uvCoordinates[pointIndex++] = (triangle.get3().x - min.x) / ext[0];
                    uvCoordinates[pointIndex++] = (triangle.get3().y - min.y) / ext[1];
                }
            } else if (dorNY > borderAngle) {
                uvCoordinates[pointIndex++] = (triangle.get1().x - min.x) / ext[0];
                uvCoordinates[pointIndex++] = (triangle.get1().z - min.z) / ext[2];
                uvCoordinates[pointIndex++] = (triangle.get2().x - min.x) / ext[0];
                uvCoordinates[pointIndex++] = (triangle.get2().z - min.z) / ext[2];
                uvCoordinates[pointIndex++] = (triangle.get3().x - min.x) / ext[0];
                uvCoordinates[pointIndex++] = (triangle.get3().z - min.z) / ext[2];
            } else {
                uvCoordinates[pointIndex++] = (triangle.get1().x - min.x) / ext[0];
                uvCoordinates[pointIndex++] = (triangle.get1().y - min.y) / ext[1];
                uvCoordinates[pointIndex++] = (triangle.get2().x - min.x) / ext[0];
                uvCoordinates[pointIndex++] = (triangle.get2().y - min.y) / ext[1];
                uvCoordinates[pointIndex++] = (triangle.get3().x - min.x) / ext[0];
                uvCoordinates[pointIndex++] = (triangle.get3().y - min.y) / ext[1];
            }
            triangle.setNormal(null);
        }
        return uvCoordinates;
    }

    public static float[] tubeProjection(Mesh mesh, UVCoordinatesGenerator.BoundingTube bt) {
        FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        float[] uvCoordinates = new float[positions.limit() / 3 * 2];
        Vector3f v = new Vector3f();
        float cx = bt.getCenter().x;
        float cy = bt.getCenter().y;
        Vector3f uBase = new Vector3f(0.0f, -1.0f, 0.0f);
        float vBase = bt.getCenter().z - bt.getHeight() * 0.5f;
        int i = 0;
        int j = 0;
        while (i < positions.limit()) {
            v.set(positions.get(i) - cx, positions.get(i + 1) - cy, 0.0f);
            v.normalizeLocal();
            float angle = v.angleBetween(uBase);
            if (v.x < 0.0f) {
                angle = (float)Math.PI * 2 - angle;
            }
            uvCoordinates[j] = angle / ((float)Math.PI * 2);
            float z = positions.get(i + 2);
            uvCoordinates[j + 1] = (z - vBase) / bt.getHeight();
            i += 3;
            j += 2;
        }
        Triangle triangle = new Triangle();
        for (int i2 = 0; i2 < mesh.getTriangleCount(); ++i2) {
            mesh.getTriangle(i2, triangle);
            float sgn1 = Math.signum(triangle.get1().x - cx);
            float sgn2 = Math.signum(triangle.get2().x - cx);
            float sgn3 = Math.signum(triangle.get3().x - cx);
            float xSideFactor = sgn1 + sgn2 + sgn3;
            float ySideFactor = Math.signum(triangle.get1().y - cy) + Math.signum(triangle.get2().y - cy) + Math.signum(triangle.get3().y - cy);
            if (!(xSideFactor > -3.0f) && !(xSideFactor < 3.0f) || !(ySideFactor < 0.0f)) continue;
            if (sgn1 == 1.0f) {
                int n = i2 * 3 * 2;
                uvCoordinates[n] = uvCoordinates[n] + 1.0f;
            }
            if (sgn2 == 1.0f) {
                int n = (i2 * 3 + 1) * 2;
                uvCoordinates[n] = uvCoordinates[n] + 1.0f;
            }
            if (sgn3 != 1.0f) continue;
            int n = (i2 * 3 + 2) * 2;
            uvCoordinates[n] = uvCoordinates[n] + 1.0f;
        }
        return uvCoordinates;
    }

    public static float[] sphereProjection(Mesh mesh, BoundingSphere bs) {
        FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        float[] uvCoordinates = new float[positions.limit() / 3 * 2];
        Vector3f v = new Vector3f();
        float cx = bs.getCenter().x;
        float cy = bs.getCenter().y;
        float cz = bs.getCenter().z;
        Vector3f uBase = new Vector3f(0.0f, -1.0f, 0.0f);
        Vector3f vBase = new Vector3f(0.0f, 0.0f, -1.0f);
        int i = 0;
        int j = 0;
        while (i < positions.limit()) {
            v.set(positions.get(i) - cx, positions.get(i + 1) - cy, 0.0f);
            v.normalizeLocal();
            float angle = v.angleBetween(uBase);
            if (v.x < 0.0f) {
                angle = (float)Math.PI * 2 - angle;
            }
            uvCoordinates[j] = angle / ((float)Math.PI * 2);
            v.set(positions.get(i) - cx, positions.get(i + 1) - cy, positions.get(i + 2) - cz);
            v.normalizeLocal();
            angle = v.angleBetween(vBase);
            uvCoordinates[j + 1] = angle / (float)Math.PI;
            i += 3;
            j += 2;
        }
        Triangle triangle = new Triangle();
        for (int i2 = 0; i2 < mesh.getTriangleCount(); ++i2) {
            mesh.getTriangle(i2, triangle);
            float sgn1 = Math.signum(triangle.get1().x - cx);
            float sgn2 = Math.signum(triangle.get2().x - cx);
            float sgn3 = Math.signum(triangle.get3().x - cx);
            float xSideFactor = sgn1 + sgn2 + sgn3;
            float ySideFactor = Math.signum(triangle.get1().y - cy) + Math.signum(triangle.get2().y - cy) + Math.signum(triangle.get3().y - cy);
            if (!(xSideFactor > -3.0f) && !(xSideFactor < 3.0f) || !(ySideFactor < 0.0f)) continue;
            if (sgn1 == 1.0f) {
                int n = i2 * 3 * 2;
                uvCoordinates[n] = uvCoordinates[n] + 1.0f;
            }
            if (sgn2 == 1.0f) {
                int n = (i2 * 3 + 1) * 2;
                uvCoordinates[n] = uvCoordinates[n] + 1.0f;
            }
            if (sgn3 != 1.0f) continue;
            int n = (i2 * 3 + 2) * 2;
            uvCoordinates[n] = uvCoordinates[n] + 1.0f;
        }
        return uvCoordinates;
    }
}

