/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.AbstractBox;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;

public class StripBox
extends AbstractBox {
    private static final short[] GEOMETRY_INDICES_DATA = new short[]{1, 0, 4, 5, 7, 0, 3, 1, 2, 4, 6, 7, 2, 3};
    private static final float[] GEOMETRY_TEXTURE_DATA = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};

    public StripBox(float x, float y, float z) {
        this.updateGeometry(Vector3f.ZERO, x, y, z);
    }

    public StripBox(Vector3f center, float x, float y, float z) {
        this.updateGeometry(center, x, y, z);
    }

    public StripBox(Vector3f min, Vector3f max) {
        this.updateGeometry(min, max);
    }

    public StripBox() {
    }

    public StripBox clone() {
        return new StripBox(this.center.clone(), this.xExtent, this.yExtent, this.zExtent);
    }

    protected void duUpdateGeometryIndices() {
        if (this.getBuffer(VertexBuffer.Type.Index) == null) {
            this.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createShortBuffer(GEOMETRY_INDICES_DATA));
        }
    }

    protected void duUpdateGeometryNormals() {
        if (this.getBuffer(VertexBuffer.Type.Normal) == null) {
            float[] normals = new float[24];
            Vector3f[] vert = this.computeVertices();
            Vector3f norm = new Vector3f();
            for (int i = 0; i < 8; ++i) {
                norm.set(vert[i]).normalizeLocal();
                normals[i * 3 + 0] = norm.x;
                normals[i * 3 + 1] = norm.x;
                normals[i * 3 + 2] = norm.x;
            }
            this.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer(normals));
        }
    }

    protected void duUpdateGeometryTextures() {
        if (this.getBuffer(VertexBuffer.Type.TexCoord) == null) {
            this.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer(GEOMETRY_TEXTURE_DATA));
        }
    }

    protected void duUpdateGeometryVertices() {
        FloatBuffer fpb = BufferUtils.createVector3Buffer(24);
        Vector3f[] v = this.computeVertices();
        fpb.put(new float[]{v[0].x, v[0].y, v[0].z, v[1].x, v[1].y, v[1].z, v[2].x, v[2].y, v[2].z, v[3].x, v[3].y, v[3].z, v[4].x, v[4].y, v[4].z, v[5].x, v[5].y, v[5].z, v[6].x, v[6].y, v[6].z, v[7].x, v[7].y, v[7].z});
        this.setBuffer(VertexBuffer.Type.Position, 3, fpb);
        this.setMode(Mesh.Mode.TriangleStrip);
        this.updateBound();
    }
}

