/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.math.CurveAndSurfaceMath;
import com.jme3.math.FastMath;
import com.jme3.math.Spline;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Surface
extends Mesh {
    private Spline.SplineType type;
    private List<List<Vector4f>> controlPoints;
    private List<Float>[] knots;
    private int basisUFunctionDegree;
    private int basisVFunctionDegree;
    private int uSegments;
    private int vSegments;

    private Surface(List<List<Vector4f>> controlPoints, List<Float>[] nurbKnots, int uSegments, int vSegments, int basisUFunctionDegree, int basisVFunctionDegree) {
        this.validateInputData(controlPoints, nurbKnots, uSegments, vSegments);
        this.type = Spline.SplineType.Nurb;
        this.uSegments = uSegments;
        this.vSegments = vSegments;
        this.controlPoints = controlPoints;
        this.knots = nurbKnots;
        this.basisUFunctionDegree = basisUFunctionDegree;
        CurveAndSurfaceMath.prepareNurbsKnots(nurbKnots[0], basisUFunctionDegree);
        if (nurbKnots[1] != null) {
            this.basisVFunctionDegree = basisVFunctionDegree;
            CurveAndSurfaceMath.prepareNurbsKnots(nurbKnots[1], basisVFunctionDegree);
        }
        this.buildSurface();
    }

    public static final Surface createNurbsSurface(List<List<Vector4f>> controlPoints, List<Float>[] nurbKnots, int uSegments, int vSegments, int basisUFunctionDegree, int basisVFunctionDegree) {
        Surface result = new Surface(controlPoints, nurbKnots, uSegments, vSegments, basisUFunctionDegree, basisVFunctionDegree);
        result.type = Spline.SplineType.Nurb;
        return result;
    }

    private void buildSurface() {
        boolean smooth = true;
        float minUKnot = this.getMinUNurbKnot();
        float maxUKnot = this.getMaxUNurbKnot();
        float deltaU = (maxUKnot - minUKnot) / (float)this.uSegments;
        float minVKnot = this.getMinVNurbKnot();
        float maxVKnot = this.getMaxVNurbKnot();
        float deltaV = (maxVKnot - minVKnot) / (float)this.vSegments;
        Vector3f[] vertices = new Vector3f[(this.uSegments + 1) * (this.vSegments + 1)];
        float u = minUKnot;
        float v = minVKnot;
        int arrayIndex = 0;
        for (int i = 0; i <= this.vSegments; ++i) {
            for (int j = 0; j <= this.uSegments; ++j) {
                Vector3f interpolationResult = new Vector3f();
                CurveAndSurfaceMath.interpolate(u, v, this.controlPoints, this.knots, this.basisUFunctionDegree, this.basisVFunctionDegree, interpolationResult);
                vertices[arrayIndex++] = interpolationResult;
                u += deltaU;
            }
            u = minUKnot;
            v += deltaV;
        }
        int uVerticesAmount = this.uSegments + 1;
        int[] indices = new int[this.uSegments * this.vSegments * 6];
        arrayIndex = 0;
        for (int i = 0; i < this.vSegments; ++i) {
            for (int j = 0; j < this.uSegments; ++j) {
                indices[arrayIndex++] = j + i * uVerticesAmount;
                indices[arrayIndex++] = j + i * uVerticesAmount + 1;
                indices[arrayIndex++] = j + i * uVerticesAmount + uVerticesAmount;
                indices[arrayIndex++] = j + i * uVerticesAmount + 1;
                indices[arrayIndex++] = j + i * uVerticesAmount + uVerticesAmount + 1;
                indices[arrayIndex++] = j + i * uVerticesAmount + uVerticesAmount;
            }
        }
        HashMap<Vector3f, Vector3f> normalMap = new HashMap<Vector3f, Vector3f>(vertices.length);
        for (int i = 0; i < indices.length; i += 3) {
            Vector3f n = FastMath.computeNormal(vertices[indices[i]], vertices[indices[i + 1]], vertices[indices[i + 2]]);
            this.addNormal(n, normalMap, smooth, vertices[indices[i]], vertices[indices[i + 1]], vertices[indices[i + 2]]);
        }
        float[] normals = new float[vertices.length * 3];
        arrayIndex = 0;
        for (int i = 0; i < vertices.length; ++i) {
            Vector3f n = (Vector3f)normalMap.get(vertices[i]);
            normals[arrayIndex++] = n.x;
            normals[arrayIndex++] = n.y;
            normals[arrayIndex++] = n.z;
        }
        this.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer(vertices));
        this.setBuffer(VertexBuffer.Type.Index, 3, indices);
        this.setBuffer(VertexBuffer.Type.Normal, 3, normals);
        this.updateBound();
        this.updateCounts();
    }

    public List<List<Vector4f>> getControlPoints() {
        return this.controlPoints;
    }

    public int getUControlPointsAmount() {
        return this.controlPoints.size();
    }

    public int getVControlPointsAmount() {
        return this.controlPoints.get(0) == null ? 0 : this.controlPoints.get(0).size();
    }

    public int getBasisUFunctionDegree() {
        return this.basisUFunctionDegree;
    }

    public int getBasisVFunctionDegree() {
        return this.basisVFunctionDegree;
    }

    public List<Float> getKnots(int dim) {
        return this.knots[dim];
    }

    public Spline.SplineType getType() {
        return this.type;
    }

    private float getMinUNurbKnot() {
        return this.knots[0].get(this.basisUFunctionDegree - 1).floatValue();
    }

    private float getMaxUNurbKnot() {
        return this.knots[0].get(this.knots[0].size() - this.basisUFunctionDegree).floatValue();
    }

    private float getMinVNurbKnot() {
        return this.knots[1].get(this.basisVFunctionDegree - 1).floatValue();
    }

    private float getMaxVNurbKnot() {
        return this.knots[1].get(this.knots[1].size() - this.basisVFunctionDegree).floatValue();
    }

    private void addNormal(Vector3f normalToAdd, Map<Vector3f, Vector3f> normalMap, boolean smooth, Vector3f ... vertices) {
        for (Vector3f v : vertices) {
            Vector3f n = normalMap.get(v);
            if (!smooth || n == null) {
                normalMap.put(v, normalToAdd.clone());
                continue;
            }
            n.addLocal(normalToAdd).normalizeLocal();
        }
    }

    private void validateInputData(List<List<Vector4f>> controlPoints, List<Float>[] nurbKnots, int uSegments, int vSegments) {
        int i;
        int uPointsAmount = controlPoints.get(0).size();
        for (i = 1; i < controlPoints.size(); ++i) {
            if (controlPoints.get(i).size() == uPointsAmount) continue;
            throw new IllegalArgumentException("The amount of 'U' control points is invalid!");
        }
        if (uSegments <= 0) {
            throw new IllegalArgumentException("U segments amount should be positive!");
        }
        if (vSegments < 0) {
            throw new IllegalArgumentException("V segments amount cannot be negative!");
        }
        if (nurbKnots.length != 2) {
            throw new IllegalArgumentException("Nurb surface should have two rows of knots!");
        }
        for (i = 0; i < nurbKnots.length; ++i) {
            for (int j = 0; j < nurbKnots[i].size() - 1; ++j) {
                if (!(nurbKnots[i].get(j).floatValue() > nurbKnots[i].get(j + 1).floatValue())) continue;
                throw new IllegalArgumentException("The knots' values cannot decrease!");
            }
        }
    }
}

