/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.android;

import android.app.Activity;
import android.content.Context;
import android.opengl.GLSurfaceView;
import com.jme3.app.AndroidHarness;
import com.jme3.app.Application;
import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.android.AndroidInput;
import com.jme3.input.controls.TouchTrigger;
import com.jme3.input.dummy.DummyKeyInput;
import com.jme3.input.dummy.DummyMouseInput;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.android.OGLESShaderRenderer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import com.jme3.system.android.AndroidConfigChooser;
import com.jme3.system.android.AndroidTimer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class OGLESContext
implements JmeContext,
GLSurfaceView.Renderer {
    private static final Logger logger = Logger.getLogger(OGLESContext.class.getName());
    protected final AtomicBoolean created = new AtomicBoolean(false);
    protected final AtomicBoolean renderable = new AtomicBoolean(false);
    protected final AtomicBoolean needClose = new AtomicBoolean(false);
    protected final AppSettings settings = new AppSettings(true);
    protected OGLESShaderRenderer renderer;
    protected Timer timer;
    protected SystemListener listener;
    protected boolean wasActive = false;
    protected boolean autoFlush = true;
    protected AndroidInput view;
    private long milliStart;
    private long milliDelta;
    protected int frameRate = 33;
    protected int minFrameDuration = 0;
    protected int clientOpenGLESVersion = 1;
    protected boolean verboseLogging = false;
    private final String ESCAPE_EVENT = "TouchEscape";

    @Override
    public JmeContext.Type getType() {
        return JmeContext.Type.Display;
    }

    public GLSurfaceView createView(Activity activity) {
        return this.createView(new AndroidInput((Context)activity));
    }

    public GLSurfaceView createView(AndroidInput view) {
        return this.createView(view, AndroidConfigChooser.ConfigType.FASTEST, false);
    }

    public GLSurfaceView createView(AndroidInput view, AndroidConfigChooser.ConfigType configType, boolean eglConfigVerboseLogging) {
        this.view = view;
        this.verboseLogging = eglConfigVerboseLogging;
        if (configType == AndroidConfigChooser.ConfigType.LEGACY) {
            this.clientOpenGLESVersion = 2;
            view.setEGLContextClientVersion(2);
            logger.info("ConfigType.LEGACY using RGB565");
            view.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
            view.getHolder().setFormat(-3);
            view.setZOrderOnTop(true);
        } else {
            AndroidConfigChooser configChooser;
            int[] version;
            EGLDisplay display;
            EGL10 egl = (EGL10)EGLContext.getEGL();
            if (egl.eglInitialize(display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY), version = new int[2])) {
                logger.info("Display EGL Version: " + version[0] + "." + version[1]);
            }
            if (!(configChooser = new AndroidConfigChooser(configType, eglConfigVerboseLogging)).findConfig(egl, display)) {
                logger.severe("Unable to find suitable EGL config");
            }
            this.clientOpenGLESVersion = configChooser.getClientOpenGLESVersion();
            if (this.clientOpenGLESVersion < 2) {
                logger.severe("OpenGL ES 2.0 is not supported on this device");
            }
            if (display != null) {
                egl.eglTerminate(display);
            }
            view.setEGLContextClientVersion(this.clientOpenGLESVersion);
            view.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
            view.getHolder().setFormat(-3);
            view.setZOrderOnTop(true);
        }
        view.setFocusableInTouchMode(true);
        view.setFocusable(true);
        view.getHolder().setType(2);
        view.setRenderer(this);
        return view;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig cfg) {
        if (this.created.get() && this.renderer != null) {
            this.renderer.resetGLObjects();
        } else if (!this.created.get()) {
            logger.info("GL Surface created, doing JME3 init");
            this.initInThread();
        } else {
            logger.warning("GL Surface already created");
        }
    }

    protected void initInThread() {
        Application app;
        this.created.set(true);
        logger.info("OGLESContext create");
        logger.info("Running on thread: " + Thread.currentThread().getName());
        final Context ctx = this.view.getContext();
        if (ctx instanceof AndroidHarness) {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable thrown) {
                    ((AndroidHarness)ctx).handleError("Exception thrown in " + thread.toString(), thrown);
                }
            });
        } else {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable thrown) {
                    OGLESContext.this.listener.handleError("Exception thrown in " + thread.toString(), thrown);
                }
            });
        }
        if (this.clientOpenGLESVersion < 2) {
            throw new UnsupportedOperationException("OpenGL ES 2.0 is not supported on this device");
        }
        this.timer = new AndroidTimer();
        this.renderer = new OGLESShaderRenderer();
        this.renderer.setVerboseLogging(this.verboseLogging);
        this.renderer.initialize();
        this.listener.initialize();
        if (ctx instanceof AndroidHarness && (app = ((AndroidHarness)ctx).getJmeApplication()).getInputManager() != null) {
            app.getInputManager().addMapping("TouchEscape", new TouchTrigger(4));
            app.getInputManager().addListener((AndroidHarness)ctx, "TouchEscape");
        }
        this.needClose.set(false);
        this.renderable.set(true);
    }

    protected void deinitInThread() {
        if (this.renderable.get()) {
            this.created.set(false);
            if (this.renderer != null) {
                this.renderer.cleanup();
            }
            this.listener.destroy();
            this.listener = null;
            this.renderer = null;
            this.timer = null;
            logger.info("Display destroyed.");
            this.renderable.set(false);
        }
    }

    protected void applySettingsToRenderer(OGLESShaderRenderer renderer, AppSettings settings) {
        logger.warning("setSettings.USE_VA: [" + settings.getBoolean("USE_VA") + "]");
        logger.warning("setSettings.VERBOSE_LOGGING: [" + settings.getBoolean("VERBOSE_LOGGING") + "]");
        renderer.setUseVA(settings.getBoolean("USE_VA"));
        renderer.setVerboseLogging(settings.getBoolean("VERBOSE_LOGGING"));
    }

    protected void applySettings(AppSettings settings) {
        this.setSettings(settings);
        if (this.renderer != null) {
            this.applySettingsToRenderer(this.renderer, this.settings);
        }
    }

    @Override
    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
    }

    @Override
    public void setSystemListener(SystemListener listener) {
        this.listener = listener;
    }

    @Override
    public AppSettings getSettings() {
        return this.settings;
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    @Override
    public MouseInput getMouseInput() {
        return new DummyMouseInput();
    }

    @Override
    public KeyInput getKeyInput() {
        return new DummyKeyInput();
    }

    @Override
    public JoyInput getJoyInput() {
        return null;
    }

    @Override
    public TouchInput getTouchInput() {
        return this.view;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public boolean isCreated() {
        return this.created.get();
    }

    @Override
    public void setAutoFlushFrames(boolean enabled) {
        this.autoFlush = enabled;
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        logger.info("GL Surface changed, width: " + width + " height: " + height);
        this.settings.setResolution(width, height);
        this.listener.reshape(width, height);
    }

    public void onDrawFrame(GL10 gl) {
        if (this.needClose.get()) {
            this.deinitInThread();
            return;
        }
        if (this.renderable.get()) {
            if (!this.created.get()) {
                throw new IllegalStateException("onDrawFrame without create");
            }
            this.milliStart = System.currentTimeMillis();
            this.listener.update();
            if (this.autoFlush) {
                this.renderer.onFrame();
            }
            this.milliDelta = System.currentTimeMillis() - this.milliStart;
            if (this.milliDelta < (long)this.minFrameDuration) {
                try {
                    Thread.sleep((long)this.minFrameDuration - this.milliDelta);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean isRenderable() {
        return this.renderable.get();
    }

    @Override
    public void create(boolean waitFor) {
        if (waitFor) {
            this.waitFor(true);
        }
    }

    public void create() {
        this.create(false);
    }

    @Override
    public void restart() {
    }

    @Override
    public void destroy(boolean waitFor) {
        this.needClose.set(true);
        if (waitFor) {
            this.waitFor(false);
        }
    }

    public void destroy() {
        this.destroy(true);
    }

    protected void waitFor(boolean createdVal) {
        while (this.renderable.get() != createdVal) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getClientOpenGLESVersion() {
        return this.clientOpenGLESVersion;
    }
}

