/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.dummy.DummyKeyInput;
import com.jme3.input.dummy.DummyMouseInput;
import com.jme3.system.JmeContext;
import com.jme3.system.lwjgl.LwjglContext;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Util;

public class LwjglOffscreenBuffer
extends LwjglContext
implements Runnable {
    private static final Logger logger = Logger.getLogger(LwjglOffscreenBuffer.class.getName());
    private Pbuffer pbuffer;
    protected AtomicBoolean needClose = new AtomicBoolean(false);
    private int width;
    private int height;
    private PixelFormat pixelFormat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInThread() {
        if ((Pbuffer.getCapabilities() & 1) == 0) {
            logger.severe("Offscreen surfaces are not supported.");
            return;
        }
        this.pixelFormat = new PixelFormat(this.settings.getBitsPerPixel(), 0, this.settings.getDepthBits(), this.settings.getStencilBits(), this.settings.getSamples());
        this.width = this.settings.getWidth();
        this.height = this.settings.getHeight();
        try {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread thread, Throwable thrown) {
                    LwjglOffscreenBuffer.this.listener.handleError("Uncaught exception thrown in " + thread.toString(), thrown);
                }
            });
            this.pbuffer = new Pbuffer(this.width, this.height, this.pixelFormat, null, null, this.createContextAttribs());
            this.pbuffer.makeCurrent();
            this.renderable.set(true);
            logger.info("Offscreen buffer created.");
            this.printContextInitInfo();
        }
        catch (LWJGLException ex) {
            this.listener.handleError("Failed to create display", ex);
        }
        super.internalCreate();
        this.listener.initialize();
    }

    protected boolean checkGLError() {
        try {
            Util.checkGLError();
        }
        catch (OpenGLException ex) {
            this.listener.handleError("An OpenGL error has occured!", ex);
        }
        return true;
    }

    protected void runLoop() {
        if (!this.created.get()) {
            throw new IllegalStateException();
        }
        if (this.pbuffer.isBufferLost()) {
            this.pbuffer.destroy();
            try {
                this.pbuffer = new Pbuffer(this.width, this.height, this.pixelFormat, null);
                this.pbuffer.makeCurrent();
            }
            catch (LWJGLException ex) {
                this.listener.handleError("Failed to restore pbuffer content", ex);
            }
        }
        this.listener.update();
        assert (this.checkGLError());
        this.renderer.onFrame();
        int frameRate = this.settings.getFrameRate();
        if (frameRate >= 1) {
            Display.sync((int)frameRate);
        }
    }

    protected void deinitInThread() {
        this.renderable.set(false);
        this.listener.destroy();
        this.renderer.cleanup();
        this.pbuffer.destroy();
        logger.info("Offscreen buffer destroyed.");
    }

    public void run() {
        logger.log(Level.INFO, "Using LWJGL {0}", Sys.getVersion());
        this.initInThread();
        while (!this.needClose.get()) {
            this.runLoop();
        }
        this.deinitInThread();
    }

    public void destroy(boolean waitFor) {
        this.needClose.set(true);
        if (waitFor) {
            this.waitFor(false);
        }
    }

    public void create(boolean waitFor) {
        if (this.created.get()) {
            logger.warning("create() called when pbuffer is already created!");
            return;
        }
        new Thread((Runnable)this, "LWJGL Renderer Thread").start();
        if (waitFor) {
            this.waitFor(true);
        }
    }

    public void restart() {
    }

    public void setAutoFlushFrames(boolean enabled) {
    }

    public JmeContext.Type getType() {
        return JmeContext.Type.OffscreenSurface;
    }

    public MouseInput getMouseInput() {
        return new DummyMouseInput();
    }

    public KeyInput getKeyInput() {
        return new DummyKeyInput();
    }

    public JoyInput getJoyInput() {
        return null;
    }

    public TouchInput getTouchInput() {
        return null;
    }

    public void setTitle(String title) {
    }
}

