/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.video;

@Deprecated
public final class RingBuffer {
    private final int bufSize;
    private final byte[] buf;
    private final Object lock = new Object();
    private volatile int writePos;
    private volatile int readPos;
    private volatile long totalRead = 0L;
    private volatile long totalWritten = 0L;

    public RingBuffer(int size) {
        this.bufSize = size;
        this.buf = new byte[size];
    }

    public int remainingForWrite() {
        if (this.writePos < this.readPos) {
            return this.readPos - this.writePos - 1;
        }
        if (this.writePos == this.readPos) {
            return this.bufSize - 1;
        }
        return this.bufSize - (this.writePos - this.readPos) - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] data, int offset, int length) {
        if (length == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.remainingForWrite() < length) {
                System.out.println("Warning: Audio decoder starved, waiting for player");
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this.writePos >= this.readPos) {
                int l = Math.min(length, this.bufSize - this.writePos);
                System.arraycopy(data, offset, this.buf, this.writePos, l);
                this.writePos += l;
                if (this.writePos >= this.bufSize) {
                    this.writePos = 0;
                }
                if (length > l) {
                    this.write(data, offset + l, length - l);
                }
            } else {
                int l = Math.min(length, this.readPos - this.writePos - 1);
                System.arraycopy(data, offset, this.buf, this.writePos, l);
                this.writePos += l;
                if (this.writePos >= this.bufSize) {
                    this.writePos = 0;
                }
            }
            this.totalWritten += (long)length;
        }
    }

    public int remainingForRead() {
        if (this.writePos < this.readPos) {
            return this.bufSize - (this.readPos - this.writePos);
        }
        if (this.writePos == this.readPos) {
            return 0;
        }
        return this.writePos - this.readPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int skip(int amount) {
        if (amount <= 0) {
            return 0;
        }
        int dataLen = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.remainingForRead() <= 0) {
                return 0;
            }
            amount = Math.min(amount, this.remainingForRead());
            if (this.readPos < this.writePos) {
                int l = Math.min(amount, this.writePos - this.readPos);
                this.readPos += l;
                if (this.readPos >= this.bufSize) {
                    this.readPos = 0;
                }
                dataLen = l;
            } else {
                int l = Math.min(amount, this.bufSize - this.readPos);
                this.readPos += l;
                if (this.readPos >= this.bufSize) {
                    this.readPos = 0;
                }
                dataLen = l;
                if (amount > l) {
                    dataLen += this.skip(amount - l);
                }
            }
            this.lock.notifyAll();
        }
        this.totalRead += (long)dataLen;
        return dataLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] data, int offset, int len) {
        if (len == 0) {
            return 0;
        }
        int dataLen = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.remainingForRead() <= 0) {
                System.out.println("Warning: Audio starved. Not enough data.");
                return 0;
            }
            len = Math.min(len, this.remainingForRead());
            if (this.readPos < this.writePos) {
                int l = Math.min(len, this.writePos - this.readPos);
                System.arraycopy(this.buf, this.readPos, data, offset, l);
                this.readPos += l;
                if (this.readPos >= this.bufSize) {
                    this.readPos = 0;
                }
                dataLen = l;
            } else {
                int l = Math.min(len, this.bufSize - this.readPos);
                System.arraycopy(this.buf, this.readPos, data, offset, l);
                this.readPos += l;
                if (this.readPos >= this.bufSize) {
                    this.readPos = 0;
                }
                dataLen = l;
                if (len > l) {
                    dataLen += this.read(data, offset + l, len - l);
                }
            }
            this.lock.notifyAll();
        }
        this.totalRead += (long)dataLen;
        return dataLen;
    }

    public long getTotalRead() {
        return this.totalRead;
    }

    public long getTotalWritten() {
        return this.totalWritten;
    }
}

