/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.optimize;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.material.Material;
import com.jme3.math.Matrix4f;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.debug.WireBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import jme3tools.optimize.FastOctnode;
import jme3tools.optimize.GeometryBatchFactory;
import jme3tools.optimize.OCTTriangle;
import jme3tools.optimize.TriangleCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Octnode {
    static final Vector3f[] extentMult = new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f)};
    final BoundingBox bbox;
    final ArrayList<OCTTriangle> tris;
    Geometry[] geoms;
    final Octnode[] children = new Octnode[8];
    boolean leaf = false;
    FastOctnode fastNode;

    public Octnode(BoundingBox bbox, ArrayList<OCTTriangle> tris) {
        this.bbox = bbox;
        this.tris = tris;
    }

    private BoundingBox getChildBound(int side) {
        float extent = this.bbox.getXExtent() * 0.5f;
        Vector3f center = new Vector3f(this.bbox.getCenter().x + extent * Octnode.extentMult[side].x, this.bbox.getCenter().y + extent * Octnode.extentMult[side].y, this.bbox.getCenter().z + extent * Octnode.extentMult[side].z);
        return new BoundingBox(center, extent, extent, extent);
    }

    private float getAdditionCost(BoundingBox bbox, OCTTriangle t) {
        if (bbox.intersects(t.get1(), t.get2(), t.get3())) {
            float d1 = bbox.distanceToEdge(t.get1());
            float d2 = bbox.distanceToEdge(t.get2());
            float d3 = bbox.distanceToEdge(t.get3());
            return d1 + d2 + d3;
        }
        return Float.POSITIVE_INFINITY;
    }

    private void expandBoxToContainTri(BoundingBox bbox, OCTTriangle t) {
        Vector3f min = bbox.getMin(null);
        Vector3f max = bbox.getMax(null);
        BoundingBox.checkMinMax(min, max, t.get1());
        BoundingBox.checkMinMax(min, max, t.get2());
        BoundingBox.checkMinMax(min, max, t.get3());
        bbox.setMinMax(min, max);
    }

    private boolean contains(BoundingBox bbox, OCTTriangle t) {
        return bbox.contains(t.get1()) && bbox.contains(t.get2()) && bbox.contains(t.get3());
    }

    public void subdivide(int depth, int minTrisPerNode) {
        if (this.tris == null || depth > 50 || this.bbox.getVolume() < 0.01f || this.tris.size() < minTrisPerNode) {
            this.leaf = true;
            return;
        }
        ArrayList<OCTTriangle> keepTris = new ArrayList<OCTTriangle>();
        ArrayList[] trisForChild = new ArrayList[8];
        BoundingBox[] boxForChild = new BoundingBox[8];
        for (int i = 0; i < 8; ++i) {
            boxForChild[i] = this.getChildBound(i);
            trisForChild[i] = new ArrayList();
        }
        for (OCTTriangle t : this.tris) {
            float lowestCost = Float.POSITIVE_INFINITY;
            int lowestIndex = -1;
            int numIntersecting = 0;
            for (int i = 0; i < 8; ++i) {
                BoundingBox childBox = boxForChild[i];
                float cost = this.getAdditionCost(childBox, t);
                if (!(cost < lowestCost)) continue;
                lowestCost = cost;
                lowestIndex = i;
                ++numIntersecting;
            }
            if (numIntersecting < 8 && lowestIndex > -1) {
                trisForChild[lowestIndex].add(t);
                this.expandBoxToContainTri(boxForChild[lowestIndex], t);
                continue;
            }
            keepTris.add(t);
        }
        this.tris.retainAll(keepTris);
        for (int i = 0; i < 8; ++i) {
            if (trisForChild[i].size() <= 0) continue;
            this.children[i] = new Octnode(boxForChild[i], trisForChild[i]);
            this.children[i].subdivide(depth + 1, minTrisPerNode);
        }
    }

    public void subdivide(int minTrisPerNode) {
        this.subdivide(0, minTrisPerNode);
    }

    public void createFastOctnode(List<Geometry> globalGeomList) {
        this.fastNode = new FastOctnode();
        if (this.geoms != null) {
            List<Geometry> geomsColl = Arrays.asList(this.geoms);
            List<Geometry> myOptimizedList = GeometryBatchFactory.makeBatches(geomsColl);
            int startIndex = globalGeomList.size();
            globalGeomList.addAll(myOptimizedList);
            this.fastNode.setOffset(startIndex);
            this.fastNode.length = myOptimizedList.size();
        } else {
            this.fastNode.setOffset(0);
            this.fastNode.length = 0;
        }
        for (int i = 0; i < 8; ++i) {
            if (this.children[i] == null) continue;
            this.children[i].createFastOctnode(globalGeomList);
        }
    }

    public void generateFastOctnodeLinks(Octnode parent, Octnode nextSibling, int side) {
        this.fastNode.setSide(side);
        this.fastNode.next = nextSibling != null ? nextSibling.fastNode : null;
        Octnode prev = null;
        for (int i = 7; i >= 0; --i) {
            if (this.children[i] == null) continue;
            this.children[i].generateFastOctnodeLinks(this, prev, i);
            prev = this.children[i];
        }
        this.fastNode.child = prev != null ? prev.fastNode : null;
    }

    private void generateRenderSetNoCheck(Set<Geometry> renderSet, Camera cam) {
        if (this.geoms != null) {
            renderSet.addAll(Arrays.asList(this.geoms));
        }
        for (int i = 0; i < 8; ++i) {
            if (this.children[i] == null) continue;
            this.children[i].generateRenderSetNoCheck(renderSet, cam);
        }
    }

    public void generateRenderSet(Set<Geometry> renderSet, Camera cam) {
        this.bbox.setCheckPlane(0);
        cam.setPlaneState(0);
        Camera.FrustumIntersect result = cam.contains(this.bbox);
        if (result != Camera.FrustumIntersect.Outside) {
            if (this.geoms != null) {
                renderSet.addAll(Arrays.asList(this.geoms));
            }
            for (int i = 0; i < 8; ++i) {
                if (this.children[i] == null) continue;
                if (result == Camera.FrustumIntersect.Inside) {
                    this.children[i].generateRenderSetNoCheck(renderSet, cam);
                    continue;
                }
                this.children[i].generateRenderSet(renderSet, cam);
            }
        }
    }

    public void collectTriangles(Geometry[] inGeoms) {
        if (this.tris.size() > 0) {
            List<Geometry> geomsList = TriangleCollector.gatherTris(inGeoms, this.tris);
            this.geoms = new Geometry[geomsList.size()];
            geomsList.toArray(this.geoms);
        } else {
            this.geoms = null;
        }
        for (int i = 0; i < 8; ++i) {
            if (this.children[i] == null) continue;
            this.children[i].collectTriangles(inGeoms);
        }
    }

    public void renderBounds(RenderQueue rq, Matrix4f transform, WireBox box, Material mat) {
        int i;
        int numChilds = 0;
        for (i = 0; i < 8; ++i) {
            if (this.children[i] == null) continue;
            ++numChilds;
            break;
        }
        if (this.geoms != null && numChilds == 0) {
            BoundingBox bbox2 = new BoundingBox(this.bbox);
            this.bbox.transform(transform, (BoundingVolume)bbox2);
            Geometry geom = new Geometry("bound", box);
            geom.setLocalTranslation(bbox2.getCenter());
            geom.setLocalScale(bbox2.getXExtent(), bbox2.getYExtent(), bbox2.getZExtent());
            geom.updateGeometricState();
            geom.setMaterial(mat);
            rq.addToQueue(geom, RenderQueue.Bucket.Opaque);
            box = null;
            geom = null;
        }
        for (i = 0; i < 8; ++i) {
            if (this.children[i] == null) continue;
            this.children[i].renderBounds(rq, transform, box, mat);
        }
    }

    public final void intersectWhere(Ray r, Geometry[] geoms, float sceneMin, float sceneMax, CollisionResults results) {
        for (OCTTriangle t : this.tris) {
            float d = r.intersects(t.get1(), t.get2(), t.get3());
            if (Float.isInfinite(d)) continue;
            Vector3f contactPoint = new Vector3f(r.getDirection()).multLocal(d).addLocal(r.getOrigin());
            CollisionResult result = new CollisionResult(geoms[t.getGeometryIndex()], contactPoint, d, t.getTriangleIndex());
            results.addCollision(result);
        }
        for (int i = 0; i < 8; ++i) {
            Octnode child = this.children[i];
            if (child == null || !child.bbox.intersects(r)) continue;
            child.intersectWhere(r, geoms, sceneMin, sceneMax, results);
        }
    }
}

