/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BoxCollisionShape
extends CollisionShape {
    private Vector3f halfExtents;

    public BoxCollisionShape() {
    }

    public BoxCollisionShape(Vector3f vector3f) {
        this.halfExtents = vector3f;
        this.createShape();
    }

    public final Vector3f getHalfExtents() {
        return this.halfExtents;
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write((Savable)this.halfExtents, "halfExtents", (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        Vector3f vector3f;
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.halfExtents = vector3f = (Vector3f)inputCapsule.readSavable("halfExtents", (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
        this.createShape();
    }

    protected void createShape() {
        this.objectId = this.createShape(this.halfExtents);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long createShape(Vector3f var1);
}

