/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.bullet.util.DebugMeshCallback;
import com.jme3.math.Matrix3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.TempVars;
import java.util.List;

public class DebugShapeFactory {
    public static Spatial getDebugShape(CollisionShape collisionShape) {
        Geometry geometry;
        if (collisionShape == null) {
            return null;
        }
        if (collisionShape instanceof CompoundCollisionShape) {
            CompoundCollisionShape compoundCollisionShape = (CompoundCollisionShape)collisionShape;
            List<ChildCollisionShape> list = compoundCollisionShape.getChildren();
            Node node = new Node("DebugShapeNode");
            for (ChildCollisionShape childCollisionShape : list) {
                CollisionShape collisionShape2 = childCollisionShape.shape;
                Geometry geometry2 = DebugShapeFactory.createDebugShape(collisionShape2);
                geometry2.setLocalTranslation(childCollisionShape.location);
                TempVars tempVars = TempVars.get();
                Matrix3f matrix3f = tempVars.tempMat3;
                matrix3f.set(geometry2.getLocalRotation());
                childCollisionShape.rotation.mult(matrix3f, matrix3f);
                geometry2.setLocalRotation(matrix3f);
                tempVars.release();
                node.attachChild((Spatial)geometry2);
            }
            geometry = node;
        } else {
            geometry = DebugShapeFactory.createDebugShape(collisionShape);
        }
        if (geometry == null) {
            return null;
        }
        geometry.updateGeometricState();
        return geometry;
    }

    private static Geometry createDebugShape(CollisionShape collisionShape) {
        Geometry geometry = new Geometry();
        geometry.setMesh(DebugShapeFactory.getDebugMesh(collisionShape));
        geometry.updateModelBound();
        return geometry;
    }

    public static Mesh getDebugMesh(CollisionShape collisionShape) {
        Mesh mesh = new Mesh();
        mesh = new Mesh();
        DebugMeshCallback debugMeshCallback = new DebugMeshCallback();
        DebugShapeFactory.getVertices(collisionShape.getObjectId(), debugMeshCallback);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, debugMeshCallback.getVertices());
        mesh.getFloatBuffer(VertexBuffer.Type.Position).clear();
        return mesh;
    }

    private static native void getVertices(long var0, DebugMeshCallback var2);
}

