/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.WaitStatus;

public abstract class Clock {
    private long adjust = 0L;
    private long lastTime = 0L;
    public static final long USECOND = 1L;
    public static final long MSECOND = 1000L;
    public static final long SECOND = 1000000L;
    public static final int SINGLE = 0;
    public static final int PERIODIC = 0;

    protected synchronized long adjust(long internal) {
        long ret = internal + this.adjust;
        if (ret < this.lastTime) {
            ret = this.lastTime;
        } else {
            this.lastTime = ret;
        }
        return ret;
    }

    protected abstract long getInternalTime();

    protected abstract WaitStatus waitFunc(ClockID var1);

    protected abstract WaitStatus waitAsyncFunc(ClockID var1);

    protected abstract void unscheduleFunc(ClockID var1);

    public synchronized long getTime() {
        long internal = this.getInternalTime();
        long ret = this.adjust(internal);
        return ret;
    }

    public synchronized void setAdjust(long newAdjust) {
        this.adjust = newAdjust;
    }

    public synchronized long getAdjust() {
        return this.adjust;
    }

    public ClockID newSingleShotID(long time) {
        return new ClockID(time, 0L, 0);
    }

    public ClockID newPeriodicID(long time, long interval) {
        return new ClockID(time, interval, 0);
    }

    public class ClockID {
        long time;
        long interval;
        int type;
        int status;

        public ClockID(long time, long interval, int type) {
            this.time = time;
            this.interval = interval;
            this.type = type;
        }

        public long getTime() {
            return this.time;
        }

        public WaitStatus waitID() {
            WaitStatus res = Clock.this.waitFunc(this);
            if (this.type == 0) {
                this.time += this.interval;
            }
            return res;
        }

        public void unschedule() {
            Clock.this.unscheduleFunc(this);
        }
    }
}

