/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.pmdloader;

import java.io.IOException;
import java.util.ArrayList;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.MmdSource;
import jp.sourceforge.mikutoga.parser.pmd.PmdParser;
import jp.sourceforge.mikutoga.pmd.MorphPart;
import jp.sourceforge.mikutoga.pmd.PmdModel;
import jp.sourceforge.mikutoga.pmd.pmdloader.BoneBuilder;
import jp.sourceforge.mikutoga.pmd.pmdloader.JointBuilder;
import jp.sourceforge.mikutoga.pmd.pmdloader.MaterialBuilder;
import jp.sourceforge.mikutoga.pmd.pmdloader.MorphBuilder;
import jp.sourceforge.mikutoga.pmd.pmdloader.RigidBuilder;
import jp.sourceforge.mikutoga.pmd.pmdloader.ShapeBuilder;
import jp.sourceforge.mikutoga.pmd.pmdloader.TextBuilder;
import jp.sourceforge.mikutoga.pmd.pmdloader.ToonBuilder;

public class PmdLoader {
    private PmdModel model = new PmdModel();
    private PmdParser parser;
    private TextBuilder textBuilder;
    private boolean loaded = false;
    private boolean hasMoreData = false;

    public PmdLoader(MmdSource source) {
        this.parser = new PmdParser(source);
        this.textBuilder = new TextBuilder(this.model);
        this.setHandler();
    }

    private void setHandler() {
        ShapeBuilder shapeBuilder = new ShapeBuilder(this.model);
        MaterialBuilder materialBuilder = new MaterialBuilder(this.model);
        BoneBuilder boneBuilder = new BoneBuilder(this.model);
        MorphBuilder morphBuilder = new MorphBuilder(this.model);
        ToonBuilder toonBuilder = new ToonBuilder(this.model);
        RigidBuilder rigidBuilder = new RigidBuilder(this.model);
        JointBuilder jointBuilder = new JointBuilder(this.model);
        this.parser.setBasicHandler(this.textBuilder);
        this.parser.setShapeHandler(shapeBuilder);
        this.parser.setMaterialHandler(materialBuilder);
        this.parser.setBoneHandler(boneBuilder);
        this.parser.setMorphHandler(morphBuilder);
        this.parser.setEngHandler(this.textBuilder);
        this.parser.setToonHandler(toonBuilder);
        this.parser.setRigidHandler(rigidBuilder);
        this.parser.setJointHandler(jointBuilder);
        ArrayList<MorphPart> morphPartList = new ArrayList<MorphPart>();
        morphBuilder.setMorphPartList(morphPartList);
        this.textBuilder.setMorphPartList(morphPartList);
        morphPartList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PmdModel load() throws IOException, MmdFormatException, IllegalStateException {
        PmdModel result;
        if (this.loaded) {
            throw new IllegalStateException();
        }
        try {
            this.parser.parsePmd();
        }
        finally {
            this.loaded = true;
            result = this.model;
            this.hasMoreData = this.textBuilder.hasMoreData();
            this.model = null;
            this.parser = null;
            this.textBuilder = null;
        }
        return result;
    }

    public boolean hasMoreData() {
        return this.hasMoreData;
    }
}

