/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.pmdloader;

import java.util.Iterator;
import java.util.List;
import jp.sourceforge.mikutoga.corelib.ListUtil;
import jp.sourceforge.mikutoga.parser.ParseStage;
import jp.sourceforge.mikutoga.parser.pmd.PmdRigidHandler;
import jp.sourceforge.mikutoga.pmd.BoneInfo;
import jp.sourceforge.mikutoga.pmd.DynamicsInfo;
import jp.sourceforge.mikutoga.pmd.PmdModel;
import jp.sourceforge.mikutoga.pmd.Pos3d;
import jp.sourceforge.mikutoga.pmd.Rad3d;
import jp.sourceforge.mikutoga.pmd.RigidBehaviorType;
import jp.sourceforge.mikutoga.pmd.RigidGroup;
import jp.sourceforge.mikutoga.pmd.RigidInfo;
import jp.sourceforge.mikutoga.pmd.RigidShape;
import jp.sourceforge.mikutoga.pmd.RigidShapeType;

class RigidBuilder
implements PmdRigidHandler {
    private final List<BoneInfo> boneList;
    private final List<RigidInfo> rigidList;
    private Iterator<RigidInfo> rigidIt;
    private RigidInfo currentRigid = null;
    private final List<RigidGroup> rigidGroupList;

    RigidBuilder(PmdModel model) {
        this.boneList = model.getBoneList();
        this.rigidList = model.getRigidList();
        this.rigidGroupList = model.getRigidGroupList();
    }

    @Override
    public void loopStart(ParseStage stage, int loops) {
        ListUtil.prepareDefConsList(this.rigidList, RigidInfo.class, loops);
        ListUtil.assignIndexedSerial(this.rigidList);
        this.rigidIt = this.rigidList.iterator();
        if (this.rigidIt.hasNext()) {
            this.currentRigid = this.rigidIt.next();
        }
        ListUtil.prepareDefConsList(this.rigidGroupList, RigidGroup.class, 16);
        ListUtil.assignIndexedSerial(this.rigidGroupList);
    }

    @Override
    public void loopNext(ParseStage stage) {
        if (this.rigidIt.hasNext()) {
            this.currentRigid = this.rigidIt.next();
        }
    }

    @Override
    public void loopEnd(ParseStage stage) {
    }

    @Override
    public void pmdRigidName(String rigidName) {
        this.currentRigid.getRigidName().setPrimaryText(rigidName);
    }

    @Override
    public void pmdRigidInfo(int rigidGroupId, int linkedBoneId) {
        BoneInfo bone = this.boneList.get(linkedBoneId);
        RigidGroup group = this.rigidGroupList.get(rigidGroupId);
        this.currentRigid.setLinkedBone(bone);
        this.currentRigid.setRigidGroup(group);
        group.getRigidList().add(this.currentRigid);
    }

    @Override
    public void pmdRigidShape(byte shapeType, float width, float height, float depth) {
        RigidShape shape = this.currentRigid.getRigidShape();
        shape.setWidth(width);
        shape.setHeight(height);
        shape.setDepth(depth);
        RigidShapeType type = RigidShapeType.decode(shapeType);
        shape.setShapeType(type);
    }

    @Override
    public void pmdRigidPosition(float posX, float posY, float posZ) {
        Pos3d position = this.currentRigid.getPosition();
        position.setXPos(posX);
        position.setYPos(posY);
        position.setZPos(posZ);
    }

    @Override
    public void pmdRigidRotation(float radX, float radY, float radZ) {
        Rad3d rotation = this.currentRigid.getRotation();
        rotation.setXRad(radX);
        rotation.setYRad(radY);
        rotation.setZRad(radZ);
    }

    @Override
    public void pmdRigidPhysics(float mass, float dampingPos, float dampingRot, float restitution, float friction) {
        DynamicsInfo info = this.currentRigid.getDynamicsInfo();
        info.setMass(mass);
        info.setDampingPosition(dampingPos);
        info.setDampingRotation(dampingRot);
        info.setRestitution(restitution);
        info.setFriction(friction);
    }

    @Override
    public void pmdRigidBehavior(byte behaveType, short collisionMap) {
        RigidBehaviorType type = RigidBehaviorType.decode(behaveType);
        this.currentRigid.setBehaviorType(type);
        for (int bitPos = 0; bitPos < 16; ++bitPos) {
            int mask = 1;
            if ((collisionMap & (mask = (int)((short)(mask << bitPos)))) != 0) continue;
            RigidGroup group = this.rigidGroupList.get(bitPos);
            this.currentRigid.getThroughGroupColl().add(group);
        }
    }
}

