/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.xml;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import jp.sourceforge.mikutoga.corelib.I18nText;
import jp.sourceforge.mikutoga.corelib.ListUtil;
import jp.sourceforge.mikutoga.pmd.BoneGroup;
import jp.sourceforge.mikutoga.pmd.BoneInfo;
import jp.sourceforge.mikutoga.pmd.BoneType;
import jp.sourceforge.mikutoga.pmd.Deg3d;
import jp.sourceforge.mikutoga.pmd.DynamicsInfo;
import jp.sourceforge.mikutoga.pmd.IKChain;
import jp.sourceforge.mikutoga.pmd.JointInfo;
import jp.sourceforge.mikutoga.pmd.Material;
import jp.sourceforge.mikutoga.pmd.MorphPart;
import jp.sourceforge.mikutoga.pmd.MorphType;
import jp.sourceforge.mikutoga.pmd.MorphVertex;
import jp.sourceforge.mikutoga.pmd.PmdModel;
import jp.sourceforge.mikutoga.pmd.Pos2d;
import jp.sourceforge.mikutoga.pmd.Pos3d;
import jp.sourceforge.mikutoga.pmd.Rad3d;
import jp.sourceforge.mikutoga.pmd.RigidBehaviorType;
import jp.sourceforge.mikutoga.pmd.RigidGroup;
import jp.sourceforge.mikutoga.pmd.RigidInfo;
import jp.sourceforge.mikutoga.pmd.RigidShape;
import jp.sourceforge.mikutoga.pmd.RigidShapeType;
import jp.sourceforge.mikutoga.pmd.ShadeInfo;
import jp.sourceforge.mikutoga.pmd.Surface;
import jp.sourceforge.mikutoga.pmd.ToonMap;
import jp.sourceforge.mikutoga.pmd.TripletRange;
import jp.sourceforge.mikutoga.pmd.Vec3d;
import jp.sourceforge.mikutoga.pmd.Vertex;
import jp.sourceforge.mikutoga.xml.DomUtils;
import jp.sourceforge.mikutoga.xml.TogaXmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Xml2PmdLoader {
    private final DocumentBuilder builder;
    private PmdModel model;
    private final Map<String, Integer> toonIdxMap = new HashMap<String, Integer>();
    private final Map<String, BoneInfo> boneMap = new HashMap<String, BoneInfo>();
    private final Map<String, Vertex> vertexMap = new HashMap<String, Vertex>();
    private final Map<String, List<Surface>> surfaceGroupMap = new HashMap<String, List<Surface>>();
    private final Map<String, RigidInfo> rigidMap = new HashMap<String, RigidInfo>();
    private final Map<String, RigidGroup> rigidGroupMap = new HashMap<String, RigidGroup>();

    public Xml2PmdLoader(DocumentBuilder builder) {
        this.builder = builder;
    }

    private static String getStringAttr(Element elem, String attrName) throws TogaXmlException {
        return DomUtils.getStringAttr(elem, attrName);
    }

    private static boolean getBooleanAttr(Element elem, String attrName) throws TogaXmlException {
        return DomUtils.getBooleanAttr(elem, attrName);
    }

    private static int getIntegerAttr(Element elem, String attrName) throws TogaXmlException {
        return DomUtils.getIntegerAttr(elem, attrName);
    }

    private static float getFloatAttr(Element elem, String attrName) throws TogaXmlException {
        return DomUtils.getFloatAttr(elem, attrName);
    }

    private static String getSjisFileNameAttr(Element elem, String attrName) throws TogaXmlException {
        return DomUtils.getSjisFileNameAttr(elem, attrName);
    }

    private static Element getChild(Element parent, String tagName) throws TogaXmlException {
        return DomUtils.getChild(parent, tagName);
    }

    private static boolean hasChild(Element parent, String tagName) {
        return DomUtils.hasChild(parent, tagName);
    }

    private static Iterable<Element> eachChild(Element parent, String childTag) {
        return DomUtils.getEachChild(parent, childTag);
    }

    private static String getGlobalName(Element parent) {
        NodeList nodeList = parent.getElementsByTagName("i18nName");
        int length = nodeList.getLength();
        for (int idx = 0; idx < length; ++idx) {
            Node i18nNameNode = nodeList.item(idx);
            Element i18nNameElem = (Element)i18nNameNode;
            String lang = i18nNameElem.getAttribute("lang");
            if (lang == null || lang.length() <= 0 || !lang.equals("en")) continue;
            String name = i18nNameElem.getAttribute("name");
            return name;
        }
        return null;
    }

    private static String getBRedContent(Element parent) {
        StringBuilder result = new StringBuilder();
        block4: for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    Element elem = (Element)node;
                    if (!"br".equals(elem.getTagName())) continue block4;
                    result.append('\n');
                    continue block4;
                }
                case 3: 
                case 4: {
                    String content = node.getTextContent();
                    content = content.replace("\r", "");
                    content = content.replace("\n", "");
                    result.append(content);
                    continue block4;
                }
            }
        }
        return result.toString();
    }

    private static void buildI18nName(Element baseElement, I18nText text) throws TogaXmlException {
        String primaryText = Xml2PmdLoader.getStringAttr(baseElement, "name");
        text.setPrimaryText(primaryText);
        for (Element i18nNameElem : Xml2PmdLoader.eachChild(baseElement, "i18nName")) {
            String lang = Xml2PmdLoader.getStringAttr(i18nNameElem, "lang");
            String name = Xml2PmdLoader.getStringAttr(i18nNameElem, "name");
            if ("en".equals(lang)) {
                text.setGlobalText(name);
                continue;
            }
            text.setText(lang, (CharSequence)text);
        }
    }

    public PmdModel parse(InputSource source) throws SAXException, IOException, TogaXmlException {
        Document document = this.builder.parse(source);
        this.model = new PmdModel();
        Element pmdModelElem = document.getDocumentElement();
        this.buildBasicInfo(pmdModelElem);
        this.buildBoneList(pmdModelElem);
        this.buildVertexList(pmdModelElem);
        this.buildSurfaceList(pmdModelElem);
        this.buildToonMap(pmdModelElem);
        this.buildMaterialList(pmdModelElem);
        this.buildIkChainList(pmdModelElem);
        this.buildMorphList(pmdModelElem);
        this.buildBoneGroupList(pmdModelElem);
        this.buildRigidList(pmdModelElem);
        this.buildRigidGroupList(pmdModelElem);
        this.resolveThroughRigidGroup(pmdModelElem);
        this.buildJointList(pmdModelElem);
        return this.model;
    }

    private void buildBasicInfo(Element pmdModelElem) throws TogaXmlException {
        String primaryName = Xml2PmdLoader.getStringAttr(pmdModelElem, "name");
        String globalName = Xml2PmdLoader.getGlobalName(pmdModelElem);
        I18nText modelName = this.model.getModelName();
        modelName.setPrimaryText(primaryName);
        modelName.setGlobalText(globalName);
        String primaryDescription = null;
        String globalDescription = null;
        for (Element descriptionElem : Xml2PmdLoader.eachChild(pmdModelElem, "description")) {
            String descriptionText = Xml2PmdLoader.getBRedContent(descriptionElem);
            if (!descriptionElem.hasAttribute("lang")) {
                primaryDescription = descriptionText;
                continue;
            }
            String lang = Xml2PmdLoader.getStringAttr(descriptionElem, "lang");
            if (lang.equals("ja")) {
                primaryDescription = descriptionText;
                continue;
            }
            if (!lang.equals("en")) continue;
            globalDescription = descriptionText;
        }
        I18nText description = this.model.getDescription();
        description.setPrimaryText(primaryDescription);
        description.setGlobalText(globalDescription);
    }

    private void buildToonMap(Element pmdModelElem) throws TogaXmlException {
        ToonMap toonMap = this.model.getToonMap();
        Element toonMapElem = Xml2PmdLoader.getChild(pmdModelElem, "toonMap");
        for (Element toonDefElem : Xml2PmdLoader.eachChild(toonMapElem, "toonDef")) {
            String toonFileId = Xml2PmdLoader.getStringAttr(toonDefElem, "toonFileId");
            int toonIndex = Xml2PmdLoader.getIntegerAttr(toonDefElem, "index");
            String toonFile = Xml2PmdLoader.getSjisFileNameAttr(toonDefElem, "winFileName");
            toonMap.setIndexedToon(toonIndex, toonFile);
            this.toonIdxMap.put(toonFileId, toonIndex);
        }
    }

    private void buildBoneList(Element pmdModelElem) throws TogaXmlException {
        Element boneListElem = Xml2PmdLoader.getChild(pmdModelElem, "boneList");
        List<BoneInfo> boneList = this.model.getBoneList();
        for (Element boneElem : Xml2PmdLoader.eachChild(boneListElem, "bone")) {
            BoneInfo boneInfo = new BoneInfo();
            boneList.add(boneInfo);
            I18nText boneName = boneInfo.getBoneName();
            Xml2PmdLoader.buildI18nName(boneElem, boneName);
            String boneType = Xml2PmdLoader.getStringAttr(boneElem, "type");
            BoneType type = BoneType.valueOf(boneType);
            boneInfo.setBoneType(type);
            String boneId = Xml2PmdLoader.getStringAttr(boneElem, "boneId");
            this.boneMap.put(boneId, boneInfo);
            Element positionElem = Xml2PmdLoader.getChild(boneElem, "position");
            float xPos = Xml2PmdLoader.getFloatAttr(positionElem, "x");
            float yPos = Xml2PmdLoader.getFloatAttr(positionElem, "y");
            float zPos = Xml2PmdLoader.getFloatAttr(positionElem, "z");
            Pos3d position = boneInfo.getPosition();
            position.setXPos(xPos);
            position.setYPos(yPos);
            position.setZPos(zPos);
        }
        ListUtil.assignIndexedSerial(boneList);
        int serial = 0;
        for (Element boneElem : Xml2PmdLoader.eachChild(boneListElem, "bone")) {
            Element ikBoneElem;
            BoneInfo boneInfo = boneList.get(serial++);
            if (Xml2PmdLoader.hasChild(boneElem, "ikBone")) {
                ikBoneElem = Xml2PmdLoader.getChild(boneElem, "ikBone");
                String ikBoneId = Xml2PmdLoader.getStringAttr(ikBoneElem, "boneIdRef");
                BoneInfo ikBone = this.boneMap.get(ikBoneId);
                boneInfo.setIKBone(ikBone);
            } else if (Xml2PmdLoader.hasChild(boneElem, "rotationRatio")) {
                ikBoneElem = Xml2PmdLoader.getChild(boneElem, "rotationRatio");
                int ratio = Xml2PmdLoader.getIntegerAttr(ikBoneElem, "ratio");
                boneInfo.setRotationRatio(ratio);
            }
            Element boneChainElem = Xml2PmdLoader.getChild(boneElem, "boneChain");
            if (boneChainElem.hasAttribute("prevBoneIdRef")) {
                String prevId = Xml2PmdLoader.getStringAttr(boneChainElem, "prevBoneIdRef");
                BoneInfo prevBone = this.boneMap.get(prevId);
                boneInfo.setPrevBone(prevBone);
            }
            if (!boneChainElem.hasAttribute("nextBoneIdRef")) continue;
            String nextId = Xml2PmdLoader.getStringAttr(boneChainElem, "nextBoneIdRef");
            BoneInfo nextBone = this.boneMap.get(nextId);
            boneInfo.setNextBone(nextBone);
        }
    }

    private void buildVertexList(Element pmdModelElem) throws TogaXmlException {
        Element vertexListElem = Xml2PmdLoader.getChild(pmdModelElem, "vertexList");
        List<Vertex> vertexList = this.model.getVertexList();
        for (Element vertexElem : Xml2PmdLoader.eachChild(vertexListElem, "vertex")) {
            Vertex vertex = new Vertex();
            vertexList.add(vertex);
            String vertexId = Xml2PmdLoader.getStringAttr(vertexElem, "vtxId");
            this.vertexMap.put(vertexId, vertex);
            boolean showEdge = Xml2PmdLoader.getBooleanAttr(vertexElem, "showEdge");
            vertex.setEdgeAppearance(showEdge);
            Element positionElem = Xml2PmdLoader.getChild(vertexElem, "position");
            float xVal = Xml2PmdLoader.getFloatAttr(positionElem, "x");
            float yVal = Xml2PmdLoader.getFloatAttr(positionElem, "y");
            float zVal = Xml2PmdLoader.getFloatAttr(positionElem, "z");
            Pos3d position = vertex.getPosition();
            position.setXPos(xVal);
            position.setYPos(yVal);
            position.setZPos(zVal);
            Element normalElem = Xml2PmdLoader.getChild(vertexElem, "normal");
            xVal = Xml2PmdLoader.getFloatAttr(normalElem, "x");
            yVal = Xml2PmdLoader.getFloatAttr(normalElem, "y");
            zVal = Xml2PmdLoader.getFloatAttr(normalElem, "z");
            Vec3d normal = vertex.getNormal();
            normal.setXVal(xVal);
            normal.setYVal(yVal);
            normal.setZVal(zVal);
            Element uvElem = Xml2PmdLoader.getChild(vertexElem, "uvMap");
            float uVal = Xml2PmdLoader.getFloatAttr(uvElem, "u");
            float vVal = Xml2PmdLoader.getFloatAttr(uvElem, "v");
            Pos2d uv = vertex.getUVPosition();
            uv.setXPos(uVal);
            uv.setYPos(vVal);
            Element skinningElem = Xml2PmdLoader.getChild(vertexElem, "skinning");
            String boneId1 = Xml2PmdLoader.getStringAttr(skinningElem, "boneIdRef1");
            String boneId2 = Xml2PmdLoader.getStringAttr(skinningElem, "boneIdRef2");
            int weight = Xml2PmdLoader.getIntegerAttr(skinningElem, "weightBalance");
            BoneInfo boneA = this.boneMap.get(boneId1);
            BoneInfo boneB = this.boneMap.get(boneId2);
            vertex.setBonePair(boneA, boneB);
            vertex.setWeightA(weight);
        }
        ListUtil.assignIndexedSerial(vertexList);
    }

    private void buildSurfaceList(Element pmdModelElem) throws TogaXmlException {
        Element surfaceGroupListElem = Xml2PmdLoader.getChild(pmdModelElem, "surfaceGroupList");
        for (Element surfaceGroupElem : Xml2PmdLoader.eachChild(surfaceGroupListElem, "surfaceGroup")) {
            String groupId = Xml2PmdLoader.getStringAttr(surfaceGroupElem, "surfaceGroupId");
            List<Surface> surfaceList = this.buildSurface(surfaceGroupElem);
            this.surfaceGroupMap.put(groupId, surfaceList);
        }
    }

    private List<Surface> buildSurface(Element surfaceGroupElem) throws TogaXmlException {
        ArrayList<Surface> result = new ArrayList<Surface>();
        for (Element surfaceElem : Xml2PmdLoader.eachChild(surfaceGroupElem, "surface")) {
            Surface surface = new Surface();
            result.add(surface);
            String id1 = Xml2PmdLoader.getStringAttr(surfaceElem, "vtxIdRef1");
            String id2 = Xml2PmdLoader.getStringAttr(surfaceElem, "vtxIdRef2");
            String id3 = Xml2PmdLoader.getStringAttr(surfaceElem, "vtxIdRef3");
            Vertex vertex1 = this.vertexMap.get(id1);
            Vertex vertex2 = this.vertexMap.get(id2);
            Vertex vertex3 = this.vertexMap.get(id3);
            surface.setTriangle(vertex1, vertex2, vertex3);
        }
        return result;
    }

    private void buildMaterialList(Element pmdModelElem) throws TogaXmlException {
        Element materialListElem = Xml2PmdLoader.getChild(pmdModelElem, "materialList");
        List<Surface> surfaceList = this.model.getSurfaceList();
        List<Material> materialList = this.model.getMaterialList();
        for (Element materialElem : Xml2PmdLoader.eachChild(materialListElem, "material")) {
            int toonIdx;
            Material material = new Material();
            materialList.add(material);
            material.getShadeInfo().setToonMap(this.model.getToonMap());
            String surfaceGroupId = Xml2PmdLoader.getStringAttr(materialElem, "surfaceGroupIdRef");
            List<Surface> surfaceGroup = this.surfaceGroupMap.get(surfaceGroupId);
            surfaceList.addAll(surfaceGroup);
            material.getSurfaceList().addAll(surfaceGroup);
            boolean hasEdge = Xml2PmdLoader.getBooleanAttr(materialElem, "showEdge");
            material.setEdgeAppearance(hasEdge);
            ShadeInfo shadeInfo = material.getShadeInfo();
            if (Xml2PmdLoader.hasChild(materialElem, "toon")) {
                Element toonElem = Xml2PmdLoader.getChild(materialElem, "toon");
                String toonId = Xml2PmdLoader.getStringAttr(toonElem, "toonFileIdRef");
                toonIdx = this.toonIdxMap.get(toonId);
            } else {
                toonIdx = 255;
            }
            shadeInfo.setToonIndex(toonIdx);
            if (Xml2PmdLoader.hasChild(materialElem, "textureFile")) {
                Element textureFileElem = Xml2PmdLoader.getChild(materialElem, "textureFile");
                String textureFile = Xml2PmdLoader.getSjisFileNameAttr(textureFileElem, "winFileName");
                shadeInfo.setTextureFileName(textureFile);
            }
            if (Xml2PmdLoader.hasChild(materialElem, "spheremapFile")) {
                Element spheremapFileElem = Xml2PmdLoader.getChild(materialElem, "spheremapFile");
                String spheremapFile = Xml2PmdLoader.getSjisFileNameAttr(spheremapFileElem, "winFileName");
                shadeInfo.setSpheremapFileName(spheremapFile);
            }
            Element diffuseElem = Xml2PmdLoader.getChild(materialElem, "diffuse");
            float red = Xml2PmdLoader.getFloatAttr(diffuseElem, "r");
            float green = Xml2PmdLoader.getFloatAttr(diffuseElem, "g");
            float blue = Xml2PmdLoader.getFloatAttr(diffuseElem, "b");
            float alpha = Xml2PmdLoader.getFloatAttr(diffuseElem, "alpha");
            Color diffuse = new Color(red, green, blue, alpha);
            material.setDiffuseColor(diffuse);
            Element specularElem = Xml2PmdLoader.getChild(materialElem, "specular");
            red = Xml2PmdLoader.getFloatAttr(specularElem, "r");
            green = Xml2PmdLoader.getFloatAttr(specularElem, "g");
            blue = Xml2PmdLoader.getFloatAttr(specularElem, "b");
            float shininess = Xml2PmdLoader.getFloatAttr(specularElem, "shininess");
            Color specular = new Color(red, green, blue);
            material.setSpecularColor(specular);
            material.setShininess(shininess);
            Element ambientElem = Xml2PmdLoader.getChild(materialElem, "ambient");
            red = Xml2PmdLoader.getFloatAttr(ambientElem, "r");
            green = Xml2PmdLoader.getFloatAttr(ambientElem, "g");
            blue = Xml2PmdLoader.getFloatAttr(ambientElem, "b");
            Color ambient = new Color(red, green, blue);
            material.setAmbientColor(ambient);
        }
    }

    private void buildIkChainList(Element pmdModelElem) throws TogaXmlException {
        Element ikChainListElem = Xml2PmdLoader.getChild(pmdModelElem, "ikChainList");
        List<IKChain> ikChainList = this.model.getIKChainList();
        for (Element ikChainElem : Xml2PmdLoader.eachChild(ikChainListElem, "ikChain")) {
            IKChain ikChain = new IKChain();
            ikChainList.add(ikChain);
            String ikBoneIdRef = Xml2PmdLoader.getStringAttr(ikChainElem, "ikBoneIdRef");
            int rucursiveDepth = Xml2PmdLoader.getIntegerAttr(ikChainElem, "recursiveDepth");
            float weight = Xml2PmdLoader.getFloatAttr(ikChainElem, "weight");
            BoneInfo ikBone = this.boneMap.get(ikBoneIdRef);
            ikChain.setIkBone(ikBone);
            ikChain.setIKDepth(rucursiveDepth);
            ikChain.setIKWeight(weight);
            List<BoneInfo> chainList = ikChain.getChainedBoneList();
            for (Element orderElem : Xml2PmdLoader.eachChild(ikChainElem, "chainOrder")) {
                String boneIdRef = Xml2PmdLoader.getStringAttr(orderElem, "boneIdRef");
                BoneInfo chaindBone = this.boneMap.get(boneIdRef);
                chainList.add(chaindBone);
            }
        }
    }

    private void buildMorphList(Element pmdModelElem) throws TogaXmlException {
        Element morphListElem = Xml2PmdLoader.getChild(pmdModelElem, "morphList");
        Map<MorphType, List<MorphPart>> morphMap = this.model.getMorphMap();
        for (Element morphElem : Xml2PmdLoader.eachChild(morphListElem, "morph")) {
            MorphPart morphPart = new MorphPart();
            I18nText name = morphPart.getMorphName();
            Xml2PmdLoader.buildI18nName(morphElem, name);
            String type = Xml2PmdLoader.getStringAttr(morphElem, "type");
            MorphType morphType = MorphType.valueOf(type);
            morphPart.setMorphType(morphType);
            List<MorphVertex> morphVertexList = morphPart.getMorphVertexList();
            for (Element morphVertexElem : Xml2PmdLoader.eachChild(morphElem, "morphVertex")) {
                String vtxIdRef = Xml2PmdLoader.getStringAttr(morphVertexElem, "vtxIdRef");
                Vertex baseVertex = this.vertexMap.get(vtxIdRef);
                float xOff = Xml2PmdLoader.getFloatAttr(morphVertexElem, "xOff");
                float yOff = Xml2PmdLoader.getFloatAttr(morphVertexElem, "yOff");
                float zOff = Xml2PmdLoader.getFloatAttr(morphVertexElem, "zOff");
                MorphVertex morphVertex = new MorphVertex();
                morphVertex.setBaseVertex(baseVertex);
                Pos3d position = morphVertex.getOffset();
                position.setXPos(xOff);
                position.setYPos(yOff);
                position.setZPos(zOff);
                morphVertexList.add(morphVertex);
            }
            morphMap.get((Object)morphType).add(morphPart);
        }
        LinkedList<MorphPart> serialList = new LinkedList<MorphPart>();
        MorphPart baseDummy = new MorphPart();
        serialList.add(baseDummy);
        for (MorphPart part : morphMap.get((Object)MorphType.EYEBROW)) {
            serialList.add(part);
        }
        for (MorphPart part : morphMap.get((Object)MorphType.EYE)) {
            serialList.add(part);
        }
        for (MorphPart part : morphMap.get((Object)MorphType.LIP)) {
            serialList.add(part);
        }
        for (MorphPart part : morphMap.get((Object)MorphType.EXTRA)) {
            serialList.add(part);
        }
        ListUtil.assignIndexedSerial(serialList);
    }

    private void buildBoneGroupList(Element pmdModelElem) throws TogaXmlException {
        Element boneGroupListElem = Xml2PmdLoader.getChild(pmdModelElem, "boneGroupList");
        List<BoneGroup> boneGroupList = this.model.getBoneGroupList();
        BoneGroup defaultGroup = new BoneGroup();
        boneGroupList.add(defaultGroup);
        for (Element boneGroupElem : Xml2PmdLoader.eachChild(boneGroupListElem, "boneGroup")) {
            BoneGroup group = new BoneGroup();
            boneGroupList.add(group);
            I18nText name = group.getGroupName();
            Xml2PmdLoader.buildI18nName(boneGroupElem, name);
            for (Element boneGroupMemberElem : Xml2PmdLoader.eachChild(boneGroupElem, "boneGroupMember")) {
                String boneIdRef = Xml2PmdLoader.getStringAttr(boneGroupMemberElem, "boneIdRef");
                BoneInfo bone = this.boneMap.get(boneIdRef);
                group.getBoneList().add(bone);
            }
        }
        ListUtil.assignIndexedSerial(boneGroupList);
    }

    private void buildRigidList(Element pmdModelElem) throws TogaXmlException {
        Element rigidListElem = Xml2PmdLoader.getChild(pmdModelElem, "rigidList");
        List<RigidInfo> rigidList = this.model.getRigidList();
        for (Element rigidElem : Xml2PmdLoader.eachChild(rigidListElem, "rigid")) {
            Element shapeElem;
            RigidInfo rigid = new RigidInfo();
            rigidList.add(rigid);
            I18nText name = rigid.getRigidName();
            Xml2PmdLoader.buildI18nName(rigidElem, name);
            String behavior = Xml2PmdLoader.getStringAttr(rigidElem, "behavior");
            RigidBehaviorType type = RigidBehaviorType.valueOf(behavior);
            rigid.setBehaviorType(type);
            String rigidId = Xml2PmdLoader.getStringAttr(rigidElem, "rigidId");
            this.rigidMap.put(rigidId, rigid);
            Element linkedBoneElem = Xml2PmdLoader.getChild(rigidElem, "linkedBone");
            String boneIdRef = Xml2PmdLoader.getStringAttr(linkedBoneElem, "boneIdRef");
            BoneInfo linkedBone = this.boneMap.get(boneIdRef);
            rigid.setLinkedBone(linkedBone);
            RigidShape rigidShape = rigid.getRigidShape();
            if (Xml2PmdLoader.hasChild(rigidElem, "rigidShapeSphere")) {
                shapeElem = Xml2PmdLoader.getChild(rigidElem, "rigidShapeSphere");
                float radius = Xml2PmdLoader.getFloatAttr(shapeElem, "radius");
                rigidShape.setShapeType(RigidShapeType.SPHERE);
                rigidShape.setRadius(radius);
            }
            if (Xml2PmdLoader.hasChild(rigidElem, "rigidShapeBox")) {
                shapeElem = Xml2PmdLoader.getChild(rigidElem, "rigidShapeBox");
                float width = Xml2PmdLoader.getFloatAttr(shapeElem, "width");
                float height = Xml2PmdLoader.getFloatAttr(shapeElem, "height");
                float depth = Xml2PmdLoader.getFloatAttr(shapeElem, "depth");
                rigidShape.setShapeType(RigidShapeType.BOX);
                rigidShape.setWidth(width);
                rigidShape.setHeight(height);
                rigidShape.setDepth(depth);
            }
            if (Xml2PmdLoader.hasChild(rigidElem, "rigidShapeCapsule")) {
                shapeElem = Xml2PmdLoader.getChild(rigidElem, "rigidShapeCapsule");
                float height = Xml2PmdLoader.getFloatAttr(shapeElem, "height");
                float radius = Xml2PmdLoader.getFloatAttr(shapeElem, "radius");
                rigidShape.setShapeType(RigidShapeType.CAPSULE);
                rigidShape.setHeight(height);
                rigidShape.setRadius(radius);
            }
            Element positionElem = Xml2PmdLoader.getChild(rigidElem, "position");
            float xVal = Xml2PmdLoader.getFloatAttr(positionElem, "x");
            float yVal = Xml2PmdLoader.getFloatAttr(positionElem, "y");
            float zVal = Xml2PmdLoader.getFloatAttr(positionElem, "z");
            Pos3d position = rigid.getPosition();
            position.setXPos(xVal);
            position.setYPos(yVal);
            position.setZPos(zVal);
            Element radRotationElem = Xml2PmdLoader.getChild(rigidElem, "radRotation");
            xVal = Xml2PmdLoader.getFloatAttr(radRotationElem, "xRad");
            yVal = Xml2PmdLoader.getFloatAttr(radRotationElem, "yRad");
            zVal = Xml2PmdLoader.getFloatAttr(radRotationElem, "zRad");
            Rad3d rotation = rigid.getRotation();
            rotation.setXRad(xVal);
            rotation.setYRad(yVal);
            rotation.setZRad(zVal);
            Element dynamicsElem = Xml2PmdLoader.getChild(rigidElem, "dynamics");
            float mass = Xml2PmdLoader.getFloatAttr(dynamicsElem, "mass");
            float dampingPosition = Xml2PmdLoader.getFloatAttr(dynamicsElem, "dampingPosition");
            float dampingRotation = Xml2PmdLoader.getFloatAttr(dynamicsElem, "dampingRotation");
            float restitution = Xml2PmdLoader.getFloatAttr(dynamicsElem, "restitution");
            float friction = Xml2PmdLoader.getFloatAttr(dynamicsElem, "friction");
            DynamicsInfo dynamics = rigid.getDynamicsInfo();
            dynamics.setMass(mass);
            dynamics.setDampingPosition(dampingPosition);
            dynamics.setDampingRotation(dampingRotation);
            dynamics.setRestitution(restitution);
            dynamics.setFriction(friction);
        }
        ListUtil.assignIndexedSerial(rigidList);
    }

    private void buildRigidGroupList(Element pmdModelElem) throws TogaXmlException {
        Element rigidGroupListElem = Xml2PmdLoader.getChild(pmdModelElem, "rigidGroupList");
        List<RigidGroup> groupList = this.model.getRigidGroupList();
        for (Element rigidGroupElem : Xml2PmdLoader.eachChild(rigidGroupListElem, "rigidGroup")) {
            RigidGroup rigidGroup = new RigidGroup();
            groupList.add(rigidGroup);
            String rigidGroupId = Xml2PmdLoader.getStringAttr(rigidGroupElem, "rigidGroupId");
            this.rigidGroupMap.put(rigidGroupId, rigidGroup);
            for (Element memberElem : Xml2PmdLoader.eachChild(rigidGroupElem, "rigidGroupMember")) {
                String rigidIdRef = Xml2PmdLoader.getStringAttr(memberElem, "rigidIdRef");
                RigidInfo rigid = this.rigidMap.get(rigidIdRef);
                rigidGroup.getRigidList().add(rigid);
                rigid.setRigidGroup(rigidGroup);
            }
        }
        while (groupList.size() < 16) {
            RigidGroup rigidGroup = new RigidGroup();
            groupList.add(rigidGroup);
        }
        ListUtil.assignIndexedSerial(groupList);
    }

    private void resolveThroughRigidGroup(Element pmdModelElem) throws TogaXmlException {
        Element rigidListElem = Xml2PmdLoader.getChild(pmdModelElem, "rigidList");
        List<RigidInfo> rigidList = this.model.getRigidList();
        int serialNum = 0;
        for (Element rigidElem : Xml2PmdLoader.eachChild(rigidListElem, "rigid")) {
            RigidInfo rigid = rigidList.get(serialNum++);
            for (Element groupElem : Xml2PmdLoader.eachChild(rigidElem, "throughRigidGroup")) {
                String groupId = Xml2PmdLoader.getStringAttr(groupElem, "rigidGroupIdRef");
                RigidGroup group = this.rigidGroupMap.get(groupId);
                rigid.getThroughGroupColl().add(group);
            }
        }
    }

    private void buildJointList(Element pmdModelElem) throws TogaXmlException {
        Element jointListElem = Xml2PmdLoader.getChild(pmdModelElem, "jointList");
        List<JointInfo> jointList = this.model.getJointList();
        for (Element jointElem : Xml2PmdLoader.eachChild(jointListElem, "joint")) {
            JointInfo joint = new JointInfo();
            jointList.add(joint);
            I18nText name = joint.getJointName();
            Xml2PmdLoader.buildI18nName(jointElem, name);
            Element rigidPairElem = Xml2PmdLoader.getChild(jointElem, "jointedRigidPair");
            String rigidIdRef1 = Xml2PmdLoader.getStringAttr(rigidPairElem, "rigidIdRef1");
            String rigidIdRef2 = Xml2PmdLoader.getStringAttr(rigidPairElem, "rigidIdRef2");
            RigidInfo rigid1 = this.rigidMap.get(rigidIdRef1);
            RigidInfo rigid2 = this.rigidMap.get(rigidIdRef2);
            joint.setRigidPair(rigid1, rigid2);
            Pos3d position = joint.getPosition();
            Element positionElem = Xml2PmdLoader.getChild(jointElem, "position");
            float xVal = Xml2PmdLoader.getFloatAttr(positionElem, "x");
            float yVal = Xml2PmdLoader.getFloatAttr(positionElem, "y");
            float zVal = Xml2PmdLoader.getFloatAttr(positionElem, "z");
            position.setXPos(xVal);
            position.setYPos(yVal);
            position.setZPos(zVal);
            TripletRange limitPosition = joint.getPositionRange();
            Element limitPositionElem = Xml2PmdLoader.getChild(jointElem, "limitPosition");
            float xFrom = Xml2PmdLoader.getFloatAttr(limitPositionElem, "xFrom");
            float xTo = Xml2PmdLoader.getFloatAttr(limitPositionElem, "xTo");
            float yFrom = Xml2PmdLoader.getFloatAttr(limitPositionElem, "yFrom");
            float yTo = Xml2PmdLoader.getFloatAttr(limitPositionElem, "yTo");
            float zFrom = Xml2PmdLoader.getFloatAttr(limitPositionElem, "zFrom");
            float zTo = Xml2PmdLoader.getFloatAttr(limitPositionElem, "zTo");
            limitPosition.setXRange(xFrom, xTo);
            limitPosition.setYRange(yFrom, yTo);
            limitPosition.setZRange(zFrom, zTo);
            Rad3d rotation = joint.getRotation();
            Element rotationElem = Xml2PmdLoader.getChild(jointElem, "radRotation");
            xVal = Xml2PmdLoader.getFloatAttr(rotationElem, "xRad");
            yVal = Xml2PmdLoader.getFloatAttr(rotationElem, "yRad");
            zVal = Xml2PmdLoader.getFloatAttr(rotationElem, "zRad");
            rotation.setXRad(xVal);
            rotation.setYRad(yVal);
            rotation.setZRad(zVal);
            TripletRange limitRotation = joint.getRotationRange();
            Element limitRotationElem = Xml2PmdLoader.getChild(jointElem, "limitRotation");
            xFrom = Xml2PmdLoader.getFloatAttr(limitRotationElem, "xFrom");
            xTo = Xml2PmdLoader.getFloatAttr(limitRotationElem, "xTo");
            yFrom = Xml2PmdLoader.getFloatAttr(limitRotationElem, "yFrom");
            yTo = Xml2PmdLoader.getFloatAttr(limitRotationElem, "yTo");
            zFrom = Xml2PmdLoader.getFloatAttr(limitRotationElem, "zFrom");
            zTo = Xml2PmdLoader.getFloatAttr(limitRotationElem, "zTo");
            limitRotation.setXRange(xFrom, xTo);
            limitRotation.setYRange(yFrom, yTo);
            limitRotation.setZRange(zFrom, zTo);
            Pos3d elasticPosition = joint.getElasticPosition();
            Element elasticPositionElem = Xml2PmdLoader.getChild(jointElem, "elasticPosition");
            xVal = Xml2PmdLoader.getFloatAttr(elasticPositionElem, "x");
            yVal = Xml2PmdLoader.getFloatAttr(elasticPositionElem, "y");
            zVal = Xml2PmdLoader.getFloatAttr(elasticPositionElem, "z");
            elasticPosition.setXPos(xVal);
            elasticPosition.setYPos(yVal);
            elasticPosition.setZPos(zVal);
            Deg3d elasticRotation = joint.getElasticRotation();
            Element elasticRotationElem = Xml2PmdLoader.getChild(jointElem, "elasticRotation");
            xVal = Xml2PmdLoader.getFloatAttr(elasticRotationElem, "xDeg");
            yVal = Xml2PmdLoader.getFloatAttr(elasticRotationElem, "yDeg");
            zVal = Xml2PmdLoader.getFloatAttr(elasticRotationElem, "zDeg");
            elasticRotation.setXDeg(xVal);
            elasticRotation.setYDeg(yVal);
            elasticRotation.setZDeg(zVal);
        }
    }
}

