/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.corelib;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import jp.sourceforge.mikutoga.corelib.SerialNumbered;

public final class ListUtil {
    private ListUtil() {
        assert (false);
        throw new AssertionError();
    }

    public static void assignIndexedSerial(List<? extends SerialNumbered> list) {
        int size = list.size();
        for (int idx = 0; idx < size; ++idx) {
            SerialNumbered numbered = list.get(idx);
            numbered.setSerialNumber(idx);
        }
    }

    public static <E> void extendCollection(Collection<E> coll, int newSize) {
        int remain = newSize - coll.size();
        if (remain <= 0) {
            return;
        }
        for (int ct = 1; ct <= remain; ++ct) {
            coll.add(null);
        }
        assert (coll.size() == newSize);
    }

    public static <E> int fillDefCons(List<E> list, Constructor<? extends E> cons) {
        int result = 0;
        int size = list.size();
        for (int pt = 0; pt < size; ++pt) {
            E elem = list.get(pt);
            if (elem != null) continue;
            try {
                elem = cons.newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                assert (false);
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                assert (false);
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                assert (false);
                throw new AssertionError((Object)e);
            }
            list.set(pt, elem);
            ++result;
        }
        return result;
    }

    public static <E> int fillDefCons(List<E> list, Class<? extends E> klass) {
        Constructor<? extends E> cons;
        try {
            cons = klass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        return ListUtil.fillDefCons(list, cons);
    }

    public static <E> int prepareDefConsList(List<E> list, Class<? extends E> klass, int newSize) {
        ListUtil.extendCollection(list, newSize);
        int result = ListUtil.fillDefCons(list, klass);
        return result;
    }
}

