/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.parser;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.sourceforge.mikutoga.parser.MmdEofException;

public class MmdSource
implements Closeable {
    private static final int BYTES_SHORT = 2;
    private static final int BYTES_INT = 4;
    private static final int BYTES_FLOAT = 4;
    private static final int BUF_SZ = 4;
    private static final int MASK_8BIT = 255;
    private static final int MASK_16BIT = 65535;
    private final PushbackInputStream istream;
    private final byte[] readArray;
    private final ByteBuffer readBuffer;
    private long position;

    public MmdSource(InputStream is) throws NullPointerException {
        if (is == null) {
            throw new NullPointerException();
        }
        this.istream = new PushbackInputStream(is);
        this.readArray = new byte[4];
        this.readBuffer = ByteBuffer.wrap(this.readArray);
        this.readBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.readBuffer.clear();
        this.position = 0L;
    }

    public long getPosition() {
        return this.position;
    }

    public long skip(long skipLength) throws IOException {
        long remain;
        long result;
        if (skipLength <= 0L) {
            return 0L;
        }
        for (remain = skipLength; remain > 0L && (result = this.istream.skip(remain)) > 0L; remain -= result) {
            this.position += result;
        }
        return skipLength - remain;
    }

    public boolean hasMore() throws IOException {
        int bData = this.istream.read();
        if (bData < 0) {
            return false;
        }
        this.istream.unread(bData);
        return true;
    }

    @Override
    public void close() throws IOException {
        this.istream.close();
        this.readBuffer.clear();
    }

    protected void fillBuffer(int fillSize) throws IOException, IndexOutOfBoundsException, MmdEofException {
        int result = this.istream.read(this.readArray, 0, fillSize);
        if (result >= 0) {
            this.position += (long)result;
        }
        if (result != fillSize) {
            throw new MmdEofException(this.position);
        }
        this.readBuffer.rewind();
    }

    public byte parseByte() throws IOException, MmdEofException {
        int bData = this.istream.read();
        if (bData < 0) {
            throw new MmdEofException(this.position);
        }
        ++this.position;
        byte result = (byte)bData;
        return result;
    }

    public int parseUByteAsInteger() throws IOException, MmdEofException {
        return this.parseByte() & 0xFF;
    }

    public boolean parseBoolean() throws IOException, MmdEofException {
        byte result = this.parseByte();
        return result != 0;
    }

    public short parseShort() throws IOException, MmdEofException {
        this.fillBuffer(2);
        short result = this.readBuffer.getShort();
        return result;
    }

    public int parseUShortAsInteger() throws IOException, MmdEofException {
        return this.parseShort() & 0xFFFF;
    }

    public int parseInteger() throws IOException, MmdEofException {
        this.fillBuffer(4);
        int result = this.readBuffer.getInt();
        return result;
    }

    public float parseFloat() throws IOException, MmdEofException {
        this.fillBuffer(4);
        float result = this.readBuffer.getFloat();
        return result;
    }

    public void parseByteArray(byte[] dst, int offset, int length) throws IOException, NullPointerException, IndexOutOfBoundsException, MmdEofException {
        int result = this.istream.read(dst, offset, length);
        if (result >= 0) {
            this.position += (long)result;
        }
        if (result != length) {
            throw new MmdEofException(this.position);
        }
    }

    public void parseByteArray(byte[] dst) throws IOException, NullPointerException, MmdEofException {
        this.parseByteArray(dst, 0, dst.length);
    }

    public void parseFloatArray(float[] dst, int offset, int length) throws IOException, NullPointerException, IndexOutOfBoundsException, MmdEofException {
        if (offset < 0 || length < 0 || dst.length - offset < length) {
            throw new IndexOutOfBoundsException();
        }
        for (int idx = 0; idx < length; ++idx) {
            dst[offset + idx] = this.parseFloat();
        }
    }

    public void parseFloatArray(float[] dst) throws IOException, NullPointerException, MmdEofException {
        this.parseFloatArray(dst, 0, dst.length);
    }
}

