/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.parser.pmd;

import java.io.IOException;
import jp.sourceforge.mikutoga.parser.CommonParser;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.MmdSource;
import jp.sourceforge.mikutoga.parser.pmd.PmdBasicHandler;
import jp.sourceforge.mikutoga.parser.pmd.PmdBoneHandler;
import jp.sourceforge.mikutoga.parser.pmd.PmdMaterialHandler;
import jp.sourceforge.mikutoga.parser.pmd.PmdMorphHandler;
import jp.sourceforge.mikutoga.parser.pmd.PmdShapeHandler;

public class PmdParserBase
extends CommonParser {
    protected static final String CR = "\r";
    protected static final String LF = "\n";
    protected static final String CRLF = "\r\n";
    private static final String MAGIC = "Pmd";
    private static final int MAGIC_SZ = "Pmd".getBytes(CS_WIN31J).length;
    private static final int VERTEX_DATA_SZ = 38;
    private static final int SURFACE_DATA_SZ = 6;
    private static final int MATERIAL_DATA_SZ = 70;
    private static final int BONE_DATA_SZ = 39;
    private static final int MORPHVERTEX_DATA_SZ = 16;
    private static final int MORPHORDER_DATA_SZ = 2;
    private static final int BONEGROUP_DATA_SZ = 50;
    private static final int GROUPEDBONE_DATA_SZ = 3;
    private PmdBasicHandler basicHandler = null;
    private PmdShapeHandler shapeHandler = null;
    private PmdMaterialHandler materialHandler = null;
    private PmdBoneHandler boneHandler = null;
    private PmdMorphHandler morphHandler = null;
    private int boneCount = -1;
    private int morphCount = -1;
    private int boneGroupCount = -1;

    public PmdParserBase(MmdSource source) {
        super(source);
    }

    public static String chopLastLF(String name) {
        String result = name.endsWith(LF) ? name.substring(0, name.length() - 1) : name;
        return result;
    }

    public static String[] splitShadingFileInfo(String shadingFile) {
        String[] result = shadingFile.split("\\*", 2);
        assert (result.length == 1 || result.length == 2);
        if (result.length == 1) {
            String onlyFile = result[0];
            result = new String[]{"", ""};
            if (onlyFile.endsWith(".sph") || onlyFile.endsWith(".spa")) {
                result[1] = onlyFile;
            } else {
                result[0] = onlyFile;
            }
        }
        assert (result.length == 2);
        return result;
    }

    public void setBasicHandler(PmdBasicHandler handler) {
        this.basicHandler = handler;
    }

    public void setShapeHandler(PmdShapeHandler handler) {
        this.shapeHandler = handler;
    }

    public void setMaterialHandler(PmdMaterialHandler handler) {
        this.materialHandler = handler;
    }

    public void setBoneHandler(PmdBoneHandler handler) {
        this.boneHandler = handler;
    }

    public void setMorphHandler(PmdMorphHandler handler) {
        this.morphHandler = handler;
    }

    protected int getBoneCount() {
        return this.boneCount;
    }

    protected int getMorphCount() {
        return this.morphCount;
    }

    protected int getBoneGroupCount() {
        return this.boneGroupCount;
    }

    public void parsePmd() throws IOException, MmdFormatException {
        if (this.basicHandler != null) {
            this.basicHandler.pmdParseStart();
        }
        this.parseBody();
        boolean hasMoreData = this.hasMore();
        if (this.basicHandler != null) {
            this.basicHandler.pmdParseEnd(hasMoreData);
        }
    }

    protected void parseBody() throws IOException, MmdFormatException {
        this.parsePmdHeader();
        this.parseVertexList();
        this.parseSurfaceList();
        this.parseMaterialList();
        this.parseBoneList();
        this.parseIKList();
        this.parseMorphList();
        this.parseMorphOrderList();
        this.parseBoneGroupList();
        this.parseGroupedBoneList();
    }

    private void parsePmdHeader() throws IOException, MmdFormatException {
        String magic = this.parseZeroTermString(MAGIC_SZ);
        if (!magic.equals(MAGIC)) {
            throw new MmdFormatException("unrecognized magic data");
        }
        float ver = this.parseFloat();
        String modelName = this.parseZeroTermString(20);
        String description = this.parseZeroTermString(256);
        description = description.replace(CRLF, LF);
        if (this.basicHandler != null) {
            this.basicHandler.pmdHeaderInfo(ver);
            this.basicHandler.pmdModelInfo(modelName, description);
        }
    }

    private void parseVertexList() throws IOException, MmdFormatException {
        int vertexNum = this.parseInteger();
        if (this.shapeHandler == null) {
            this.skip(38 * vertexNum);
            return;
        }
        this.shapeHandler.loopStart(PmdShapeHandler.VERTEX_LIST, vertexNum);
        for (int ct = 0; ct < vertexNum; ++ct) {
            float xPos = this.parseFloat();
            float yPos = this.parseFloat();
            float zPos = this.parseFloat();
            this.shapeHandler.pmdVertexPosition(xPos, yPos, zPos);
            float xVec = this.parseFloat();
            float yVec = this.parseFloat();
            float zVec = this.parseFloat();
            this.shapeHandler.pmdVertexNormal(xVec, yVec, zVec);
            float uVal = this.parseFloat();
            float vVal = this.parseFloat();
            this.shapeHandler.pmdVertexUV(uVal, vVal);
            int boneId1 = this.parseUShortAsInteger();
            int boneId2 = this.parseUShortAsInteger();
            int weightForB1 = this.parseUByteAsInteger();
            this.shapeHandler.pmdVertexWeight(boneId1, boneId2, weightForB1);
            boolean hideEdge = this.parseBoolean();
            this.shapeHandler.pmdVertexEdge(hideEdge);
            this.shapeHandler.loopNext(PmdShapeHandler.VERTEX_LIST);
        }
        this.shapeHandler.loopEnd(PmdShapeHandler.VERTEX_LIST);
    }

    private void parseSurfaceList() throws IOException, MmdFormatException {
        int vertexNum = this.parseInteger();
        if (vertexNum % 3 != 0) {
            throw new MmdFormatException();
        }
        int surfaceNum = vertexNum / 3;
        if (this.shapeHandler == null) {
            this.skip(6 * surfaceNum);
            return;
        }
        this.shapeHandler.loopStart(PmdShapeHandler.SURFACE_LIST, surfaceNum);
        for (int ct = 0; ct < surfaceNum; ++ct) {
            int vertexId1 = this.parseUShortAsInteger();
            int vertexId2 = this.parseUShortAsInteger();
            int vertexId3 = this.parseUShortAsInteger();
            this.shapeHandler.pmdSurfaceTriangle(vertexId1, vertexId2, vertexId3);
            this.shapeHandler.loopNext(PmdShapeHandler.SURFACE_LIST);
        }
        this.shapeHandler.loopEnd(PmdShapeHandler.SURFACE_LIST);
    }

    private void parseMaterialList() throws IOException, MmdFormatException {
        int materialNum = this.parseInteger();
        if (this.materialHandler == null) {
            this.skip(70 * materialNum);
            return;
        }
        this.materialHandler.loopStart(PmdMaterialHandler.MATERIAL_LIST, materialNum);
        for (int ct = 0; ct < materialNum; ++ct) {
            float red = this.parseFloat();
            float green = this.parseFloat();
            float blue = this.parseFloat();
            float alpha = this.parseFloat();
            this.materialHandler.pmdMaterialDiffuse(red, green, blue, alpha);
            float shininess = this.parseFloat();
            red = this.parseFloat();
            green = this.parseFloat();
            blue = this.parseFloat();
            this.materialHandler.pmdMaterialSpecular(red, green, blue, shininess);
            red = this.parseFloat();
            green = this.parseFloat();
            blue = this.parseFloat();
            this.materialHandler.pmdMaterialAmbient(red, green, blue);
            int toonidx = this.parseUByteAsInteger();
            boolean hasEdge = this.parseBoolean();
            int surfaceCount = this.parseInteger();
            String shadingFile = this.parseZeroTermString(20);
            String[] splitted = PmdParserBase.splitShadingFileInfo(shadingFile);
            String textureFile = splitted[0];
            String sphereFile = splitted[1];
            this.materialHandler.pmdMaterialShading(toonidx, textureFile, sphereFile);
            this.materialHandler.pmdMaterialInfo(hasEdge, surfaceCount);
            this.materialHandler.loopNext(PmdMaterialHandler.MATERIAL_LIST);
        }
        this.materialHandler.loopEnd(PmdMaterialHandler.MATERIAL_LIST);
    }

    private void parseBoneList() throws IOException, MmdFormatException {
        this.boneCount = this.parseUShortAsInteger();
        if (this.boneHandler == null) {
            this.skip(39 * this.boneCount);
            return;
        }
        this.boneHandler.loopStart(PmdBoneHandler.BONE_LIST, this.boneCount);
        for (int ct = 0; ct < this.boneCount; ++ct) {
            String boneName = this.parseZeroTermString(20);
            int parentId = this.parseUShortAsInteger();
            int tailId = this.parseUShortAsInteger();
            byte boneKind = this.parseByte();
            int ikId = this.parseUShortAsInteger();
            this.boneHandler.pmdBoneInfo(boneName, boneKind);
            this.boneHandler.pmdBoneLink(parentId, tailId, ikId);
            float xPos = this.parseFloat();
            float yPos = this.parseFloat();
            float zPos = this.parseFloat();
            this.boneHandler.pmdBonePosition(xPos, yPos, zPos);
            this.boneHandler.loopNext(PmdBoneHandler.BONE_LIST);
        }
        this.boneHandler.loopEnd(PmdBoneHandler.BONE_LIST);
    }

    private void parseIKList() throws IOException, MmdFormatException {
        int ikCount = this.parseUShortAsInteger();
        if (this.boneHandler != null) {
            this.boneHandler.loopStart(PmdBoneHandler.IK_LIST, ikCount);
        }
        for (int ct = 0; ct < ikCount; ++ct) {
            int boneId = this.parseUShortAsInteger();
            int targetId = this.parseUShortAsInteger();
            int chainLength = this.parseUByteAsInteger();
            int depth = this.parseUShortAsInteger();
            float weight = this.parseFloat();
            this.parseIKChainList(chainLength);
            if (this.boneHandler == null) continue;
            this.boneHandler.pmdIKInfo(boneId, targetId, depth, weight);
            this.boneHandler.loopNext(PmdBoneHandler.IK_LIST);
        }
        if (this.boneHandler != null) {
            this.boneHandler.loopEnd(PmdBoneHandler.IK_LIST);
        }
    }

    private void parseIKChainList(int chainLength) throws IOException, MmdFormatException {
        if (this.boneHandler != null) {
            this.boneHandler.loopStart(PmdBoneHandler.IKCHAIN_LIST, chainLength);
        }
        for (int ct = 0; ct < chainLength; ++ct) {
            int childId = this.parseUShortAsInteger();
            if (this.boneHandler == null) continue;
            this.boneHandler.pmdIKChainInfo(childId);
            this.boneHandler.loopNext(PmdBoneHandler.IKCHAIN_LIST);
        }
        if (this.boneHandler != null) {
            this.boneHandler.loopEnd(PmdBoneHandler.IKCHAIN_LIST);
        }
    }

    private void parseMorphList() throws IOException, MmdFormatException {
        this.morphCount = this.parseUShortAsInteger();
        if (this.morphHandler != null) {
            this.morphHandler.loopStart(PmdMorphHandler.MORPH_LIST, this.morphCount);
        }
        for (int ct = 0; ct < this.morphCount; ++ct) {
            String morphName = this.parseZeroTermString(20);
            int vertexCount = this.parseInteger();
            byte morphType = this.parseByte();
            if (this.morphHandler != null) {
                this.morphHandler.pmdMorphInfo(morphName, morphType);
            }
            this.parseMorphVertexList(vertexCount);
            if (this.morphHandler == null) continue;
            this.morphHandler.loopNext(PmdMorphHandler.MORPH_LIST);
        }
        if (this.morphHandler != null) {
            this.morphHandler.loopEnd(PmdMorphHandler.MORPH_LIST);
        }
    }

    private void parseMorphVertexList(int vertexCount) throws IOException, MmdFormatException {
        if (this.morphHandler == null) {
            this.skip(16 * vertexCount);
            return;
        }
        this.morphHandler.loopStart(PmdMorphHandler.MORPHVERTEX_LIST, vertexCount);
        for (int ct = 0; ct < vertexCount; ++ct) {
            int vertexId = this.parseInteger();
            float xPos = this.parseFloat();
            float yPos = this.parseFloat();
            float zPos = this.parseFloat();
            this.morphHandler.pmdMorphVertexInfo(vertexId, xPos, yPos, zPos);
            this.morphHandler.loopNext(PmdMorphHandler.MORPHVERTEX_LIST);
        }
        this.morphHandler.loopEnd(PmdMorphHandler.MORPHVERTEX_LIST);
    }

    private void parseMorphOrderList() throws IOException, MmdFormatException {
        int morphOrderCount = this.parseUByteAsInteger();
        if (this.morphHandler == null) {
            this.skip(2 * morphOrderCount);
            return;
        }
        this.morphHandler.loopStart(PmdMorphHandler.MORPHORDER_LIST, morphOrderCount);
        for (int ct = 0; ct < morphOrderCount; ++ct) {
            int morphId = this.parseUShortAsInteger();
            this.morphHandler.pmdMorphOrderInfo(morphId);
            this.morphHandler.loopNext(PmdMorphHandler.MORPHORDER_LIST);
        }
        this.morphHandler.loopEnd(PmdMorphHandler.MORPHORDER_LIST);
    }

    private void parseBoneGroupList() throws IOException, MmdFormatException {
        this.boneGroupCount = this.parseUByteAsInteger();
        if (this.boneHandler == null) {
            this.skip(50 * this.boneGroupCount);
            return;
        }
        this.boneHandler.loopStart(PmdBoneHandler.BONEGROUP_LIST, this.boneGroupCount);
        for (int ct = 0; ct < this.boneGroupCount; ++ct) {
            String groupName = this.parseZeroTermString(50);
            groupName = PmdParserBase.chopLastLF(groupName);
            this.boneHandler.pmdBoneGroupInfo(groupName);
            this.boneHandler.loopNext(PmdBoneHandler.BONEGROUP_LIST);
        }
        this.boneHandler.loopEnd(PmdBoneHandler.BONEGROUP_LIST);
    }

    private void parseGroupedBoneList() throws IOException, MmdFormatException {
        int groupedBoneCount = this.parseInteger();
        if (this.boneHandler == null) {
            this.skip(3 * groupedBoneCount);
            return;
        }
        this.boneHandler.loopStart(PmdBoneHandler.GROUPEDBONE_LIST, groupedBoneCount);
        for (int ct = 0; ct < groupedBoneCount; ++ct) {
            int boneId = this.parseUShortAsInteger();
            int groupId = this.parseUByteAsInteger();
            this.boneHandler.pmdGroupedBoneInfo(boneId, groupId);
            this.boneHandler.loopNext(PmdBoneHandler.GROUPEDBONE_LIST);
        }
        this.boneHandler.loopEnd(PmdBoneHandler.GROUPEDBONE_LIST);
    }
}

