/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import jp.sourceforge.mikutoga.corelib.I18nText;
import jp.sourceforge.mikutoga.pmd.BoneGroup;
import jp.sourceforge.mikutoga.pmd.BoneInfo;
import jp.sourceforge.mikutoga.pmd.IKChain;
import jp.sourceforge.mikutoga.pmd.JointInfo;
import jp.sourceforge.mikutoga.pmd.Material;
import jp.sourceforge.mikutoga.pmd.MorphPart;
import jp.sourceforge.mikutoga.pmd.MorphType;
import jp.sourceforge.mikutoga.pmd.MorphVertex;
import jp.sourceforge.mikutoga.pmd.RigidGroup;
import jp.sourceforge.mikutoga.pmd.RigidInfo;
import jp.sourceforge.mikutoga.pmd.ShadeInfo;
import jp.sourceforge.mikutoga.pmd.Surface;
import jp.sourceforge.mikutoga.pmd.ToonMap;
import jp.sourceforge.mikutoga.pmd.Vertex;

public class PmdModel {
    public static final float DEF_HEADERVER = 1.0f;
    private float headerVersion = 1.0f;
    private final I18nText modelName = new I18nText();
    private final I18nText description = new I18nText();
    private final List<Vertex> vertexList = new ArrayList<Vertex>();
    private final List<Surface> surfaceList = new ArrayList<Surface>();
    private final List<Material> materialList = new LinkedList<Material>();
    private final List<BoneInfo> boneList = new ArrayList<BoneInfo>();
    private final List<BoneGroup> boneGroupList = new ArrayList<BoneGroup>();
    private final List<IKChain> ikChainList = new ArrayList<IKChain>();
    private final Map<MorphType, List<MorphPart>> morphMap = new EnumMap<MorphType, List<MorphPart>>(MorphType.class);
    private final List<RigidInfo> rigidList = new ArrayList<RigidInfo>();
    private final List<RigidGroup> rigidGroupList = new ArrayList<RigidGroup>();
    private final List<JointInfo> jointList = new ArrayList<JointInfo>();
    private ToonMap toonMap = new ToonMap();

    public PmdModel() {
        assert (this.vertexList instanceof RandomAccess);
        assert (this.surfaceList instanceof RandomAccess);
        this.morphMap.put(MorphType.EYEBROW, new ArrayList());
        this.morphMap.put(MorphType.EYE, new ArrayList());
        this.morphMap.put(MorphType.LIP, new ArrayList());
        this.morphMap.put(MorphType.EXTRA, new ArrayList());
    }

    public float getHeaderVersion() {
        return this.headerVersion;
    }

    public void setHeaderVersion(float ver) {
        this.headerVersion = ver;
    }

    public I18nText getModelName() {
        return this.modelName;
    }

    public I18nText getDescription() {
        return this.description;
    }

    public List<Vertex> getVertexList() {
        return this.vertexList;
    }

    public List<Surface> getSurfaceList() {
        return this.surfaceList;
    }

    public List<Material> getMaterialList() {
        return this.materialList;
    }

    public List<BoneInfo> getBoneList() {
        return this.boneList;
    }

    public List<BoneGroup> getBoneGroupList() {
        return this.boneGroupList;
    }

    public List<IKChain> getIKChainList() {
        return this.ikChainList;
    }

    public Map<MorphType, List<MorphPart>> getMorphMap() {
        return this.morphMap;
    }

    public List<RigidInfo> getRigidList() {
        return this.rigidList;
    }

    public List<RigidGroup> getRigidGroupList() {
        return this.rigidGroupList;
    }

    public List<JointInfo> getJointList() {
        return this.jointList;
    }

    public ToonMap getToonMap() {
        return this.toonMap;
    }

    public void setToonMap(ToonMap map) {
        this.toonMap = map;
        for (Material material : this.materialList) {
            ShadeInfo info = material.getShadeInfo();
            info.setToonMap(this.toonMap);
        }
    }

    public boolean hasGlobalText() {
        if (this.modelName.hasGlobalText()) {
            return true;
        }
        if (this.description.hasGlobalText()) {
            return true;
        }
        for (BoneInfo bone : this.boneList) {
            if (!bone.getBoneName().hasGlobalText()) continue;
            return true;
        }
        ArrayList<MorphType> typeList = new ArrayList<MorphType>();
        typeList.addAll(this.morphMap.keySet());
        for (MorphType type : typeList) {
            List<MorphPart> partList = this.morphMap.get((Object)type);
            for (MorphPart part : partList) {
                if (!part.getMorphName().hasGlobalText()) continue;
                return true;
            }
        }
        for (BoneGroup group : this.boneGroupList) {
            if (!group.getGroupName().hasGlobalText()) continue;
            return true;
        }
        return false;
    }

    public List<MorphVertex> mergeMorphVertex() {
        ArrayList<MorphVertex> result = new ArrayList<MorphVertex>();
        HashSet<Vertex> mergedVertexSet = new HashSet<Vertex>();
        for (MorphType type : this.morphMap.keySet()) {
            List<MorphPart> partList;
            if (type.isBase() || (partList = this.morphMap.get((Object)type)) == null) continue;
            for (MorphPart part : partList) {
                for (MorphVertex morphVertex : part) {
                    Vertex vertex = morphVertex.getBaseVertex();
                    if (mergedVertexSet.contains(vertex)) continue;
                    mergedVertexSet.add(vertex);
                    result.add(morphVertex);
                }
            }
        }
        Collections.sort(result, MorphVertex.VIDCOMPARATOR);
        for (int idx = 0; idx < result.size(); ++idx) {
            MorphVertex morphVertex = (MorphVertex)result.get(idx);
            morphVertex.setSerialNumber(idx);
        }
        HashMap<Vertex, MorphVertex> numberedMap = new HashMap<Vertex, MorphVertex>();
        for (MorphVertex morphVertex : result) {
            numberedMap.put(morphVertex.getBaseVertex(), morphVertex);
        }
        for (MorphType type : this.morphMap.keySet()) {
            List<MorphPart> partList;
            if (type.isBase() || (partList = this.morphMap.get((Object)type)) == null) continue;
            for (MorphPart part : partList) {
                for (MorphVertex morphVertex : part) {
                    Vertex vertex = morphVertex.getBaseVertex();
                    MorphVertex numbered = (MorphVertex)numberedMap.get(vertex);
                    assert (numbered != null);
                    morphVertex.setSerialNumber(numbered.getSerialNumber());
                }
            }
        }
        return result;
    }

    public void trimming() {
        List<Surface> trimmedSurfaceList = this.trimmingSurfaceList();
        this.surfaceList.clear();
        this.surfaceList.addAll(trimmedSurfaceList);
        List<Vertex> trimmedVertexList = this.trimmingVertexList();
        this.vertexList.clear();
        this.vertexList.addAll(trimmedVertexList);
    }

    private List<Surface> trimmingSurfaceList() {
        HashSet<Surface> materialedSurfaceSet = new HashSet<Surface>();
        for (Material material : this.materialList) {
            if (material == null) continue;
            for (Surface surface : material) {
                if (surface == null) continue;
                materialedSurfaceSet.add(surface);
            }
        }
        materialedSurfaceSet.removeAll(this.surfaceList);
        ArrayList<Surface> result = new ArrayList<Surface>();
        for (Surface surface : this.surfaceList) {
            if (surface == null) continue;
            result.add(surface);
        }
        result.addAll(materialedSurfaceSet);
        int serialNum = 0;
        for (Surface surface : result) {
            surface.setSerialNumber(serialNum);
            ++serialNum;
        }
        return result;
    }

    private List<Vertex> trimmingVertexList() {
        HashSet<Vertex> surfacedVertexSet = new HashSet<Vertex>();
        for (Surface surface : this.surfaceList) {
            if (surface == null) continue;
            for (Vertex vertex : surface) {
                surfacedVertexSet.add(vertex);
            }
        }
        surfacedVertexSet.removeAll(this.vertexList);
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        for (Vertex vertex : this.vertexList) {
            if (vertex == null) continue;
            result.add(vertex);
        }
        result.addAll(surfacedVertexSet);
        int serialNum = 0;
        for (Vertex vertex : result) {
            vertex.setSerialNumber(serialNum);
            ++serialNum;
        }
        return result;
    }
}

