/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class ToonMap {
    private static final Map<Integer, String> DEF_TOONMAP;
    private final Map<Integer, String> toonMap = new TreeMap<Integer, String>(DEF_TOONMAP);

    public String getIndexedToon(int idx) {
        String result = this.toonMap.get(idx);
        return result;
    }

    public void setIndexedToon(int idx, String toonFileName) throws NullPointerException {
        if (toonFileName == null) {
            throw new NullPointerException();
        }
        this.toonMap.put(idx, toonFileName);
    }

    public boolean isDefaultMap() {
        return ((Object)this.toonMap).equals(DEF_TOONMAP);
    }

    public boolean isDefaultToon(int idx) {
        String thisToon = this.toonMap.get(idx);
        if (thisToon == null) {
            return false;
        }
        String defToon = DEF_TOONMAP.get(idx);
        return thisToon.equals(defToon);
    }

    public void resetDefaultMap() {
        this.toonMap.clear();
        this.toonMap.putAll(DEF_TOONMAP);
    }

    public void resetIndexedToon(int idx) {
        String toonFile = DEF_TOONMAP.get(idx);
        this.toonMap.put(idx, toonFile);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        boolean dumped = false;
        for (Map.Entry<Integer, String> entry : this.toonMap.entrySet()) {
            Integer idx = entry.getKey();
            String toonFile = entry.getValue();
            if (dumped) {
                result.append(", ");
            }
            result.append('(').append(idx).append(')');
            result.append(toonFile);
            dumped = true;
        }
        return result.toString();
    }

    static {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(0, "toon01.bmp");
        map.put(1, "toon02.bmp");
        map.put(2, "toon03.bmp");
        map.put(3, "toon04.bmp");
        map.put(4, "toon05.bmp");
        map.put(5, "toon06.bmp");
        map.put(6, "toon07.bmp");
        map.put(7, "toon08.bmp");
        map.put(8, "toon09.bmp");
        map.put(9, "toon10.bmp");
        map.put(255, "toon0.bmp");
        DEF_TOONMAP = Collections.unmodifiableMap(map);
    }
}

