/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd;

import jp.sourceforge.mikutoga.corelib.SerialNumbered;
import jp.sourceforge.mikutoga.pmd.BoneInfo;
import jp.sourceforge.mikutoga.pmd.Pos2d;
import jp.sourceforge.mikutoga.pmd.Pos3d;
import jp.sourceforge.mikutoga.pmd.Vec3d;

public class Vertex
implements SerialNumbered {
    private static final int MIN_WEIGHT = 0;
    private static final int MAX_WEIGHT = 100;
    private final Pos3d position = new Pos3d();
    private final Vec3d normal = new Vec3d();
    private final Pos2d uvPosition = new Pos2d();
    private BoneInfo boneA = null;
    private BoneInfo boneB = null;
    private int boneWeight = 50;
    private boolean edgeAppearance = true;
    private int serialNo = -1;

    public Pos3d getPosition() {
        return this.position;
    }

    public Vec3d getNormal() {
        return this.normal;
    }

    public Pos2d getUVPosition() {
        return this.uvPosition;
    }

    public void setBonePair(BoneInfo boneA, BoneInfo boneB) throws NullPointerException {
        if (boneA == null || boneB == null) {
            throw new NullPointerException();
        }
        this.boneA = boneA;
        this.boneB = boneB;
    }

    public BoneInfo getBoneA() {
        return this.boneA;
    }

    public BoneInfo getBoneB() {
        return this.boneB;
    }

    public void setWeightA(int weight) throws IllegalArgumentException {
        if (weight < 0 || 100 < weight) {
            throw new IllegalArgumentException();
        }
        this.boneWeight = weight;
    }

    public void setWeightB(int weight) throws IllegalArgumentException {
        this.setWeightA(100 - weight);
    }

    public int getWeightA() {
        return this.boneWeight;
    }

    public int getWeightB() {
        int result = 100 - this.boneWeight;
        return result;
    }

    public float getWeightRatioA() {
        return (float)this.boneWeight / 100.0f;
    }

    public float getWeightRatioB() {
        return (100.0f - (float)this.boneWeight) / 100.0f;
    }

    public void setEdgeAppearance(boolean show) {
        this.edgeAppearance = show;
    }

    public boolean getEdgeAppearance() {
        return this.edgeAppearance;
    }

    @Override
    public void setSerialNumber(int num) {
        this.serialNo = num;
    }

    @Override
    public int getSerialNumber() {
        return this.serialNo;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Vertex(").append(this.serialNo).append(") ");
        result.append(this.position).append(' ');
        result.append(this.normal).append(' ');
        result.append("UV").append(this.uvPosition).append(' ');
        result.append("[").append(this.boneA.getBoneName()).append("<>").append(this.boneB.getBoneName()).append("] ");
        result.append("weight=").append(this.boneWeight).append(' ');
        if (this.edgeAppearance) {
            result.append("showEdge");
        } else {
            result.append("hideEdge");
        }
        return result.toString();
    }
}

