/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.parser;

import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import jp.sourceforge.mikutoga.parser.MmdEofException;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.MmdSource;
import jp.sourceforge.mikutoga.parser.TextDecoder;

public class CommonParser {
    public static final Charset CS_WIN31J = Charset.forName("windows-31j");
    public static final Charset CS_UTF8 = Charset.forName("UTF-8");
    public static final Charset CS_UTF16LE = Charset.forName("UTF-16LE");
    private final MmdSource source;
    private final TextDecoder decoderWin31j = new TextDecoder(CS_WIN31J);
    private final TextDecoder decoderUTF8 = new TextDecoder(CS_UTF8);
    private final TextDecoder decoderUTF16LE = new TextDecoder(CS_UTF16LE);

    public CommonParser(MmdSource source) {
        this.source = source;
        this.decoderWin31j.setZeroChopMode(true);
        this.decoderUTF8.setZeroChopMode(false);
        this.decoderUTF16LE.setZeroChopMode(false);
    }

    protected MmdSource getSource() {
        return this.source;
    }

    protected long getPosition() {
        long result = this.source.getPosition();
        return result;
    }

    protected boolean hasMore() throws IOException {
        boolean result = this.source.hasMore();
        return result;
    }

    protected void skip(long skipLength) throws IOException, MmdEofException {
        long result = this.source.skip(skipLength);
        if (result != skipLength) {
            throw new MmdEofException(this.source.getPosition());
        }
    }

    protected void skip(int skipLength) throws IOException, MmdEofException {
        this.skip((long)skipLength);
    }

    protected byte parseByte() throws IOException, MmdEofException {
        return this.source.parseByte();
    }

    protected int parseUByteAsInteger() throws IOException, MmdEofException {
        return this.source.parseUByteAsInteger();
    }

    protected boolean parseBoolean() throws IOException, MmdEofException {
        return this.source.parseBoolean();
    }

    protected short parseShort() throws IOException, MmdEofException {
        return this.source.parseShort();
    }

    protected int parseUShortAsInteger() throws IOException, MmdEofException {
        return this.source.parseUShortAsInteger();
    }

    protected int parseInteger() throws IOException, MmdEofException {
        return this.source.parseInteger();
    }

    protected float parseFloat() throws IOException, MmdEofException {
        return this.source.parseFloat();
    }

    protected void parseByteArray(byte[] dst, int offset, int length) throws IOException, NullPointerException, IndexOutOfBoundsException, MmdEofException {
        this.source.parseByteArray(dst, offset, length);
    }

    protected void parseByteArray(byte[] dst) throws IOException, NullPointerException, MmdEofException {
        this.source.parseByteArray(dst);
    }

    protected void parseFloatArray(float[] dst, int offset, int length) throws IOException, NullPointerException, IndexOutOfBoundsException, MmdEofException {
        this.source.parseFloatArray(dst, offset, length);
    }

    protected void parseFloatArray(float[] dst) throws IOException, NullPointerException, MmdEofException {
        this.source.parseFloatArray(dst);
    }

    protected String parseZeroTermWin31J(int maxlen) throws IOException, MmdEofException, MmdFormatException {
        CharBuffer encoded = this.decoderWin31j.parseString(this.source, maxlen);
        String result = encoded.toString();
        return result;
    }

    protected String parseHollerithUtf8() throws IOException, MmdEofException, MmdFormatException {
        int byteLen = this.source.parseInteger();
        CharBuffer encoded = this.decoderUTF8.parseString(this.source, byteLen);
        String result = encoded.toString();
        return result;
    }

    protected String parseHollerithUtf16LE() throws IOException, MmdEofException, MmdFormatException {
        int byteLen = this.source.parseInteger();
        CharBuffer encoded = this.decoderUTF16LE.parseString(this.source, byteLen);
        String result = encoded.toString();
        return result;
    }
}

