/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.parser;

import java.io.IOException;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.MmdSource;
import jp.sourceforge.mikutoga.pmd.parser.PmdEngHandler;
import jp.sourceforge.mikutoga.pmd.parser.PmdParserBase;

public class PmdParserExt1
extends PmdParserBase {
    private PmdEngHandler engHandler = null;
    private boolean hasEnglishInfo = true;

    public PmdParserExt1(MmdSource source) {
        super(source);
    }

    public void setEngHandler(PmdEngHandler handler) {
        this.engHandler = handler;
    }

    @Override
    protected void parseBody() throws IOException, MmdFormatException {
        super.parseBody();
        if (this.hasMore()) {
            this.parseEngHeader();
            if (this.hasEnglishInfo) {
                this.parseEngBoneList();
                this.parseEngMorphName();
                this.parseEngBoneGroupName();
            }
        }
    }

    private void parseEngHeader() throws IOException, MmdFormatException {
        this.hasEnglishInfo = this.parseBoolean();
        if (this.engHandler != null) {
            this.engHandler.pmdEngEnabled(this.hasEnglishInfo);
        }
        if (!this.hasEnglishInfo) {
            return;
        }
        String modelName = this.parseZeroTermWin31J(20);
        String description = this.parseZeroTermWin31J(256);
        description = description.replace("\r\n", "\n");
        if (this.engHandler != null) {
            this.engHandler.pmdEngModelInfo(modelName, description);
        }
    }

    private void parseEngBoneList() throws IOException, MmdFormatException {
        int boneNum = this.getBoneCount();
        if (this.engHandler == null) {
            this.skip(20 * boneNum);
            return;
        }
        this.engHandler.loopStart(PmdEngHandler.ENGBONE_LIST, boneNum);
        for (int ct = 0; ct < boneNum; ++ct) {
            String boneName = this.parseZeroTermWin31J(20);
            this.engHandler.pmdEngBoneInfo(boneName);
            this.engHandler.loopNext(PmdEngHandler.ENGBONE_LIST);
        }
        this.engHandler.loopEnd(PmdEngHandler.ENGBONE_LIST);
    }

    private void parseEngMorphName() throws IOException, MmdFormatException {
        int morphNum = this.getMorphCount() - 1;
        if (this.engHandler == null) {
            this.skip(20 * morphNum);
            return;
        }
        this.engHandler.loopStart(PmdEngHandler.ENGMORPH_LIST, morphNum);
        for (int ct = 0; ct < morphNum; ++ct) {
            String morphName = this.parseZeroTermWin31J(20);
            this.engHandler.pmdEngMorphInfo(morphName);
            this.engHandler.loopNext(PmdEngHandler.ENGMORPH_LIST);
        }
        this.engHandler.loopEnd(PmdEngHandler.ENGMORPH_LIST);
    }

    private void parseEngBoneGroupName() throws IOException, MmdFormatException {
        int groupNum = this.getBoneGroupCount();
        if (this.engHandler == null) {
            this.skip(50 * groupNum);
            return;
        }
        this.engHandler.loopStart(PmdEngHandler.ENGBONEGROUP_LIST, groupNum);
        for (int ct = 0; ct < groupNum; ++ct) {
            String boneGroupName = this.parseZeroTermWin31J(50);
            this.engHandler.pmdEngBoneGroupInfo(boneGroupName);
            this.engHandler.loopNext(PmdEngHandler.ENGBONEGROUP_LIST);
        }
        this.engHandler.loopEnd(PmdEngHandler.ENGBONEGROUP_LIST);
    }
}

