/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.typical;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.mikutoga.typical.TypicalObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class TypicalBone
extends TypicalObject {
    private static final Class<?> THISCLASS;
    private static final String BONE_XML = "resources/typicalBone.xml";
    private static final List<TypicalBone> TYP_BONE_LIST;
    private static final Map<String, TypicalBone> PRIMARY_MAP;
    private static final Map<String, TypicalBone> GLOBAL_MAP;

    private TypicalBone(int primaryNo, int globalNo) {
        super(primaryNo, globalNo);
    }

    private static void parse(Element top) {
        NodeList boneList = top.getElementsByTagName("bone");
        int boneNo = boneList.getLength();
        for (int idx = 0; idx < boneNo; ++idx) {
            Element bone = (Element)boneList.item(idx);
            TypicalBone typBone = TypicalBone.parseBone(bone);
            TYP_BONE_LIST.add(typBone);
        }
    }

    private static TypicalBone parseBone(Element bone) {
        String name;
        int idx;
        NodeList primaryNodes = bone.getElementsByTagName("primary");
        NodeList globalNodes = bone.getElementsByTagName("global");
        int primaryNo = primaryNodes.getLength();
        int globalNo = globalNodes.getLength();
        TypicalBone typBone = new TypicalBone(primaryNo, globalNo);
        for (idx = 0; idx < primaryNo; ++idx) {
            Element primary = (Element)primaryNodes.item(idx);
            name = primary.getAttribute("name");
            typBone.primaryList.add(name);
        }
        for (idx = 0; idx < globalNo; ++idx) {
            Element global = (Element)globalNodes.item(idx);
            name = global.getAttribute("name");
            typBone.globalList.add(name);
        }
        for (String primaryName : typBone.primaryList) {
            PRIMARY_MAP.put(primaryName, typBone);
        }
        for (String globalName : typBone.globalList) {
            GLOBAL_MAP.put(globalName, typBone);
        }
        return typBone;
    }

    private static void numbering() {
        int order = 0;
        for (TypicalBone bone : TYP_BONE_LIST) {
            bone.orderNo = order++;
        }
    }

    public static TypicalBone findWithPrimary(String primaryName) {
        TypicalBone result = PRIMARY_MAP.get(primaryName);
        return result;
    }

    public static TypicalBone findWithGlobal(String globalName) {
        TypicalBone result = GLOBAL_MAP.get(globalName);
        return result;
    }

    public static String primary2global(String primaryName) {
        TypicalBone bone = TypicalBone.findWithPrimary(primaryName);
        if (bone == null) {
            return null;
        }
        String global = bone.getTopGlobalName();
        return global;
    }

    public static String global2primary(String globalName) {
        TypicalBone bone = TypicalBone.findWithGlobal(globalName);
        if (bone == null) {
            return null;
        }
        String primary = bone.getTopPrimaryName();
        return primary;
    }

    static {
        Element top;
        THISCLASS = TypicalBone.class;
        TYP_BONE_LIST = new LinkedList<TypicalBone>();
        PRIMARY_MAP = new HashMap<String, TypicalBone>();
        GLOBAL_MAP = new HashMap<String, TypicalBone>();
        InputStream is = THISCLASS.getResourceAsStream(BONE_XML);
        try {
            top = TypicalObject.loadXml(is);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (SAXException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        TypicalBone.parse(top);
        TypicalBone.numbering();
    }
}

