/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model;

import jp.sourceforge.mikutoga.vmd.AbstractNumbered;
import jp.sourceforge.mikutoga.vmd.model.ShadowMode;

public class ShadowMotion
extends AbstractNumbered {
    public static final ShadowMode DEF_MODE = ShadowMode.MODE_1;
    public static final float DEF_SCOPE = 0.01125f;
    private static final double OFFSET = 0.1;
    private static final double SCALE = 100000.0;
    private ShadowMode shadowMode = DEF_MODE;
    private float rawScopeParam = 0.01125f;

    public static double rawParamToScope(float param) {
        double result = 0.1 - (double)param;
        return result *= 100000.0;
    }

    public static float scopeToRawParam(double scope) {
        double result = scope / 100000.0;
        result = 0.1 - result;
        return (float)result;
    }

    public void setRawScopeParam(float rawScopeParam) {
        this.rawScopeParam = rawScopeParam;
    }

    public float getRawScopeParam() {
        return this.rawScopeParam;
    }

    public void setScope(double scope) {
        float rawVal = ShadowMotion.scopeToRawParam(scope);
        this.setRawScopeParam(rawVal);
    }

    public double getScope() {
        float rawVal = this.getRawScopeParam();
        double scope = ShadowMotion.rawParamToScope(rawVal);
        return scope;
    }

    public void setShadowMode(ShadowMode shadowMode) throws NullPointerException {
        if (shadowMode == null) {
            throw new NullPointerException();
        }
        this.shadowMode = shadowMode;
    }

    public ShadowMode getShadowMode() {
        return this.shadowMode;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("#").append(this.getFrameNumber());
        result.append(" shadow mode : ").append((Object)this.shadowMode);
        result.append(" rawparam=").append(this.rawScopeParam);
        return result.toString();
    }
}

