/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model.binio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mikutoga.binio.BinaryExporter;
import jp.sourceforge.mikutoga.binio.IllegalTextExportException;
import jp.sourceforge.mikutoga.math.MkPos3D;
import jp.sourceforge.mikutoga.math.MkQuat;
import jp.sourceforge.mikutoga.vmd.model.BezierParam;
import jp.sourceforge.mikutoga.vmd.model.BoneMotion;
import jp.sourceforge.mikutoga.vmd.model.MorphMotion;
import jp.sourceforge.mikutoga.vmd.model.NamedListMap;
import jp.sourceforge.mikutoga.vmd.model.PosCurve;
import jp.sourceforge.mikutoga.vmd.model.VmdMotion;

class BasicExporter
extends BinaryExporter {
    private static final int BZ_SIZE = 4;
    private static final int BZXYZR_SIZE = 16;
    private static final int BZ_REDUNDANT = 4;
    private static final int BZTOTAL_SIZE = 64;
    private static final byte[] FDFILLER = new byte[]{0, -3};
    private final byte[] motionIntplt = new byte[64];

    BasicExporter(OutputStream stream) {
        super(stream);
    }

    void dumpBoneMotion(VmdMotion motion) throws IOException, IllegalTextExportException {
        NamedListMap<BoneMotion> map = motion.getBonePartMap();
        List<String> nameList = map.getNames();
        LinkedList<BoneMotion> bmotionList = new LinkedList<BoneMotion>();
        int count = 0;
        for (String name : nameList) {
            List<BoneMotion> namedList = map.getNamedList(name);
            for (BoneMotion boneMotion : namedList) {
                bmotionList.add(boneMotion);
                ++count;
            }
        }
        this.dumpInt(count);
        for (BoneMotion boneMotion : bmotionList) {
            String boneName = boneMotion.getBoneName();
            this.dumpFixedW31j(boneName, 15, FDFILLER);
            int frame = boneMotion.getFrameNumber();
            this.dumpInt(frame);
            MkPos3D position = boneMotion.getPosition();
            this.dumpBonePosition(position);
            MkQuat rotation = boneMotion.getRotation();
            this.dumpBoneRotation(rotation);
            this.dumpBoneInterpolation(boneMotion);
        }
    }

    private void dumpBonePosition(MkPos3D position) throws IOException {
        float xPos = (float)position.getXpos();
        float yPos = (float)position.getYpos();
        float zPos = (float)position.getZpos();
        this.dumpFloat(xPos);
        this.dumpFloat(yPos);
        this.dumpFloat(zPos);
    }

    private void dumpBoneRotation(MkQuat rotation) throws IOException {
        float qx = (float)rotation.getQ1();
        float qy = (float)rotation.getQ2();
        float qz = (float)rotation.getQ3();
        float qw = (float)rotation.getQW();
        this.dumpFloat(qx);
        this.dumpFloat(qy);
        this.dumpFloat(qz);
        this.dumpFloat(qw);
    }

    private void dumpBoneInterpolation(BoneMotion boneMotion) throws IOException {
        PosCurve posCurve = boneMotion.getPosCurve();
        BezierParam xCurve = posCurve.getIntpltXpos();
        BezierParam yCurve = posCurve.getIntpltYpos();
        BezierParam zCurve = posCurve.getIntpltZpos();
        BezierParam rCurve = boneMotion.getIntpltRotation();
        int idx = 0;
        this.motionIntplt[idx++] = xCurve.getP1x();
        this.motionIntplt[idx++] = yCurve.getP1x();
        this.motionIntplt[idx++] = zCurve.getP1x();
        this.motionIntplt[idx++] = rCurve.getP1x();
        this.motionIntplt[idx++] = xCurve.getP1y();
        this.motionIntplt[idx++] = yCurve.getP1y();
        this.motionIntplt[idx++] = zCurve.getP1y();
        this.motionIntplt[idx++] = rCurve.getP1y();
        this.motionIntplt[idx++] = xCurve.getP2x();
        this.motionIntplt[idx++] = yCurve.getP2x();
        this.motionIntplt[idx++] = zCurve.getP2x();
        this.motionIntplt[idx++] = rCurve.getP2x();
        this.motionIntplt[idx++] = xCurve.getP2y();
        this.motionIntplt[idx++] = yCurve.getP2y();
        this.motionIntplt[idx++] = zCurve.getP2y();
        this.motionIntplt[idx++] = rCurve.getP2y();
        assert (idx == 16);
        this.redundantCopy();
        this.dumpByteArray(this.motionIntplt);
    }

    private void redundantCopy() {
        int lack = 1;
        for (int ct = 1; ct < 4; ++ct) {
            int sourceIdx = 0 + lack;
            int targetIdx = 16 * ct;
            int span = 16 - lack;
            System.arraycopy(this.motionIntplt, sourceIdx, this.motionIntplt, targetIdx, span);
            int onePos = targetIdx + span;
            this.motionIntplt[onePos] = 1;
            int zeroPosStart = onePos + 1;
            int zeroPosEnd = targetIdx + 16;
            for (int idx = zeroPosStart; idx < zeroPosEnd; ++idx) {
                this.motionIntplt[idx] = 0;
            }
            ++lack;
        }
    }

    void dumpMorphMotion(VmdMotion motion) throws IOException, IllegalTextExportException {
        NamedListMap<MorphMotion> map = motion.getMorphPartMap();
        List<String> nameList = map.getNames();
        LinkedList<MorphMotion> morphList = new LinkedList<MorphMotion>();
        int count = 0;
        for (String name : nameList) {
            List<MorphMotion> namedList = map.getNamedList(name);
            for (MorphMotion morphMotion : namedList) {
                morphList.add(morphMotion);
                ++count;
            }
        }
        this.dumpInt(count);
        for (MorphMotion morphMotion : morphList) {
            String morphName = morphMotion.getMorphName();
            this.dumpFixedW31j(morphName, 15, FDFILLER);
            int frame = morphMotion.getFrameNumber();
            this.dumpInt(frame);
            float flex = morphMotion.getFlex();
            this.dumpFloat(flex);
        }
    }
}

