/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model.binio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.sourceforge.mikutoga.binio.BinaryExporter;
import jp.sourceforge.mikutoga.vmd.model.LuminousColor;
import jp.sourceforge.mikutoga.vmd.model.LuminousMotion;
import jp.sourceforge.mikutoga.vmd.model.LuminousVector;
import jp.sourceforge.mikutoga.vmd.model.ShadowMode;
import jp.sourceforge.mikutoga.vmd.model.ShadowMotion;
import jp.sourceforge.mikutoga.vmd.model.VmdMotion;

class LightingExporter
extends BinaryExporter {
    LightingExporter(OutputStream stream) {
        super(stream);
    }

    void dumpLuminousMotion(VmdMotion motion) throws IOException {
        List<LuminousMotion> list = motion.getLuminousMotionList();
        int count = list.size();
        this.dumpInt(count);
        for (LuminousMotion luminousMotion : list) {
            int frame = luminousMotion.getFrameNumber();
            this.dumpInt(frame);
            LuminousColor color = luminousMotion.getColor();
            this.dumpFloat(color.getColR());
            this.dumpFloat(color.getColG());
            this.dumpFloat(color.getColB());
            LuminousVector vector = luminousMotion.getDirection();
            this.dumpFloat(vector.getVecX());
            this.dumpFloat(vector.getVecY());
            this.dumpFloat(vector.getVecZ());
        }
    }

    void dumpShadowMotion(VmdMotion motion) throws IOException {
        List<ShadowMotion> list = motion.getShadowMotionList();
        int count = list.size();
        this.dumpInt(count);
        for (ShadowMotion shadowMotion : list) {
            int frame = shadowMotion.getFrameNumber();
            this.dumpInt(frame);
            ShadowMode mode = shadowMotion.getShadowMode();
            byte shadowType = mode.getEncodedByte();
            this.dumpByte(shadowType);
            float rawParam = shadowMotion.getRawScopeParam();
            this.dumpFloat(rawParam);
        }
    }
}

