/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model.binio;

import java.io.IOException;
import java.io.OutputStream;
import jp.sourceforge.mikutoga.binio.BinaryExporter;
import jp.sourceforge.mikutoga.binio.IllegalTextExportException;
import jp.sourceforge.mikutoga.vmd.IllegalVmdDataException;
import jp.sourceforge.mikutoga.vmd.VmdConst;
import jp.sourceforge.mikutoga.vmd.model.VmdMotion;
import jp.sourceforge.mikutoga.vmd.model.binio.BasicExporter;
import jp.sourceforge.mikutoga.vmd.model.binio.CameraExporter;
import jp.sourceforge.mikutoga.vmd.model.binio.LightingExporter;

public class VmdExporter
extends BinaryExporter {
    private static final byte[] HEADFILLER = new byte[]{74, 75, 76, 77};
    private static final byte[] FDFILLER = new byte[]{0, -3};
    private final BasicExporter basicExporter;
    private final CameraExporter cameraExporter;
    private final LightingExporter lightingExporter;

    public VmdExporter(OutputStream stream) {
        super(stream);
        this.basicExporter = new BasicExporter(stream);
        this.cameraExporter = new CameraExporter(stream);
        this.lightingExporter = new LightingExporter(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpVmdMotion(VmdMotion motion) throws IOException, IllegalVmdDataException {
        try {
            this.dumpVmdMotionImpl(motion);
        }
        finally {
            this.flush();
        }
    }

    private void dumpVmdMotionImpl(VmdMotion motion) throws IOException, IllegalVmdDataException {
        this.dumpHeader();
        try {
            this.dumpModelName(motion);
            this.basicExporter.dumpBoneMotion(motion);
            this.basicExporter.dumpMorphMotion(motion);
        }
        catch (IllegalTextExportException e) {
            throw new IllegalVmdDataException(e);
        }
        this.cameraExporter.dumpCameraMotion(motion);
        this.lightingExporter.dumpLuminousMotion(motion);
        this.lightingExporter.dumpShadowMotion(motion);
    }

    private void dumpHeader() throws IOException {
        byte[] header = VmdConst.createMagicHeader();
        this.dumpByteArray(header);
        this.dumpByteArray(HEADFILLER);
        assert (header.length + HEADFILLER.length == 30);
    }

    private void dumpModelName(VmdMotion motion) throws IOException, IllegalTextExportException {
        String modelName = motion.getModelName();
        if (modelName == null) {
            modelName = "\u30ab\u30e1\u30e9\u30fb\u7167\u660e";
        }
        this.dumpFixedW31j(modelName, 20, FDFILLER);
    }
}

