/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.sourceforge.mikutoga.math.EulerYXZ;
import jp.sourceforge.mikutoga.math.MkPos3D;
import jp.sourceforge.mikutoga.math.MkQuat;
import jp.sourceforge.mikutoga.typical.TypicalBone;
import jp.sourceforge.mikutoga.typical.TypicalMorph;
import jp.sourceforge.mikutoga.vmd.IllegalVmdDataException;
import jp.sourceforge.mikutoga.vmd.VmdConst;
import jp.sourceforge.mikutoga.vmd.model.BezierParam;
import jp.sourceforge.mikutoga.vmd.model.BoneMotion;
import jp.sourceforge.mikutoga.vmd.model.CameraMotion;
import jp.sourceforge.mikutoga.vmd.model.CameraRotation;
import jp.sourceforge.mikutoga.vmd.model.LuminousColor;
import jp.sourceforge.mikutoga.vmd.model.LuminousMotion;
import jp.sourceforge.mikutoga.vmd.model.LuminousVector;
import jp.sourceforge.mikutoga.vmd.model.MorphMotion;
import jp.sourceforge.mikutoga.vmd.model.NamedListMap;
import jp.sourceforge.mikutoga.vmd.model.PosCurve;
import jp.sourceforge.mikutoga.vmd.model.ShadowMode;
import jp.sourceforge.mikutoga.vmd.model.ShadowMotion;
import jp.sourceforge.mikutoga.vmd.model.VmdMotion;
import jp.sourceforge.mikutoga.xml.BasicXmlExporter;

public class VmdXmlExporter
extends BasicXmlExporter {
    private static final String XSINS = "xsi";
    private static final String TOP_COMMENT = "  MikuMikuDance\n    motion-data(*.vmd) on XML";
    private static final String QUATERNION_COMMENT = "  bone-rotation has Quaternion parameters [boneRotQuat]\n  or YXZ-Euler angles [boneRotEyxz].\n  Quaternion is strongly recommended if you are data-exchanging.";
    private static final String BEZIER_COMMENT = "  motion interpolation is defined by Bezier-cubic-curve.\n  implicit bezier curve point : P0=(0,0) P3=(127,127)\n  defLinear : MMD default linear curve. P1=(20,20) P2=(107,107) [DEFAULT]\n  defEaseInOut : MMD default ease-in-out curve. P1=(64,0) P2=(64,127)";
    private static final String CAMERA_COMMENT = "  camera-rotation has polar-coordinates parameters.\n  xRad = -radian(UI_X) [latitude]\n  yRad =  radian(UI_Y) [longitude]\n  zRad =  radian(UI_Z) [roll]\n  range = -(UI_RANGE)";
    private static final String SHADOW_COMMENT = "  UI_VALUE = EFFECTIVE_RANGE * 100 ???\n  rawParam = 0.1 - (UI_VALUE / 1.0E+5)\n\n  NONE   : no self-shadow\n  MODE_1 : reduce shadow-quality suddenly at range\n  MODE_2 : reduce shadow-quality gradually with range";
    private boolean isQuaternionMode = true;
    private String generator = "";

    public VmdXmlExporter(OutputStream stream) {
        super(stream);
    }

    public void setQuaternionMode(boolean mode) {
        this.isQuaternionMode = mode;
    }

    public void setGenerator(String generatorArg) throws NullPointerException {
        if (generatorArg == null) {
            throw new NullPointerException();
        }
        this.generator = generatorArg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putVmdXml(VmdMotion vmdMotion) throws IOException, IllegalVmdDataException {
        try {
            this.putVmdXmlImpl(vmdMotion);
        }
        finally {
            this.flush();
        }
    }

    private void putVmdXmlImpl(VmdMotion vmdMotion) throws IOException, IllegalVmdDataException {
        this.ind().put("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>").ln(2);
        this.ind().putBlockComment(TOP_COMMENT).ln(2);
        this.ind().put("<vmdMotion").ln();
        this.pushNest();
        this.ind().putAttr("xmlns", "http://mikutoga.sourceforge.jp/xml/ns/vmdxml/110820").ln();
        this.ind().putAttr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").ln();
        this.ind().put(XSINS).put(":schemaLocation=").put('\"');
        this.put("http://mikutoga.sourceforge.jp/xml/ns/vmdxml/110820").ln();
        this.ind().sp(2).put("http://mikutoga.sourceforge.jp/xml/xsd/vmdxml-110820.xsd").put('\"').ln();
        this.ind().putAttr("version", "110820").ln();
        this.popNest();
        this.put(">").ln(2);
        if (this.generator != null && this.generator.length() > 0) {
            this.ind().put("<meta ");
            this.putAttr("name", "generator").put(' ');
            this.putAttr("content", this.generator);
            this.put(" />").ln(2);
        }
        if (vmdMotion.isModelMotion()) {
            this.putModelName(vmdMotion);
            this.putBoneMotionSequence(vmdMotion);
            this.putMorphSequence(vmdMotion);
        } else {
            this.putCameraSequence(vmdMotion);
            this.putLuminousSequence(vmdMotion);
            this.putShadowSequence(vmdMotion);
        }
        this.ind().put("</vmdMotion>").ln(2);
        this.ind().put("<!-- EOF -->").ln();
    }

    private void putPositionCurve(PosCurve posCurve) throws IOException {
        BezierParam xCurve = posCurve.getIntpltXpos();
        BezierParam yCurve = posCurve.getIntpltYpos();
        BezierParam zCurve = posCurve.getIntpltZpos();
        this.ind().putLineComment("X-Y-Z interpolation *3").ln();
        this.ind();
        this.putBezierCurve(xCurve);
        this.ln();
        this.ind();
        this.putBezierCurve(yCurve);
        this.ln();
        this.ind();
        this.putBezierCurve(zCurve);
        this.ln();
    }

    private void putBezierCurve(BezierParam bezier) throws IOException {
        if (bezier.isDefaultLinear()) {
            this.put("<defLinear />");
        } else if (bezier.isDefaultEaseInOut()) {
            this.put("<defEaseInOut />");
        } else {
            this.put("<bezier ");
            this.putIntAttr("p1x", bezier.getP1x()).sp();
            this.putIntAttr("p1y", bezier.getP1y()).sp();
            this.putIntAttr("p2x", bezier.getP2x()).sp();
            this.putIntAttr("p2y", bezier.getP2y()).sp();
            this.put("/>");
        }
    }

    private void putModelName(VmdMotion vmdMotion) throws IOException {
        String modelName = vmdMotion.getModelName();
        this.ind().putLineComment(modelName).ln();
        this.ind().put("<modelName ");
        this.putAttr("name", modelName).sp();
        this.put("/>").ln(2);
    }

    private void putBoneMotionSequence(VmdMotion vmdMotion) throws IOException {
        this.ind().putBlockComment(QUATERNION_COMMENT);
        this.ind().putBlockComment(BEZIER_COMMENT);
        this.ind().put("<boneMotionSequence>").ln();
        this.pushNest();
        NamedListMap<BoneMotion> listmap = vmdMotion.getBonePartMap();
        if (!listmap.isEmpty()) {
            this.ln();
        }
        for (String boneName : listmap.getNames()) {
            List<BoneMotion> list = listmap.getNamedList(boneName);
            this.putBonePart(boneName, list);
        }
        this.popNest();
        this.ind().put("</boneMotionSequence>").ln(2);
    }

    private void putBonePart(String boneName, List<BoneMotion> list) throws IOException {
        this.ind().putLineComment(boneName);
        String globalName = TypicalBone.primary2global(boneName);
        if (globalName != null) {
            this.sp(2).putLineComment("Perhaps : [" + globalName + "]");
        }
        this.ln();
        this.ind().put("<bonePart ");
        this.putAttr("name", boneName).sp();
        this.put(">").ln(2);
        this.pushNest();
        for (BoneMotion bone : list) {
            this.putBoneMotion(bone);
        }
        this.popNest();
        this.ind().put("</bonePart>").ln(2);
    }

    private void putBoneMotion(BoneMotion boneMotion) throws IOException {
        this.ind().put("<boneMotion ");
        int frameNo = boneMotion.getFrameNumber();
        this.putIntAttr("frame", frameNo).sp();
        this.put(">").ln();
        this.pushNest();
        this.putBonePosition(boneMotion);
        if (this.isQuaternionMode) {
            this.putBoneRotQuat(boneMotion);
        } else {
            this.putBoneRotEyxz(boneMotion);
        }
        this.popNest();
        this.ind().put("</boneMotion>").ln(2);
    }

    private void putBonePosition(BoneMotion boneMotion) throws IOException {
        if (boneMotion.hasImplicitPosition()) {
            return;
        }
        this.ind().put("<bonePosition ");
        MkPos3D position = boneMotion.getPosition();
        float xPos = (float)position.getXpos();
        float yPos = (float)position.getYpos();
        float zPos = (float)position.getZpos();
        this.putFloatAttr("xPos", xPos).sp();
        this.putFloatAttr("yPos", yPos).sp();
        this.putFloatAttr("zPos", zPos).sp();
        PosCurve posCurve = boneMotion.getPosCurve();
        if (posCurve.isDefaultLinear()) {
            this.put("/>").ln();
        } else {
            this.put(">").ln();
            this.pushNest();
            this.putPositionCurve(posCurve);
            this.popNest();
            this.ind().put("</bonePosition>").ln();
        }
    }

    private void putBoneRotQuat(BoneMotion boneMotion) throws IOException {
        MkQuat rotation = boneMotion.getRotation();
        BezierParam rotCurve = boneMotion.getIntpltRotation();
        this.ind().put("<boneRotQuat").ln();
        this.pushNest();
        this.ind().putFloatAttr("qx", (float)rotation.getQ1()).ln();
        this.ind().putFloatAttr("qy", (float)rotation.getQ2()).ln();
        this.ind().putFloatAttr("qz", (float)rotation.getQ3()).ln();
        this.ind().putFloatAttr("qw", (float)rotation.getQW()).ln();
        this.popNest();
        this.ind();
        if (rotCurve.isDefaultLinear()) {
            this.put("/>").ln();
        } else {
            this.put(">").ln();
            this.pushNest();
            this.ind();
            this.putBezierCurve(rotCurve);
            this.ln();
            this.popNest();
            this.ind().put("</boneRotQuat>").ln();
        }
    }

    private void putBoneRotEyxz(BoneMotion boneMotion) throws IOException {
        MkQuat rotation = boneMotion.getRotation();
        BezierParam rotCurve = boneMotion.getIntpltRotation();
        EulerYXZ euler = new EulerYXZ();
        rotation.toEulerYXZ(euler);
        float xDeg = (float)StrictMath.toDegrees(euler.getXRot());
        float yDeg = (float)StrictMath.toDegrees(euler.getYRot());
        float zDeg = (float)StrictMath.toDegrees(euler.getZRot());
        this.ind().put("<boneRotEyxz").ln();
        this.pushNest();
        this.ind().putFloatAttr("xDeg", xDeg).ln();
        this.ind().putFloatAttr("yDeg", yDeg).ln();
        this.ind().putFloatAttr("zDeg", zDeg).ln();
        this.popNest();
        this.ind();
        if (rotCurve.isDefaultLinear()) {
            this.put("/>").ln();
        } else {
            this.put(">").ln();
            this.pushNest();
            this.ind();
            this.putBezierCurve(rotCurve);
            this.ln();
            this.popNest();
            this.ind().put("</boneRotEyxz>").ln();
        }
    }

    private void putMorphSequence(VmdMotion vmdMotion) throws IOException {
        this.ind().put("<morphSequence>").ln();
        this.pushNest();
        NamedListMap<MorphMotion> listmap = vmdMotion.getMorphPartMap();
        if (!listmap.isEmpty()) {
            this.ln();
        }
        this.putMorphPartList(listmap);
        this.popNest();
        this.ind().put("</morphSequence>").ln(2);
    }

    private void putMorphPartList(NamedListMap<MorphMotion> listmap) throws IOException {
        for (String morphName : listmap.getNames()) {
            if (VmdConst.isBaseMorphName(morphName)) continue;
            this.ind().putLineComment(morphName);
            String globalName = TypicalMorph.primary2global(morphName);
            if (globalName != null) {
                this.sp(2).putLineComment("Perhaps : [" + globalName + "]");
            }
            this.ln();
            this.ind().put("<morphPart ");
            this.putAttr("name", morphName).sp();
            this.put(">").ln();
            this.pushNest();
            List<MorphMotion> list = listmap.getNamedList(morphName);
            for (MorphMotion morph : list) {
                this.putMorphMotion(morph);
            }
            this.popNest();
            this.ind().put("</morphPart>").ln(2);
        }
    }

    private void putMorphMotion(MorphMotion morphMotion) throws IOException {
        this.ind().put("<morphMotion ");
        int frameNo = morphMotion.getFrameNumber();
        float flex = morphMotion.getFlex();
        this.putIntAttr("frame", frameNo).sp();
        this.putFloatAttr("flex", flex).sp();
        this.put("/>").ln();
    }

    private void putCameraSequence(VmdMotion vmdMotion) throws IOException {
        this.ind().putBlockComment(BEZIER_COMMENT);
        this.ind().putBlockComment(CAMERA_COMMENT);
        this.ind().put("<cameraSequence>").ln();
        this.pushNest();
        List<CameraMotion> list = vmdMotion.getCameraMotionList();
        if (!list.isEmpty()) {
            this.ln();
        }
        for (CameraMotion camera : list) {
            this.putCameraMotion(camera);
        }
        this.popNest();
        this.ind().put("</cameraSequence>").ln(2);
    }

    private void putCameraMotion(CameraMotion cameraMotion) throws IOException {
        this.ind().put("<cameraMotion ");
        int frameNo = cameraMotion.getFrameNumber();
        this.putIntAttr("frame", frameNo).sp();
        if (!cameraMotion.hasPerspective()) {
            this.putAttr("hasPerspective", "false").sp();
        }
        this.put(">").ln();
        this.pushNest();
        this.putCameraTarget(cameraMotion);
        this.putCameraRotation(cameraMotion);
        this.putCameraRange(cameraMotion);
        this.putProjection(cameraMotion);
        this.popNest();
        this.ind().put("</cameraMotion>").ln(2);
    }

    private void putCameraTarget(CameraMotion cameraMotion) throws IOException {
        this.ind().put("<cameraTarget ");
        MkPos3D position = cameraMotion.getCameraTarget();
        this.putFloatAttr("xPos", (float)position.getXpos()).sp();
        this.putFloatAttr("yPos", (float)position.getYpos()).sp();
        this.putFloatAttr("zPos", (float)position.getZpos()).sp();
        PosCurve posCurve = cameraMotion.getTargetPosCurve();
        if (posCurve.isDefaultLinear()) {
            this.put("/>").ln();
        } else {
            this.put(">").ln();
            this.pushNest();
            this.putPositionCurve(posCurve);
            this.popNest();
            this.ind().put("</cameraTarget>").ln();
        }
    }

    private void putCameraRotation(CameraMotion cameraMotion) throws IOException {
        this.ind().put("<cameraRotation ");
        CameraRotation rotation = cameraMotion.getCameraRotation();
        this.putFloatAttr("xRad", rotation.getLatitude()).sp();
        this.putFloatAttr("yRad", rotation.getLongitude()).sp();
        this.putFloatAttr("zRad", rotation.getRoll()).sp();
        BezierParam rotCurve = cameraMotion.getIntpltRotation();
        if (rotCurve.isDefaultLinear()) {
            this.put("/>").ln();
        } else {
            this.put(">").ln();
            this.pushNest();
            this.ind();
            this.putBezierCurve(rotCurve);
            this.ln();
            this.popNest();
            this.ind().put("</cameraRotation>").ln();
        }
    }

    private void putCameraRange(CameraMotion cameraMotion) throws IOException {
        this.ind().put("<cameraRange ");
        float range = cameraMotion.getRange();
        this.putFloatAttr("range", range).sp();
        BezierParam rangeCurve = cameraMotion.getIntpltRange();
        if (rangeCurve.isDefaultLinear()) {
            this.put("/>").ln();
        } else {
            this.put(">").ln();
            this.pushNest();
            this.ind();
            this.putBezierCurve(rangeCurve);
            this.ln();
            this.popNest();
            this.ind().put("</cameraRange>").ln();
        }
    }

    private void putProjection(CameraMotion cameraMotion) throws IOException {
        this.ind().put("<projection ");
        this.putIntAttr("vertDeg", cameraMotion.getProjectionAngle()).sp();
        BezierParam projCurve = cameraMotion.getIntpltProjection();
        if (projCurve.isDefaultLinear()) {
            this.put("/>").ln();
        } else {
            this.put(">").ln();
            this.pushNest();
            this.ind();
            this.putBezierCurve(projCurve);
            this.ln();
            this.popNest();
            this.ind().put("</projection>").ln();
        }
    }

    private void putLuminousSequence(VmdMotion vmdMotion) throws IOException {
        this.ind().put("<luminousSequence>").ln();
        this.pushNest();
        List<LuminousMotion> list = vmdMotion.getLuminousMotionList();
        if (!list.isEmpty()) {
            this.ln();
        }
        for (LuminousMotion luminous : list) {
            this.putLuminousMotion(luminous);
        }
        this.popNest();
        this.ind().put("</luminousSequence>").ln(2);
    }

    private void putLuminousMotion(LuminousMotion luminousMotion) throws IOException {
        this.ind().put("<luminousAct ");
        int frameNo = luminousMotion.getFrameNumber();
        this.putIntAttr("frame", frameNo);
        this.put(" >").ln();
        LuminousColor color = luminousMotion.getColor();
        LuminousVector vector = luminousMotion.getDirection();
        this.pushNest();
        this.putLuminousColor(color);
        this.putLuminousDirection(vector);
        this.popNest();
        this.ind().put("</luminousAct>").ln(2);
    }

    private void putLuminousColor(LuminousColor color) throws IOException {
        this.ind().put("<lumiColor ");
        this.putFloatAttr("rCol", color.getColR()).sp();
        this.putFloatAttr("gCol", color.getColG()).sp();
        this.putFloatAttr("bCol", color.getColB()).sp();
        this.put("/>").ln();
    }

    private void putLuminousDirection(LuminousVector vector) throws IOException {
        this.ind().put("<lumiDirection ");
        this.putFloatAttr("xVec", vector.getVecX()).sp();
        this.putFloatAttr("yVec", vector.getVecY()).sp();
        this.putFloatAttr("zVec", vector.getVecZ()).sp();
        this.put("/>").ln();
    }

    private void putShadowSequence(VmdMotion vmdMotion) throws IOException {
        this.ind().putBlockComment(SHADOW_COMMENT);
        this.ind().put("<shadowSequence>").ln();
        this.pushNest();
        List<ShadowMotion> list = vmdMotion.getShadowMotionList();
        for (ShadowMotion shadow : list) {
            this.putShadowMotion(shadow);
        }
        this.popNest();
        this.ind().put("</shadowSequence>").ln(2);
    }

    private void putShadowMotion(ShadowMotion shadowMotion) throws IOException {
        this.ind().put("<shadowAct ");
        int frameNo = shadowMotion.getFrameNumber();
        ShadowMode mode = shadowMotion.getShadowMode();
        float rawParam = shadowMotion.getRawScopeParam();
        this.putIntAttr("frame", frameNo).sp();
        this.putAttr("mode", mode.name()).sp();
        this.putFloatAttr("rawParam", rawParam).sp();
        this.put("/>");
        double uiVal = ShadowMotion.rawParamToScope(rawParam);
        long lVal = Math.round(uiVal);
        this.sp().putLineComment("UI:" + lVal).ln();
    }
}

