/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model.xml;

import jp.sourceforge.mikutoga.vmd.model.BezierParam;
import jp.sourceforge.mikutoga.vmd.model.PosCurve;
import jp.sourceforge.mikutoga.xml.DomNsUtils;
import jp.sourceforge.mikutoga.xml.SiblingElemIterator;
import jp.sourceforge.mikutoga.xml.TogaXmlException;
import org.w3c.dom.Element;

final class Xml {
    static final String NS_NULL = null;

    private Xml() {
        assert (false);
        throw new AssertionError();
    }

    static boolean hasNsLocalNameElem(Element elem, String localName) {
        return DomNsUtils.hasNsLocalNameElem(elem, "http://mikutoga.sourceforge.jp/xml/ns/vmdxml/110820", localName);
    }

    static Element pickChild(Element parent, String localName) {
        return DomNsUtils.pickFirstChild(parent, "http://mikutoga.sourceforge.jp/xml/ns/vmdxml/110820", localName);
    }

    static Element getChild(Element parent, String localName) throws TogaXmlException {
        return DomNsUtils.getFirstChild(parent, "http://mikutoga.sourceforge.jp/xml/ns/vmdxml/110820", localName);
    }

    static Iterable<Element> eachChild(Element parent, String localName) {
        return DomNsUtils.getEachChild(parent, "http://mikutoga.sourceforge.jp/xml/ns/vmdxml/110820", localName);
    }

    static String getStringAttr(Element elem, String attrName) throws TogaXmlException {
        return DomNsUtils.getStringAttrNS(elem, NS_NULL, attrName);
    }

    static boolean getBooleanAttr(Element elem, String attrName) throws TogaXmlException {
        return DomNsUtils.getBooleanAttrNS(elem, NS_NULL, attrName);
    }

    static int getIntegerAttr(Element elem, String attrName) throws TogaXmlException {
        return DomNsUtils.getIntegerAttrNS(elem, NS_NULL, attrName);
    }

    static byte getByteAttr(Element elem, String attrName) throws TogaXmlException {
        int iVal = Xml.getIntegerAttr(elem, attrName);
        byte result = (byte)iVal;
        return result;
    }

    static float getFloatAttr(Element elem, String attrName) throws TogaXmlException {
        return DomNsUtils.getFloatAttrNS(elem, NS_NULL, attrName);
    }

    static void setBezier(Element elem, BezierParam bezier) throws TogaXmlException {
        byte p2y;
        byte p2x;
        byte p1y;
        byte p1x;
        if (Xml.hasNsLocalNameElem(elem, "defLinear")) {
            p1x = 20;
            p1y = 20;
            p2x = 107;
            p2y = 107;
        } else if (Xml.hasNsLocalNameElem(elem, "defEaseInOut")) {
            p1x = 64;
            p1y = 0;
            p2x = 64;
            p2y = 127;
        } else if (Xml.hasNsLocalNameElem(elem, "bezier")) {
            p1x = Xml.getByteAttr(elem, "p1x");
            p1y = Xml.getByteAttr(elem, "p1y");
            p2x = Xml.getByteAttr(elem, "p2x");
            p2y = Xml.getByteAttr(elem, "p2y");
        } else {
            assert (false);
            throw new AssertionError();
        }
        bezier.setP1(p1x, p1y);
        bezier.setP2(p2x, p2y);
    }

    static void buildCurve(Element parentElem, BezierParam bezier) throws TogaXmlException {
        Element bezierElem = Xml.pickChild(parentElem, null);
        if (bezierElem == null) {
            return;
        }
        Xml.setBezier(bezierElem, bezier);
    }

    static void buildPosCurve(Element positionElem, PosCurve curve) throws TogaXmlException {
        SiblingElemIterator it = new SiblingElemIterator(positionElem, "http://mikutoga.sourceforge.jp/xml/ns/vmdxml/110820", null);
        int ct = 0;
        while (it.hasNext()) {
            Element curveElem = (Element)it.next();
            BezierParam bz = curve.item(ct);
            Xml.setBezier(curveElem, bz);
            ++ct;
        }
        assert (ct == 0 || ct == 3);
    }
}

