/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.parser;

import java.io.IOException;
import jp.sourceforge.mikutoga.parser.CommonParser;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.MmdSource;
import jp.sourceforge.mikutoga.vmd.parser.VmdLightingHandler;

class VmdLightingParser
extends CommonParser {
    private VmdLightingHandler handler = null;

    VmdLightingParser(MmdSource source) {
        super(source);
    }

    void setLightingHandler(VmdLightingHandler lightingHandler) {
        this.handler = lightingHandler;
    }

    void parse() throws IOException, MmdFormatException {
        this.parseVmdLighting();
        if (this.hasMore()) {
            this.parseVmdShadow();
        }
    }

    private void parseVmdLighting() throws IOException, MmdFormatException {
        int lightMotionNo = this.parseInteger();
        if (this.handler == null) {
            this.skip(28 * lightMotionNo);
            return;
        }
        this.handler.loopStart(VmdLightingHandler.LUMINOUS_LIST, lightMotionNo);
        for (int ct = 0; ct < lightMotionNo; ++ct) {
            int keyFrameNo = this.parseInteger();
            this.handler.vmdLuminousMotion(keyFrameNo);
            float rVal = this.parseFloat();
            float gVal = this.parseFloat();
            float bVal = this.parseFloat();
            this.handler.vmdLuminousColor(rVal, gVal, bVal);
            float xVec = this.parseFloat();
            float yVec = this.parseFloat();
            float zVec = this.parseFloat();
            this.handler.vmdLuminousDirection(xVec, yVec, zVec);
            this.handler.loopNext(VmdLightingHandler.LUMINOUS_LIST);
        }
        this.handler.loopEnd(VmdLightingHandler.LUMINOUS_LIST);
    }

    private void parseVmdShadow() throws IOException, MmdFormatException {
        int shadowMotionNo = this.parseInteger();
        if (this.handler == null) {
            this.skip(9 * shadowMotionNo);
            return;
        }
        this.handler.loopStart(VmdLightingHandler.SHADOW_LIST, shadowMotionNo);
        for (int ct = 0; ct < shadowMotionNo; ++ct) {
            int keyFrameNo = this.parseInteger();
            this.handler.vmdShadowMotion(keyFrameNo);
            byte shadowMode = this.parseByte();
            this.handler.vmdShadowMode(shadowMode);
            float shadowScope = this.parseFloat();
            this.handler.vmdShadowScopeRaw(shadowScope);
            this.handler.loopNext(VmdLightingHandler.SHADOW_LIST);
        }
        this.handler.loopEnd(VmdLightingHandler.SHADOW_LIST);
    }
}

