/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd2xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import jp.sourceforge.mikutoga.binio.FileUtils;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.MmdSource;
import jp.sourceforge.mikutoga.vmd.IllegalVmdDataException;
import jp.sourceforge.mikutoga.vmd.model.VmdMotion;
import jp.sourceforge.mikutoga.vmd.model.binio.VmdExporter;
import jp.sourceforge.mikutoga.vmd.model.binio.VmdLoader;
import jp.sourceforge.mikutoga.vmd.model.xml.VmdXmlExporter;
import jp.sourceforge.mikutoga.vmd.model.xml.VmdXmlResources;
import jp.sourceforge.mikutoga.vmd.model.xml.Xml2VmdLoader;
import jp.sourceforge.mikutoga.vmd2xml.ArgInfo;
import jp.sourceforge.mikutoga.vmd2xml.ValidationHandler;
import jp.sourceforge.mikutoga.xml.TogaXmlException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Vmd2Xml {
    private static final Class<?> THISCLASS = Vmd2Xml.class;
    private static final String APPNAME;
    private static final String APPVER;
    private static final String APPLICENSE;
    private static final String APPURL;
    private static final int EXIT_OK = 0;
    private static final int EXIT_IOERR = 1;
    private static final int EXIT_ENVERR = 4;
    private static final int EXIT_OPTERR = 5;
    private static final int EXIT_INTERR = 6;
    private static final int EXIT_VMDERR = 7;
    private static final int EXIT_XMLERR = 8;
    private static final String ERRMSG_TXTONLY = "ERROR : {0}\n";
    private static final String ERRMSG_SAXPARSE = "ERROR : {0}\nline={1}, columun={2}\n";

    private Vmd2Xml() {
        assert (this.getClass().equals(THISCLASS));
    }

    public static void main(String[] args) {
        Vmd2Xml.checkJRE();
        ArgInfo argInfo = ArgInfo.buildArgInfo(args);
        if (argInfo.hasOptionError()) {
            String message = argInfo.getErrorMessage() + "\n" + "(-h for help)\n";
            Vmd2Xml.errExit(5, message);
        }
        if (argInfo.isHelpMode()) {
            Vmd2Xml.putHelp();
            Vmd2Xml.exit(0);
        }
        Vmd2Xml.checkFiles(argInfo);
        String input = argInfo.getInputFile();
        String output = argInfo.getOutputFile();
        InputStream is = null;
        OutputStream os = null;
        try {
            is = Vmd2Xml.openInputStream(input);
            os = Vmd2Xml.openTruncatedOutputStream(output);
        }
        catch (FileNotFoundException e) {
            Vmd2Xml.ioError(e);
        }
        catch (IOException e) {
            Vmd2Xml.ioError(e);
        }
        if (argInfo.isVmd2XmlMode()) {
            Vmd2Xml.vmd2xml(is, os, argInfo);
        } else {
            Vmd2Xml.xml2vmd(is, os);
        }
        Vmd2Xml.exit(0);
    }

    private static void checkJRE() {
        Package jrePackage = Object.class.getPackage();
        if (!jrePackage.isCompatibleWith("1.6")) {
            Vmd2Xml.errExit(4, "You need JRE 1.6 or later.\n");
        }
    }

    private static void putHelp() {
        StringBuilder text = new StringBuilder();
        text.append(APPNAME).append(' ').append(APPVER).append('\n');
        text.append("  License : ").append(APPLICENSE).append('\n');
        text.append("  ").append(APPURL).append('\n');
        text.append('\n');
        text.append("-h       : put help massage\n\n-vmd2xml : convert *.vmd to *.xml\n-xml2vmd : convert *.xml to *.vmd\n\n-i file  : specify input file\n-o file  : specify output file\n-f       : force overwriting\n\n-quat    : Quaternion output mode [default]\n-eyxz    : YXZ-Euler output mode\n");
        Vmd2Xml.errprint(text);
    }

    private static void checkFiles(ArgInfo argInfo) {
        String input = argInfo.getInputFile();
        String output = argInfo.getOutputFile();
        File iFile = new File(input);
        File oFile = new File(output);
        if (!FileUtils.isExistsNormalFile(iFile)) {
            Vmd2Xml.errExit(1, "Can't find input file:" + iFile.getAbsolutePath() + '\n');
        }
        if (argInfo.isForceMode()) {
            if (FileUtils.isExistsUnnormalFile(oFile)) {
                Vmd2Xml.errExit(1, oFile.getAbsolutePath() + " is not file.\n");
            }
        } else if (oFile.exists()) {
            Vmd2Xml.errExit(1, oFile.getAbsolutePath() + " already exists.\n" + "If you want to overwrite, use -f.\n");
        }
    }

    private static void vmd2xml(InputStream istream, OutputStream ostream, ArgInfo argInfo) {
        try {
            Vmd2Xml.vmd2xmlImpl(istream, ostream, argInfo);
        }
        catch (IOException e) {
            Vmd2Xml.ioError(e);
        }
        catch (MmdFormatException e) {
            Vmd2Xml.vmdError(e);
        }
        catch (IllegalVmdDataException e) {
            Vmd2Xml.internalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void vmd2xmlImpl(InputStream istream, OutputStream ostream, ArgInfo argInfo) throws IOException, MmdFormatException, IllegalVmdDataException {
        VmdMotion motion;
        try {
            motion = Vmd2Xml.vmdRead(istream);
        }
        finally {
            istream.close();
        }
        motion.frameSort();
        try {
            Vmd2Xml.xmlOut(motion, ostream, argInfo);
        }
        finally {
            ostream.close();
        }
    }

    private static void xml2vmd(InputStream istream, OutputStream ostream) {
        try {
            Vmd2Xml.xml2vmdImpl(istream, ostream);
        }
        catch (IOException e) {
            Vmd2Xml.ioError(e);
        }
        catch (SAXException e) {
            Vmd2Xml.xmlError(e);
        }
        catch (TogaXmlException e) {
            Vmd2Xml.xmlError(e);
        }
        catch (IllegalVmdDataException e) {
            Vmd2Xml.internalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xml2vmdImpl(InputStream istream, OutputStream ostream) throws IOException, SAXException, TogaXmlException, IllegalVmdDataException {
        VmdMotion motion;
        InputSource source = new InputSource(istream);
        try {
            motion = Vmd2Xml.xmlRead(source);
        }
        finally {
            istream.close();
        }
        motion.frameSort();
        try {
            Vmd2Xml.vmdOut(motion, ostream);
        }
        finally {
            ostream.close();
        }
    }

    private static VmdMotion vmdRead(InputStream is) throws IOException, MmdFormatException {
        MmdSource source = new MmdSource(is);
        VmdMotion vmdMotion = VmdLoader.load(source);
        return vmdMotion;
    }

    private static void xmlOut(VmdMotion motion, OutputStream ostream, ArgInfo argInfo) throws IOException, IllegalVmdDataException {
        VmdXmlExporter exporter = new VmdXmlExporter(ostream);
        exporter.setNewLine("\r\n");
        exporter.setGenerator(APPNAME + ' ' + APPVER);
        boolean isQuaternionMode = argInfo.isQuaternionMode();
        exporter.setQuaternionMode(isQuaternionMode);
        exporter.putVmdXml(motion);
        exporter.close();
    }

    private static VmdMotion xmlRead(InputSource source) throws IOException, SAXException, TogaXmlException {
        DocumentBuilder builder = VmdXmlResources.newBuilder(ValidationHandler.HANDLER);
        Xml2VmdLoader loader = new Xml2VmdLoader(builder);
        VmdMotion motion = loader.parse(source);
        return motion;
    }

    private static void vmdOut(VmdMotion motion, OutputStream ostream) throws IOException, IllegalVmdDataException {
        VmdExporter exporter = new VmdExporter(ostream);
        exporter.dumpVmdMotion(motion);
        ostream.close();
    }

    private static InputStream openInputStream(String fileName) throws FileNotFoundException {
        File file = new File(fileName);
        InputStream result = new FileInputStream(file);
        result = new BufferedInputStream(result);
        return result;
    }

    private static OutputStream openTruncatedOutputStream(String fileName) throws FileNotFoundException, IOException {
        File file = new File(fileName);
        FileUtils.trunc(file);
        OutputStream result = new FileOutputStream(file, false);
        result = new BufferedOutputStream(result);
        return result;
    }

    private static void ioError(IOException ex) {
        Vmd2Xml.errprint(ex);
        Vmd2Xml.errprint(Character.valueOf('\n'));
        Vmd2Xml.exit(1);
    }

    private static void internalError(Throwable ex) {
        Vmd2Xml.errprint(ex);
        Vmd2Xml.errprint(Character.valueOf('\n'));
        ex.printStackTrace(System.err);
        Vmd2Xml.exit(6);
    }

    private static void vmdError(MmdFormatException ex) {
        Vmd2Xml.errprint(ex);
        Vmd2Xml.errprint(Character.valueOf('\n'));
        ex.printStackTrace(System.err);
        Vmd2Xml.exit(7);
    }

    private static void xmlError(SAXException ex) {
        if (ex instanceof SAXParseException) {
            Vmd2Xml.xmlError((SAXParseException)ex);
        }
        String txt = ex.getLocalizedMessage();
        String message = MessageFormat.format(ERRMSG_TXTONLY, txt);
        Vmd2Xml.errprint(message);
        Vmd2Xml.exit(8);
    }

    private static void xmlError(SAXParseException ex) {
        String txt = ex.getLocalizedMessage();
        int line = ex.getLineNumber();
        int col = ex.getColumnNumber();
        String message = MessageFormat.format(ERRMSG_SAXPARSE, txt, line, col);
        Vmd2Xml.errprint(message);
        Vmd2Xml.exit(8);
    }

    private static void xmlError(TogaXmlException ex) {
        String txt = ex.getLocalizedMessage();
        String message = MessageFormat.format(ERRMSG_TXTONLY, txt);
        Vmd2Xml.errprint(message);
        Vmd2Xml.exit(8);
    }

    private static void exit(int code) {
        System.exit(code);
        assert (false);
        throw new AssertionError();
    }

    private static void errprint(Object obj) {
        System.err.print(obj.toString());
    }

    private static void errExit(int code, CharSequence text) {
        Vmd2Xml.errprint("ERROR:\n");
        Vmd2Xml.errprint(text);
        Vmd2Xml.exit(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream verDef = THISCLASS.getResourceAsStream("resources/version.properties");
        Properties verProps = new Properties();
        try {
            try {
                verProps.load(verDef);
            }
            finally {
                verDef.close();
            }
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        APPNAME = verProps.getProperty("app.name");
        APPVER = verProps.getProperty("app.version");
        APPLICENSE = verProps.getProperty("app.license");
        APPURL = verProps.getProperty("app.url");
        new Vmd2Xml().hashCode();
    }
}

