/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.binio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.sfjp.mikutoga.pmd.binio.PmdExporterExt2;
import jp.sfjp.mikutoga.pmd.model.BoneInfo;
import jp.sfjp.mikutoga.pmd.model.DynamicsInfo;
import jp.sfjp.mikutoga.pmd.model.JointInfo;
import jp.sfjp.mikutoga.pmd.model.PmdModel;
import jp.sfjp.mikutoga.pmd.model.RigidGroup;
import jp.sfjp.mikutoga.pmd.model.RigidInfo;
import jp.sfjp.mikutoga.pmd.model.RigidShape;
import jp.sourceforge.mikutoga.binio.IllegalTextExportException;
import jp.sourceforge.mikutoga.pmd.Deg3d;
import jp.sourceforge.mikutoga.pmd.IllegalPmdDataException;
import jp.sourceforge.mikutoga.pmd.Rad3d;
import jp.sourceforge.mikutoga.pmd.RigidShapeType;
import jp.sourceforge.mikutoga.pmd.TripletRange;

public class PmdExporterExt3
extends PmdExporterExt2 {
    private static final short MASK_FULLCOLLISION = -1;

    public PmdExporterExt3(OutputStream stream) throws NullPointerException {
        super(stream);
    }

    @Override
    public void dumpPmdModel(PmdModel model) throws IOException, IllegalPmdDataException {
        super.dumpPmdModel(model);
        try {
            this.dumpRigidList(model);
            this.dumpJointList(model);
        }
        catch (IllegalTextExportException e) {
            throw new IllegalPmdDataException(e);
        }
    }

    private void dumpRigidList(PmdModel model) throws IOException, IllegalTextExportException {
        List<RigidInfo> rigidList = model.getRigidList();
        int rigidNum = rigidList.size();
        this.dumpLeInt(rigidNum);
        for (RigidInfo rigid : rigidList) {
            this.dumpRigid(rigid);
        }
        this.flush();
    }

    private void dumpRigid(RigidInfo rigid) throws IOException, IllegalTextExportException {
        String rigidName = rigid.getRigidName().getPrimaryText();
        this.dumpText(rigidName, 20);
        BoneInfo linkedBone = rigid.getLinkedBone();
        if (linkedBone == null) {
            this.dumpLeShort(-1);
        } else {
            this.dumpLeShort(linkedBone.getSerialNumber());
        }
        RigidGroup group = rigid.getRigidGroup();
        this.dumpByte(group.getSerialNumber());
        short mask = -1;
        for (RigidGroup throughGroup : rigid.getThroughGroupColl()) {
            int serialId = throughGroup.getSerialNumber();
            mask = (short)(mask & ~(1 << serialId));
        }
        this.dumpLeShort(mask);
        this.dumpRigidShape(rigid.getRigidShape());
        this.dumpPos3D(rigid.getPosition());
        this.dumpRad3d(rigid.getRotation());
        this.dumpDynamics(rigid.getDynamicsInfo());
        this.dumpByte(rigid.getBehaviorType().encode());
    }

    private void dumpRigidShape(RigidShape shape) throws IOException {
        RigidShapeType type = shape.getShapeType();
        this.dumpByte(type.encode());
        float width = shape.getWidth();
        float height = shape.getHeight();
        float depth = shape.getDepth();
        this.dumpLeFloat(width);
        this.dumpLeFloat(height);
        this.dumpLeFloat(depth);
    }

    private void dumpDynamics(DynamicsInfo dynamics) throws IOException {
        float mass = dynamics.getMass();
        float dampPos = dynamics.getDampingPosition();
        float dampRot = dynamics.getDampingRotation();
        float restitution = dynamics.getRestitution();
        float friction = dynamics.getFriction();
        this.dumpLeFloat(mass);
        this.dumpLeFloat(dampPos);
        this.dumpLeFloat(dampRot);
        this.dumpLeFloat(restitution);
        this.dumpLeFloat(friction);
    }

    private void dumpJointList(PmdModel model) throws IOException, IllegalTextExportException {
        List<JointInfo> jointList = model.getJointList();
        int jointNum = jointList.size();
        this.dumpLeInt(jointNum);
        for (JointInfo joint : jointList) {
            this.dumpJoint(joint);
        }
        this.flush();
    }

    private void dumpJoint(JointInfo joint) throws IOException, IllegalTextExportException {
        String jointName = joint.getJointName().getPrimaryText();
        this.dumpText(jointName, 20);
        RigidInfo rigidA = joint.getRigidA();
        RigidInfo rigidB = joint.getRigidB();
        this.dumpLeInt(rigidA.getSerialNumber());
        this.dumpLeInt(rigidB.getSerialNumber());
        this.dumpPos3D(joint.getPosition());
        this.dumpRad3d(joint.getRotation());
        this.dumpTripletRange(joint.getPositionRange());
        this.dumpTripletRange(joint.getRotationRange());
        this.dumpPos3D(joint.getElasticPosition());
        this.dumpDeg3d(joint.getElasticRotation());
    }

    protected void dumpTripletRange(TripletRange range) throws IOException {
        float xFrom = range.getXFrom();
        float yFrom = range.getYFrom();
        float zFrom = range.getZFrom();
        this.dumpLeFloat(xFrom);
        this.dumpLeFloat(yFrom);
        this.dumpLeFloat(zFrom);
        float xTo = range.getXTo();
        float yTo = range.getYTo();
        float zTo = range.getZTo();
        this.dumpLeFloat(xTo);
        this.dumpLeFloat(yTo);
        this.dumpLeFloat(zTo);
    }

    protected void dumpRad3d(Rad3d rad) throws IOException {
        float xVal = rad.getXRad();
        float yVal = rad.getYRad();
        float zVal = rad.getZRad();
        this.dumpLeFloat(xVal);
        this.dumpLeFloat(yVal);
        this.dumpLeFloat(zVal);
    }

    protected void dumpDeg3d(Deg3d deg) throws IOException {
        float xVal = deg.getXDeg();
        float yVal = deg.getYDeg();
        float zVal = deg.getZDeg();
        this.dumpLeFloat(xVal);
        this.dumpLeFloat(yVal);
        this.dumpLeFloat(zVal);
    }
}

