/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.xml;

import java.awt.Color;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import jp.sfjp.mikutoga.pmd.model.BoneGroup;
import jp.sfjp.mikutoga.pmd.model.BoneInfo;
import jp.sfjp.mikutoga.pmd.model.DynamicsInfo;
import jp.sfjp.mikutoga.pmd.model.IKChain;
import jp.sfjp.mikutoga.pmd.model.JointInfo;
import jp.sfjp.mikutoga.pmd.model.ListUtil;
import jp.sfjp.mikutoga.pmd.model.Material;
import jp.sfjp.mikutoga.pmd.model.MorphPart;
import jp.sfjp.mikutoga.pmd.model.MorphVertex;
import jp.sfjp.mikutoga.pmd.model.PmdModel;
import jp.sfjp.mikutoga.pmd.model.RigidGroup;
import jp.sfjp.mikutoga.pmd.model.RigidInfo;
import jp.sfjp.mikutoga.pmd.model.RigidShape;
import jp.sfjp.mikutoga.pmd.model.ShadeInfo;
import jp.sfjp.mikutoga.pmd.model.Surface;
import jp.sfjp.mikutoga.pmd.model.ToonMap;
import jp.sfjp.mikutoga.pmd.model.Vertex;
import jp.sfjp.mikutoga.pmd.xml.XmlModelFileType;
import jp.sourceforge.mikutoga.corelib.I18nText;
import jp.sourceforge.mikutoga.math.MkPos2D;
import jp.sourceforge.mikutoga.math.MkPos3D;
import jp.sourceforge.mikutoga.math.MkVec3D;
import jp.sourceforge.mikutoga.pmd.BoneType;
import jp.sourceforge.mikutoga.pmd.Deg3d;
import jp.sourceforge.mikutoga.pmd.MorphType;
import jp.sourceforge.mikutoga.pmd.Rad3d;
import jp.sourceforge.mikutoga.pmd.RigidBehaviorType;
import jp.sourceforge.mikutoga.pmd.RigidShapeType;
import jp.sourceforge.mikutoga.pmd.TripletRange;
import jp.sourceforge.mikutoga.xml.DomNsUtils;
import jp.sourceforge.mikutoga.xml.DomUtils;
import jp.sourceforge.mikutoga.xml.TogaXmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlLoader {
    private static final String ERR_INVROOT = "invalid root element[{0}]";
    private static final String ERR_UKVER = "unknown schema version[{0}]";
    private PmdModel model;
    private final Map<String, Integer> toonIdxMap = new HashMap<String, Integer>();
    private final Map<String, BoneInfo> boneMap = new HashMap<String, BoneInfo>();
    private final Map<String, Vertex> vertexMap = new HashMap<String, Vertex>();
    private final Map<String, List<Surface>> surfaceGroupMap = new HashMap<String, List<Surface>>();
    private final Map<String, RigidInfo> rigidMap = new HashMap<String, RigidInfo>();
    private final Map<String, RigidGroup> rigidGroupMap = new HashMap<String, RigidGroup>();
    private String rootNamespace = "http://mikutoga.sourceforge.jp/xml/ns/pmdxml/130128";
    private XmlModelFileType fileType = XmlModelFileType.XML_AUTO;

    private static String getStringAttr(Element elem, String attrName) throws TogaXmlException {
        return DomUtils.getStringAttr(elem, attrName);
    }

    private static boolean getBooleanAttr(Element elem, String attrName) throws TogaXmlException {
        return DomUtils.getBooleanAttr(elem, attrName);
    }

    private static int getIntegerAttr(Element elem, String attrName) throws TogaXmlException {
        return DomUtils.getIntegerAttr(elem, attrName);
    }

    private static float getFloatAttr(Element elem, String attrName) throws TogaXmlException {
        return DomUtils.getFloatAttr(elem, attrName);
    }

    private static String getSjisFileNameAttr(Element elem, String attrName) throws TogaXmlException {
        return DomUtils.getSjisFileNameAttr(elem, attrName);
    }

    private static String getBRedContent(Element parent) {
        StringBuilder result = new StringBuilder();
        block4: for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    Element elem = (Element)node;
                    if (!"br".equals(elem.getTagName())) continue block4;
                    result.append('\n');
                    continue block4;
                }
                case 3: 
                case 4: {
                    String content = node.getTextContent();
                    content = content.replace("\r", "");
                    content = content.replace("\n", "");
                    result.append(content);
                    continue block4;
                }
            }
        }
        return result.toString();
    }

    private XmlModelFileType getFileType() {
        return this.fileType;
    }

    private void setFileType(XmlModelFileType type) {
        if (type != XmlModelFileType.XML_101009 && type != XmlModelFileType.XML_130128) {
            throw new IllegalArgumentException();
        }
        this.fileType = type;
    }

    private String getRootNamespace() {
        return this.rootNamespace;
    }

    private void setRootNamespace(String name) {
        this.rootNamespace = name;
    }

    private Element getChild(Element parent, String tagName) throws TogaXmlException {
        String ns = this.getRootNamespace();
        Element result = DomNsUtils.getFirstChild(parent, ns, tagName);
        return result;
    }

    private boolean hasChild(Element parent, String tagName) {
        String ns = this.getRootNamespace();
        return DomNsUtils.hasChild(parent, ns, tagName);
    }

    private Iterable<Element> eachChild(Element parent, String childTag) {
        String ns = this.getRootNamespace();
        return DomNsUtils.getEachChild(parent, ns, childTag);
    }

    private void buildI18nName(Element baseElement, I18nText text) throws TogaXmlException {
        String primaryText = XmlLoader.getStringAttr(baseElement, "name");
        text.setPrimaryText(primaryText);
        for (Element i18nNameElem : this.eachChild(baseElement, "i18nName")) {
            String lang = XmlLoader.getStringAttr(i18nNameElem, "lang");
            String name = XmlLoader.getStringAttr(i18nNameElem, "name");
            if ("en".equals(lang)) {
                text.setGlobalText(name);
                continue;
            }
            text.setI18nText(lang, (CharSequence)text);
        }
    }

    public PmdModel parse(DocumentBuilder builder, InputSource source) throws SAXException, IOException, TogaXmlException {
        Document document = builder.parse(source);
        PmdModel result = this.parse(document);
        return result;
    }

    public PmdModel parse(Document document) throws TogaXmlException {
        this.model = new PmdModel();
        Element pmdModelElem = document.getDocumentElement();
        String namespace = pmdModelElem.getNamespaceURI();
        this.setRootNamespace(namespace);
        this.buildBasicInfo(pmdModelElem);
        this.buildBoneList(pmdModelElem);
        this.buildVertexList(pmdModelElem);
        this.buildSurfaceList(pmdModelElem);
        this.buildToonMap(pmdModelElem);
        this.buildMaterialList(pmdModelElem);
        this.buildIkChainList(pmdModelElem);
        this.buildMorphList(pmdModelElem);
        this.buildBoneGroupList(pmdModelElem);
        this.buildRigidList(pmdModelElem);
        this.buildRigidGroupList(pmdModelElem);
        this.resolveThroughRigidGroup(pmdModelElem);
        this.buildJointList(pmdModelElem);
        return this.model;
    }

    private void buildBasicInfo(Element pmdModelElem) throws TogaXmlException {
        if (!DomNsUtils.hasNsLocalNameElem(pmdModelElem, this.getRootNamespace(), "pmdModel")) {
            String tagName = pmdModelElem.getTagName();
            String msg = MessageFormat.format(ERR_INVROOT, tagName);
            throw new TogaXmlException(msg);
        }
        String version = XmlLoader.getStringAttr(pmdModelElem, "schemaVersion");
        if ("101009".equals(version)) {
            this.setFileType(XmlModelFileType.XML_101009);
        } else if ("130128".equals(version)) {
            this.setFileType(XmlModelFileType.XML_130128);
        } else {
            String msg = MessageFormat.format(ERR_UKVER, version);
            throw new TogaXmlException(msg);
        }
        I18nText modelName = this.model.getModelName();
        this.buildI18nName(pmdModelElem, modelName);
        String primaryDescription = null;
        String globalDescription = null;
        for (Element descriptionElem : this.eachChild(pmdModelElem, "description")) {
            String descriptionText = XmlLoader.getBRedContent(descriptionElem);
            if (!descriptionElem.hasAttribute("lang")) {
                primaryDescription = descriptionText;
                continue;
            }
            String lang = XmlLoader.getStringAttr(descriptionElem, "lang");
            if (lang.equals("ja")) {
                primaryDescription = descriptionText;
                continue;
            }
            if (!lang.equals("en")) continue;
            globalDescription = descriptionText;
        }
        I18nText description = this.model.getDescription();
        description.setPrimaryText(primaryDescription);
        description.setGlobalText(globalDescription);
    }

    private void buildBoneList(Element pmdModelElem) throws TogaXmlException {
        Element boneListElem = this.getChild(pmdModelElem, "boneList");
        List<BoneInfo> boneList = this.model.getBoneList();
        for (Element boneElem : this.eachChild(boneListElem, "bone")) {
            BoneInfo boneInfo = new BoneInfo();
            boneList.add(boneInfo);
            I18nText boneName = boneInfo.getBoneName();
            this.buildI18nName(boneElem, boneName);
            String boneType = XmlLoader.getStringAttr(boneElem, "type");
            BoneType type = BoneType.valueOf(boneType);
            boneInfo.setBoneType(type);
            String boneId = XmlLoader.getStringAttr(boneElem, "boneId");
            this.boneMap.put(boneId, boneInfo);
            Element positionElem = this.getChild(boneElem, "position");
            float xPos = XmlLoader.getFloatAttr(positionElem, "x");
            float yPos = XmlLoader.getFloatAttr(positionElem, "y");
            float zPos = XmlLoader.getFloatAttr(positionElem, "z");
            MkPos3D position = boneInfo.getPosition();
            position.setXpos(xPos);
            position.setYpos(yPos);
            position.setZpos(zPos);
        }
        ListUtil.assignIndexedSerial(boneList);
        Iterator<BoneInfo> bit = boneList.iterator();
        for (Element boneElem : this.eachChild(boneListElem, "bone")) {
            BoneInfo boneInfo = bit.next();
            if (this.hasChild(boneElem, "ikBone")) {
                Element ikBoneElem = this.getChild(boneElem, "ikBone");
                String ikBoneId = XmlLoader.getStringAttr(ikBoneElem, "boneIdRef");
                BoneInfo ikBone = this.boneMap.get(ikBoneId);
                boneInfo.setSrcBone(ikBone);
            } else if (this.hasChild(boneElem, "sourceBone")) {
                Element srcBoneElem = this.getChild(boneElem, "sourceBone");
                String srcBoneId = XmlLoader.getStringAttr(srcBoneElem, "boneIdRef");
                BoneInfo srcBone = this.boneMap.get(srcBoneId);
                boneInfo.setSrcBone(srcBone);
            } else if (this.hasChild(boneElem, "rotationRatio")) {
                Element rotElem = this.getChild(boneElem, "rotationRatio");
                int ratio = XmlLoader.getIntegerAttr(rotElem, "ratio");
                boneInfo.setRotationRatio(ratio);
            }
            Element boneChainElem = this.getChild(boneElem, "boneChain");
            if (boneChainElem.hasAttribute("prevBoneIdRef")) {
                String prevId = XmlLoader.getStringAttr(boneChainElem, "prevBoneIdRef");
                BoneInfo prevBone = this.boneMap.get(prevId);
                boneInfo.setPrevBone(prevBone);
            }
            if (!boneChainElem.hasAttribute("nextBoneIdRef")) continue;
            String nextId = XmlLoader.getStringAttr(boneChainElem, "nextBoneIdRef");
            BoneInfo nextBone = this.boneMap.get(nextId);
            boneInfo.setNextBone(nextBone);
        }
    }

    private void buildVertexList(Element pmdModelElem) throws TogaXmlException {
        Element vertexListElem = this.getChild(pmdModelElem, "vertexList");
        List<Vertex> vertexList = this.model.getVertexList();
        for (Element vertexElem : this.eachChild(vertexListElem, "vertex")) {
            Vertex vertex = new Vertex();
            vertexList.add(vertex);
            String vertexId = XmlLoader.getStringAttr(vertexElem, "vtxId");
            this.vertexMap.put(vertexId, vertex);
            boolean showEdge = XmlLoader.getBooleanAttr(vertexElem, "showEdge");
            vertex.setEdgeAppearance(showEdge);
            Element positionElem = this.getChild(vertexElem, "position");
            float xVal = XmlLoader.getFloatAttr(positionElem, "x");
            float yVal = XmlLoader.getFloatAttr(positionElem, "y");
            float zVal = XmlLoader.getFloatAttr(positionElem, "z");
            MkPos3D position = vertex.getPosition();
            position.setXpos(xVal);
            position.setYpos(yVal);
            position.setZpos(zVal);
            Element normalElem = this.getChild(vertexElem, "normal");
            xVal = XmlLoader.getFloatAttr(normalElem, "x");
            yVal = XmlLoader.getFloatAttr(normalElem, "y");
            zVal = XmlLoader.getFloatAttr(normalElem, "z");
            MkVec3D normal = vertex.getNormal();
            normal.setXVal(xVal);
            normal.setYVal(yVal);
            normal.setZVal(zVal);
            Element uvElem = this.getChild(vertexElem, "uvMap");
            float uVal = XmlLoader.getFloatAttr(uvElem, "u");
            float vVal = XmlLoader.getFloatAttr(uvElem, "v");
            MkPos2D uv = vertex.getUVPosition();
            uv.setXpos(uVal);
            uv.setYpos(vVal);
            Element skinningElem = this.getChild(vertexElem, "skinning");
            String boneId1 = XmlLoader.getStringAttr(skinningElem, "boneIdRef1");
            String boneId2 = XmlLoader.getStringAttr(skinningElem, "boneIdRef2");
            int weight = XmlLoader.getIntegerAttr(skinningElem, "weightBalance");
            BoneInfo boneA = this.boneMap.get(boneId1);
            BoneInfo boneB = this.boneMap.get(boneId2);
            vertex.setBonePair(boneA, boneB);
            vertex.setWeightA(weight);
        }
        ListUtil.assignIndexedSerial(vertexList);
    }

    private void buildSurfaceList(Element pmdModelElem) throws TogaXmlException {
        Element surfaceGroupListElem = this.getChild(pmdModelElem, "surfaceGroupList");
        for (Element surfaceGroupElem : this.eachChild(surfaceGroupListElem, "surfaceGroup")) {
            String groupId = XmlLoader.getStringAttr(surfaceGroupElem, "surfaceGroupId");
            List<Surface> surfaceList = this.buildSurface(surfaceGroupElem);
            this.surfaceGroupMap.put(groupId, surfaceList);
        }
    }

    private List<Surface> buildSurface(Element surfaceGroupElem) throws TogaXmlException {
        ArrayList<Surface> result = new ArrayList<Surface>();
        for (Element surfaceElem : this.eachChild(surfaceGroupElem, "surface")) {
            Surface surface = new Surface();
            result.add(surface);
            String id1 = XmlLoader.getStringAttr(surfaceElem, "vtxIdRef1");
            String id2 = XmlLoader.getStringAttr(surfaceElem, "vtxIdRef2");
            String id3 = XmlLoader.getStringAttr(surfaceElem, "vtxIdRef3");
            Vertex vertex1 = this.vertexMap.get(id1);
            Vertex vertex2 = this.vertexMap.get(id2);
            Vertex vertex3 = this.vertexMap.get(id3);
            surface.setTriangle(vertex1, vertex2, vertex3);
        }
        return result;
    }

    private void buildToonMap(Element pmdModelElem) throws TogaXmlException {
        ToonMap toonMap = this.model.getToonMap();
        Element toonMapElem = this.getChild(pmdModelElem, "toonMap");
        for (Element toonDefElem : this.eachChild(toonMapElem, "toonDef")) {
            String toonFileId = XmlLoader.getStringAttr(toonDefElem, "toonFileId");
            int toonIndex = XmlLoader.getIntegerAttr(toonDefElem, "index");
            String toonFile = XmlLoader.getSjisFileNameAttr(toonDefElem, "winFileName");
            toonMap.setIndexedToon(toonIndex, toonFile);
            this.toonIdxMap.put(toonFileId, toonIndex);
        }
    }

    private void buildMaterialList(Element pmdModelElem) throws TogaXmlException {
        Element materialListElem = this.getChild(pmdModelElem, "materialList");
        List<Surface> surfaceList = this.model.getSurfaceList();
        List<Material> materialList = this.model.getMaterialList();
        for (Element materialElem : this.eachChild(materialListElem, "material")) {
            int toonIdx;
            Material material = new Material();
            materialList.add(material);
            material.getShadeInfo().setToonMap(this.model.getToonMap());
            String surfaceGroupId = XmlLoader.getStringAttr(materialElem, "surfaceGroupIdRef");
            List<Surface> surfaceGroup = this.surfaceGroupMap.get(surfaceGroupId);
            surfaceList.addAll(surfaceGroup);
            material.getSurfaceList().addAll(surfaceGroup);
            boolean hasEdge = XmlLoader.getBooleanAttr(materialElem, "showEdge");
            material.setEdgeAppearance(hasEdge);
            ShadeInfo shadeInfo = material.getShadeInfo();
            if (this.hasChild(materialElem, "toon")) {
                Element toonElem = this.getChild(materialElem, "toon");
                String toonId = XmlLoader.getStringAttr(toonElem, "toonFileIdRef");
                toonIdx = this.toonIdxMap.get(toonId);
            } else {
                toonIdx = 255;
            }
            shadeInfo.setToonIndex(toonIdx);
            if (this.hasChild(materialElem, "textureFile")) {
                Element textureFileElem = this.getChild(materialElem, "textureFile");
                String textureFile = XmlLoader.getSjisFileNameAttr(textureFileElem, "winFileName");
                shadeInfo.setTextureFileName(textureFile);
            }
            if (this.hasChild(materialElem, "spheremapFile")) {
                Element spheremapFileElem = this.getChild(materialElem, "spheremapFile");
                String spheremapFile = XmlLoader.getSjisFileNameAttr(spheremapFileElem, "winFileName");
                shadeInfo.setSpheremapFileName(spheremapFile);
            }
            Element diffuseElem = this.getChild(materialElem, "diffuse");
            float red = XmlLoader.getFloatAttr(diffuseElem, "r");
            float green = XmlLoader.getFloatAttr(diffuseElem, "g");
            float blue = XmlLoader.getFloatAttr(diffuseElem, "b");
            float alpha = XmlLoader.getFloatAttr(diffuseElem, "alpha");
            Color diffuse = new Color(red, green, blue, alpha);
            material.setDiffuseColor(diffuse);
            Element specularElem = this.getChild(materialElem, "specular");
            red = XmlLoader.getFloatAttr(specularElem, "r");
            green = XmlLoader.getFloatAttr(specularElem, "g");
            blue = XmlLoader.getFloatAttr(specularElem, "b");
            float shininess = XmlLoader.getFloatAttr(specularElem, "shininess");
            Color specular = new Color(red, green, blue);
            material.setSpecularColor(specular);
            material.setShininess(shininess);
            Element ambientElem = this.getChild(materialElem, "ambient");
            red = XmlLoader.getFloatAttr(ambientElem, "r");
            green = XmlLoader.getFloatAttr(ambientElem, "g");
            blue = XmlLoader.getFloatAttr(ambientElem, "b");
            Color ambient = new Color(red, green, blue);
            material.setAmbientColor(ambient);
        }
    }

    private void buildIkChainList(Element pmdModelElem) throws TogaXmlException {
        Element ikChainListElem = this.getChild(pmdModelElem, "ikChainList");
        List<IKChain> ikChainList = this.model.getIKChainList();
        for (Element ikChainElem : this.eachChild(ikChainListElem, "ikChain")) {
            IKChain ikChain = new IKChain();
            ikChainList.add(ikChain);
            String ikBoneIdRef = XmlLoader.getStringAttr(ikChainElem, "ikBoneIdRef");
            int rucursiveDepth = XmlLoader.getIntegerAttr(ikChainElem, "recursiveDepth");
            float weight = XmlLoader.getFloatAttr(ikChainElem, "weight");
            BoneInfo ikBone = this.boneMap.get(ikBoneIdRef);
            ikChain.setIkBone(ikBone);
            ikChain.setIKDepth(rucursiveDepth);
            ikChain.setIKWeight(weight);
            List<BoneInfo> chainList = ikChain.getChainedBoneList();
            for (Element orderElem : this.eachChild(ikChainElem, "chainOrder")) {
                String boneIdRef = XmlLoader.getStringAttr(orderElem, "boneIdRef");
                BoneInfo chaindBone = this.boneMap.get(boneIdRef);
                chainList.add(chaindBone);
            }
        }
    }

    private void buildMorphList(Element pmdModelElem) throws TogaXmlException {
        Element morphListElem = this.getChild(pmdModelElem, "morphList");
        Map<MorphType, List<MorphPart>> morphMap = this.model.getMorphMap();
        for (Element morphElem : this.eachChild(morphListElem, "morph")) {
            MorphPart morphPart = new MorphPart();
            I18nText name = morphPart.getMorphName();
            this.buildI18nName(morphElem, name);
            String type = XmlLoader.getStringAttr(morphElem, "type");
            MorphType morphType = MorphType.valueOf(type);
            morphPart.setMorphType(morphType);
            List<MorphVertex> morphVertexList = morphPart.getMorphVertexList();
            for (Element morphVertexElem : this.eachChild(morphElem, "morphVertex")) {
                String vtxIdRef = XmlLoader.getStringAttr(morphVertexElem, "vtxIdRef");
                Vertex baseVertex = this.vertexMap.get(vtxIdRef);
                float xOff = XmlLoader.getFloatAttr(morphVertexElem, "xOff");
                float yOff = XmlLoader.getFloatAttr(morphVertexElem, "yOff");
                float zOff = XmlLoader.getFloatAttr(morphVertexElem, "zOff");
                MorphVertex morphVertex = new MorphVertex();
                morphVertex.setBaseVertex(baseVertex);
                MkPos3D position = morphVertex.getOffset();
                position.setXpos(xOff);
                position.setYpos(yOff);
                position.setZpos(zOff);
                morphVertexList.add(morphVertex);
            }
            morphMap.get((Object)morphType).add(morphPart);
        }
        LinkedList<MorphPart> serialList = new LinkedList<MorphPart>();
        MorphPart baseDummy = new MorphPart();
        serialList.add(baseDummy);
        for (MorphPart part : morphMap.get((Object)MorphType.EYEBROW)) {
            serialList.add(part);
        }
        for (MorphPart part : morphMap.get((Object)MorphType.EYE)) {
            serialList.add(part);
        }
        for (MorphPart part : morphMap.get((Object)MorphType.LIP)) {
            serialList.add(part);
        }
        for (MorphPart part : morphMap.get((Object)MorphType.EXTRA)) {
            serialList.add(part);
        }
        ListUtil.assignIndexedSerial(serialList);
    }

    private void buildBoneGroupList(Element pmdModelElem) throws TogaXmlException {
        Element boneGroupListElem = this.getChild(pmdModelElem, "boneGroupList");
        List<BoneGroup> boneGroupList = this.model.getBoneGroupList();
        BoneGroup defaultGroup = new BoneGroup();
        boneGroupList.add(defaultGroup);
        for (Element boneGroupElem : this.eachChild(boneGroupListElem, "boneGroup")) {
            BoneGroup group = new BoneGroup();
            boneGroupList.add(group);
            I18nText name = group.getGroupName();
            this.buildI18nName(boneGroupElem, name);
            for (Element boneGroupMemberElem : this.eachChild(boneGroupElem, "boneGroupMember")) {
                String boneIdRef = XmlLoader.getStringAttr(boneGroupMemberElem, "boneIdRef");
                BoneInfo bone = this.boneMap.get(boneIdRef);
                group.getBoneList().add(bone);
            }
        }
        ListUtil.assignIndexedSerial(boneGroupList);
    }

    private void buildRigidList(Element pmdModelElem) throws TogaXmlException {
        Element rigidListElem = this.getChild(pmdModelElem, "rigidList");
        List<RigidInfo> rigidList = this.model.getRigidList();
        for (Element rigidElem : this.eachChild(rigidListElem, "rigid")) {
            Element shapeElem;
            RigidInfo rigid = new RigidInfo();
            rigidList.add(rigid);
            I18nText name = rigid.getRigidName();
            this.buildI18nName(rigidElem, name);
            String behavior = XmlLoader.getStringAttr(rigidElem, "behavior");
            RigidBehaviorType type = RigidBehaviorType.valueOf(behavior);
            rigid.setBehaviorType(type);
            String rigidId = XmlLoader.getStringAttr(rigidElem, "rigidId");
            this.rigidMap.put(rigidId, rigid);
            if (this.hasChild(rigidElem, "linkedBone")) {
                Element linkedBoneElem = this.getChild(rigidElem, "linkedBone");
                String boneIdRef = XmlLoader.getStringAttr(linkedBoneElem, "boneIdRef");
                BoneInfo linkedBone = this.boneMap.get(boneIdRef);
                rigid.setLinkedBone(linkedBone);
            }
            RigidShape rigidShape = rigid.getRigidShape();
            if (this.hasChild(rigidElem, "rigidShapeSphere")) {
                shapeElem = this.getChild(rigidElem, "rigidShapeSphere");
                float radius = XmlLoader.getFloatAttr(shapeElem, "radius");
                rigidShape.setShapeType(RigidShapeType.SPHERE);
                rigidShape.setRadius(radius);
            }
            if (this.hasChild(rigidElem, "rigidShapeBox")) {
                shapeElem = this.getChild(rigidElem, "rigidShapeBox");
                float width = XmlLoader.getFloatAttr(shapeElem, "width");
                float height = XmlLoader.getFloatAttr(shapeElem, "height");
                float depth = XmlLoader.getFloatAttr(shapeElem, "depth");
                rigidShape.setShapeType(RigidShapeType.BOX);
                rigidShape.setWidth(width);
                rigidShape.setHeight(height);
                rigidShape.setDepth(depth);
            }
            if (this.hasChild(rigidElem, "rigidShapeCapsule")) {
                shapeElem = this.getChild(rigidElem, "rigidShapeCapsule");
                float height = XmlLoader.getFloatAttr(shapeElem, "height");
                float radius = XmlLoader.getFloatAttr(shapeElem, "radius");
                rigidShape.setShapeType(RigidShapeType.CAPSULE);
                rigidShape.setHeight(height);
                rigidShape.setRadius(radius);
            }
            Element positionElem = this.getChild(rigidElem, "position");
            float xVal = XmlLoader.getFloatAttr(positionElem, "x");
            float yVal = XmlLoader.getFloatAttr(positionElem, "y");
            float zVal = XmlLoader.getFloatAttr(positionElem, "z");
            MkPos3D position = rigid.getPosition();
            position.setXpos(xVal);
            position.setYpos(yVal);
            position.setZpos(zVal);
            Element radRotationElem = this.getChild(rigidElem, "radRotation");
            xVal = XmlLoader.getFloatAttr(radRotationElem, "xRad");
            yVal = XmlLoader.getFloatAttr(radRotationElem, "yRad");
            zVal = XmlLoader.getFloatAttr(radRotationElem, "zRad");
            Rad3d rotation = rigid.getRotation();
            rotation.setXRad(xVal);
            rotation.setYRad(yVal);
            rotation.setZRad(zVal);
            Element dynamicsElem = this.getChild(rigidElem, "dynamics");
            float mass = XmlLoader.getFloatAttr(dynamicsElem, "mass");
            float dampingPosition = XmlLoader.getFloatAttr(dynamicsElem, "dampingPosition");
            float dampingRotation = XmlLoader.getFloatAttr(dynamicsElem, "dampingRotation");
            float restitution = XmlLoader.getFloatAttr(dynamicsElem, "restitution");
            float friction = XmlLoader.getFloatAttr(dynamicsElem, "friction");
            DynamicsInfo dynamics = rigid.getDynamicsInfo();
            dynamics.setMass(mass);
            dynamics.setDampingPosition(dampingPosition);
            dynamics.setDampingRotation(dampingRotation);
            dynamics.setRestitution(restitution);
            dynamics.setFriction(friction);
        }
        ListUtil.assignIndexedSerial(rigidList);
    }

    private void buildRigidGroupList(Element pmdModelElem) throws TogaXmlException {
        Element rigidGroupListElem = this.getChild(pmdModelElem, "rigidGroupList");
        List<RigidGroup> groupList = this.model.getRigidGroupList();
        for (Element rigidGroupElem : this.eachChild(rigidGroupListElem, "rigidGroup")) {
            RigidGroup rigidGroup = new RigidGroup();
            groupList.add(rigidGroup);
            String rigidGroupId = XmlLoader.getStringAttr(rigidGroupElem, "rigidGroupId");
            this.rigidGroupMap.put(rigidGroupId, rigidGroup);
            for (Element memberElem : this.eachChild(rigidGroupElem, "rigidGroupMember")) {
                String rigidIdRef = XmlLoader.getStringAttr(memberElem, "rigidIdRef");
                RigidInfo rigid = this.rigidMap.get(rigidIdRef);
                rigidGroup.getRigidList().add(rigid);
                rigid.setRigidGroup(rigidGroup);
            }
        }
        while (groupList.size() < 16) {
            RigidGroup rigidGroup = new RigidGroup();
            groupList.add(rigidGroup);
        }
        ListUtil.assignIndexedSerial(groupList);
    }

    private void resolveThroughRigidGroup(Element pmdModelElem) throws TogaXmlException {
        Element rigidListElem = this.getChild(pmdModelElem, "rigidList");
        List<RigidInfo> rigidList = this.model.getRigidList();
        Iterator<RigidInfo> rit = rigidList.iterator();
        for (Element rigidElem : this.eachChild(rigidListElem, "rigid")) {
            RigidInfo rigid = rit.next();
            for (Element groupElem : this.eachChild(rigidElem, "throughRigidGroup")) {
                String groupId = XmlLoader.getStringAttr(groupElem, "rigidGroupIdRef");
                RigidGroup group = this.rigidGroupMap.get(groupId);
                rigid.getThroughGroupColl().add(group);
            }
        }
    }

    private void buildJointList(Element pmdModelElem) throws TogaXmlException {
        Element jointListElem = this.getChild(pmdModelElem, "jointList");
        List<JointInfo> jointList = this.model.getJointList();
        for (Element jointElem : this.eachChild(jointListElem, "joint")) {
            JointInfo joint = new JointInfo();
            jointList.add(joint);
            I18nText name = joint.getJointName();
            this.buildI18nName(jointElem, name);
            Element rigidPairElem = this.getChild(jointElem, "jointedRigidPair");
            String rigidIdRef1 = XmlLoader.getStringAttr(rigidPairElem, "rigidIdRef1");
            String rigidIdRef2 = XmlLoader.getStringAttr(rigidPairElem, "rigidIdRef2");
            RigidInfo rigid1 = this.rigidMap.get(rigidIdRef1);
            RigidInfo rigid2 = this.rigidMap.get(rigidIdRef2);
            joint.setRigidPair(rigid1, rigid2);
            MkPos3D position = joint.getPosition();
            Element positionElem = this.getChild(jointElem, "position");
            float xVal = XmlLoader.getFloatAttr(positionElem, "x");
            float yVal = XmlLoader.getFloatAttr(positionElem, "y");
            float zVal = XmlLoader.getFloatAttr(positionElem, "z");
            position.setXpos(xVal);
            position.setYpos(yVal);
            position.setZpos(zVal);
            TripletRange limitPosition = joint.getPositionRange();
            Element limitPositionElem = this.getChild(jointElem, "limitPosition");
            float xFrom = XmlLoader.getFloatAttr(limitPositionElem, "xFrom");
            float xTo = XmlLoader.getFloatAttr(limitPositionElem, "xTo");
            float yFrom = XmlLoader.getFloatAttr(limitPositionElem, "yFrom");
            float yTo = XmlLoader.getFloatAttr(limitPositionElem, "yTo");
            float zFrom = XmlLoader.getFloatAttr(limitPositionElem, "zFrom");
            float zTo = XmlLoader.getFloatAttr(limitPositionElem, "zTo");
            limitPosition.setXRange(xFrom, xTo);
            limitPosition.setYRange(yFrom, yTo);
            limitPosition.setZRange(zFrom, zTo);
            Rad3d rotation = joint.getRotation();
            Element rotationElem = this.getChild(jointElem, "radRotation");
            xVal = XmlLoader.getFloatAttr(rotationElem, "xRad");
            yVal = XmlLoader.getFloatAttr(rotationElem, "yRad");
            zVal = XmlLoader.getFloatAttr(rotationElem, "zRad");
            rotation.setXRad(xVal);
            rotation.setYRad(yVal);
            rotation.setZRad(zVal);
            TripletRange limitRotation = joint.getRotationRange();
            Element limitRotationElem = this.getChild(jointElem, "limitRotation");
            xFrom = XmlLoader.getFloatAttr(limitRotationElem, "xFrom");
            xTo = XmlLoader.getFloatAttr(limitRotationElem, "xTo");
            yFrom = XmlLoader.getFloatAttr(limitRotationElem, "yFrom");
            yTo = XmlLoader.getFloatAttr(limitRotationElem, "yTo");
            zFrom = XmlLoader.getFloatAttr(limitRotationElem, "zFrom");
            zTo = XmlLoader.getFloatAttr(limitRotationElem, "zTo");
            limitRotation.setXRange(xFrom, xTo);
            limitRotation.setYRange(yFrom, yTo);
            limitRotation.setZRange(zFrom, zTo);
            MkPos3D elasticPosition = joint.getElasticPosition();
            Element elasticPositionElem = this.getChild(jointElem, "elasticPosition");
            xVal = XmlLoader.getFloatAttr(elasticPositionElem, "x");
            yVal = XmlLoader.getFloatAttr(elasticPositionElem, "y");
            zVal = XmlLoader.getFloatAttr(elasticPositionElem, "z");
            elasticPosition.setXpos(xVal);
            elasticPosition.setYpos(yVal);
            elasticPosition.setZpos(zVal);
            Deg3d elasticRotation = joint.getElasticRotation();
            Element elasticRotationElem = this.getChild(jointElem, "elasticRotation");
            xVal = XmlLoader.getFloatAttr(elasticRotationElem, "xDeg");
            yVal = XmlLoader.getFloatAttr(elasticRotationElem, "yDeg");
            zVal = XmlLoader.getFloatAttr(elasticRotationElem, "zDeg");
            elasticRotation.setXDeg(xVal);
            elasticRotation.setYDeg(yVal);
            elasticRotation.setZDeg(zVal);
        }
    }
}

