/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.parser;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import jp.sourceforge.mikutoga.parser.MmdFormatException;

public class TextDecoder {
    public static final int DEF_BUFSZ = 512;
    private final CharsetDecoder decoder;
    private byte[] byteArray;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;
    private boolean chopZero = false;

    public TextDecoder(Charset cs) {
        this(cs.newDecoder());
    }

    public TextDecoder(CharsetDecoder decoder) {
        if (decoder == null) {
            throw new NullPointerException();
        }
        this.decoder = decoder;
        this.decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public byte[] prepareBuffer(int newSize) {
        if (this.byteArray != null && this.byteArray.length >= newSize) {
            return this.byteArray;
        }
        int rounded = newSize;
        if (rounded < 512) {
            rounded = 512;
        }
        this.byteArray = new byte[rounded];
        this.byteBuffer = ByteBuffer.wrap(this.byteArray);
        float maxCharsPerByte = this.decoder.maxCharsPerByte();
        int maxChars = (int)((float)this.byteArray.length * maxCharsPerByte) + 1;
        this.charBuffer = CharBuffer.allocate(maxChars);
        return this.byteArray;
    }

    public void setZeroChopMode(boolean chop) {
        this.chopZero = chop;
    }

    public boolean isZeroChopMode() {
        return this.chopZero;
    }

    protected void chopZeroTermed() {
        if (!this.chopZero) {
            return;
        }
        int limit = this.byteBuffer.limit();
        for (int idx = 0; idx < limit; ++idx) {
            byte bVal = this.byteArray[idx];
            if (bVal != 0) continue;
            this.byteBuffer.limit(idx);
            break;
        }
    }

    public String decode(long basePos, byte[] buf) throws MmdFormatException {
        String result = this.decode(basePos, buf, 0, buf.length);
        return result;
    }

    public String decode(long basePos, byte[] buf, int off, int byteLen) throws MmdFormatException, IndexOutOfBoundsException {
        this.prepareBuffer(byteLen);
        System.arraycopy(buf, off, this.byteArray, 0, byteLen);
        String result = this.decode(basePos, byteLen);
        return result;
    }

    public String decode(long basePos, int byteLen) throws MmdFormatException, IndexOutOfBoundsException {
        if (this.byteArray.length < byteLen) {
            throw new IndexOutOfBoundsException();
        }
        this.byteBuffer.rewind().limit(byteLen);
        this.chopZeroTermed();
        this.charBuffer.clear();
        this.decoder.reset();
        CoderResult decResult = this.decoder.decode(this.byteBuffer, this.charBuffer, true);
        if (decResult.isError()) {
            String errMsg = decResult.isUnmappable() ? "unmapped character" : "illegal character encoding";
            long errPos = basePos + (long)decResult.length();
            throw new MmdFormatException(errMsg, errPos);
        }
        assert (!decResult.isOverflow());
        String result = this.charBuffer.flip().toString();
        return result;
    }
}

