/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model;

import java.text.MessageFormat;
import jp.sfjp.mikutoga.vmd.AbstractNumbered;
import jp.sfjp.mikutoga.vmd.model.ShadowMode;

public strictfp class ShadowMotion
extends AbstractNumbered {
    public static final ShadowMode DEF_MODE = ShadowMode.MODE_1;
    public static final double DEF_SCOPE = 0.01125;
    private static final int DEF_UIVAL = 8875;
    private static final double OFFSET = 0.1;
    private static final double SCALE = 100000.0;
    private static final String MSG_TXT = "#{0} shadow mode : {1} rawparam={2}";
    private ShadowMode shadowMode = DEF_MODE;
    private double rawScopeParam = 0.01125;

    public static double rawParamToScope(double param) {
        double result = 0.1 - param;
        return result *= 100000.0;
    }

    public static double scopeToRawParam(double scope) {
        double result = scope / 100000.0;
        result = 0.1 - result;
        return result;
    }

    public void setRawScopeParam(double rawScopeParam) {
        this.rawScopeParam = rawScopeParam;
    }

    public double getRawScopeParam() {
        return this.rawScopeParam;
    }

    public void setScope(double scope) {
        float rawVal = (float)ShadowMotion.scopeToRawParam(scope);
        this.setRawScopeParam(rawVal);
    }

    public double getScope() {
        double rawVal = this.getRawScopeParam();
        double scope = ShadowMotion.rawParamToScope(rawVal);
        return scope;
    }

    public void setShadowMode(ShadowMode shadowMode) throws NullPointerException {
        if (shadowMode == null) {
            throw new NullPointerException();
        }
        this.shadowMode = shadowMode;
    }

    public ShadowMode getShadowMode() {
        return this.shadowMode;
    }

    public String toString() {
        String msg = MessageFormat.format(MSG_TXT, new Object[]{this.getFrameNumber(), this.shadowMode, Double.toString(this.rawScopeParam)});
        return msg;
    }
}

