/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.sfjp.mikutoga.vmd.AbstractNumbered;
import jp.sfjp.mikutoga.vmd.FrameNumbered;
import jp.sfjp.mikutoga.vmd.VmdUniq;
import jp.sfjp.mikutoga.vmd.model.BoneMotion;
import jp.sfjp.mikutoga.vmd.model.CameraMotion;
import jp.sfjp.mikutoga.vmd.model.LuminousMotion;
import jp.sfjp.mikutoga.vmd.model.MorphMotion;
import jp.sfjp.mikutoga.vmd.model.NumberedVmdFlag;
import jp.sfjp.mikutoga.vmd.model.ShadowMotion;

public class VmdMotion {
    private static final String MSG_TXT = "model name : {0}\nbone#{1} morph#{2} camera#{3} luminous#{4} shadow#{5} flag#{6}";
    private String modelName = "\u30ab\u30e1\u30e9\u30fb\u7167\u660e";
    private final Map<String, List<BoneMotion>> bonePartMap = new LinkedHashMap<String, List<BoneMotion>>();
    private final Map<String, List<MorphMotion>> morphPartMap = new LinkedHashMap<String, List<MorphMotion>>();
    private final List<CameraMotion> cameraMotionList = new LinkedList<CameraMotion>();
    private final List<LuminousMotion> luminousMotionList = new LinkedList<LuminousMotion>();
    private final List<ShadowMotion> shadowMotionList = new LinkedList<ShadowMotion>();
    private final List<NumberedVmdFlag> flagList = new LinkedList<NumberedVmdFlag>();

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) throws NullPointerException {
        if (modelName == null) {
            throw new NullPointerException();
        }
        this.modelName = modelName;
    }

    public boolean isModelMotion() {
        return !VmdUniq.isStageActName(this.modelName);
    }

    public boolean hasFlagMotion() {
        return !this.flagList.isEmpty();
    }

    public Map<String, List<BoneMotion>> getBonePartMap() {
        return this.bonePartMap;
    }

    public Map<String, List<MorphMotion>> getMorphPartMap() {
        return this.morphPartMap;
    }

    public List<CameraMotion> getCameraMotionList() {
        return this.cameraMotionList;
    }

    public List<LuminousMotion> getLuminousMotionList() {
        return this.luminousMotionList;
    }

    public List<ShadowMotion> getShadowMotionList() {
        return this.shadowMotionList;
    }

    public List<NumberedVmdFlag> getNumberedFlagList() {
        return this.flagList;
    }

    public void addBoneMotion(BoneMotion motion) {
        String name = motion.getBoneName();
        List<BoneMotion> list = this.bonePartMap.get(name);
        if (list == null) {
            list = new LinkedList<BoneMotion>();
            this.bonePartMap.put(name, list);
        }
        list.add(motion);
    }

    public void addMorphMotion(MorphMotion motion) {
        String name = motion.getMorphName();
        List<MorphMotion> list = this.morphPartMap.get(name);
        if (list == null) {
            list = new LinkedList<MorphMotion>();
            this.morphPartMap.put(name, list);
        }
        list.add(motion);
    }

    public void frameSort() {
        for (List<BoneMotion> list : this.bonePartMap.values()) {
            Collections.sort(list, FrameNumbered.COMPARATOR);
        }
        for (List<AbstractNumbered> list : this.morphPartMap.values()) {
            Collections.sort(list, FrameNumbered.COMPARATOR);
        }
        Collections.sort(this.cameraMotionList, FrameNumbered.COMPARATOR);
        Collections.sort(this.luminousMotionList, FrameNumbered.COMPARATOR);
        Collections.sort(this.shadowMotionList, FrameNumbered.COMPARATOR);
        Collections.sort(this.flagList, FrameNumbered.COMPARATOR);
    }

    public String toString() {
        int boneNo = 0;
        for (List<BoneMotion> motionList : this.bonePartMap.values()) {
            boneNo += motionList.size();
        }
        int morphNo = 0;
        for (List<MorphMotion> motionList : this.morphPartMap.values()) {
            morphNo += motionList.size();
        }
        int cameraNo = this.cameraMotionList.size();
        int luminousNo = this.luminousMotionList.size();
        int shadowNo = this.shadowMotionList.size();
        int flagNo = this.flagList.size();
        String msg = MessageFormat.format(MSG_TXT, this.modelName, boneNo, morphNo, cameraNo, luminousNo, shadowNo, flagNo);
        return msg;
    }
}

