/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.binio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.sfjp.mikutoga.bin.export.BinaryExporter;
import jp.sfjp.mikutoga.bin.export.IllegalTextExportException;
import jp.sfjp.mikutoga.math.MkPos3D;
import jp.sfjp.mikutoga.math.MkQuat;
import jp.sfjp.mikutoga.vmd.model.BezierParam;
import jp.sfjp.mikutoga.vmd.model.BoneMotion;
import jp.sfjp.mikutoga.vmd.model.MorphMotion;
import jp.sfjp.mikutoga.vmd.model.PosCurve;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;

class BasicExporter
extends BinaryExporter {
    private static final int BZ_SIZE = 4;
    private static final int BZXYZR_SIZE = 16;
    private static final int BZ_REDUNDANT = 4;
    private static final int BZTOTAL_SIZE = 64;
    private static final Charset CS_ASCII = Charset.forName("US-ASCII");
    private static final String HEADFILLER_OLD = "\u0000JKLM";
    private static final String HEADFILLER = "\u0000\u0000\u0000\u0000\u0000";
    private static final byte[] FDFILLER = new byte[]{0, -3};
    private static final byte[] FILLER_00 = new byte[]{0, 0, 0};
    private static final byte[] FILLER_01 = new byte[]{1, 0, 0};
    private final byte[] motionIntplt = new byte[64];
    private final ByteBuffer intpltBuf;
    private final ByteBuffer rdBuf;
    private byte[] intpltFiller = FILLER_01;

    BasicExporter(OutputStream stream) {
        super(stream);
        this.intpltBuf = ByteBuffer.wrap(this.motionIntplt);
        ByteBuffer buf = ByteBuffer.wrap(this.motionIntplt, 0, 16);
        this.rdBuf = buf.asReadOnlyBuffer();
    }

    void dumpHeader(VmdMotion motion) throws IOException {
        String headerTxt = "Vocaloid Motion Data 0002";
        headerTxt = motion.hasFlagMotion() ? headerTxt + HEADFILLER : headerTxt + HEADFILLER_OLD;
        byte[] header = headerTxt.getBytes(CS_ASCII);
        assert (header.length == 30);
        this.dumpByteArray(header);
    }

    void dumpModelName(VmdMotion motion) throws IOException, IllegalTextExportException {
        String modelName = motion.getModelName();
        if (modelName == null) {
            modelName = "\u30ab\u30e1\u30e9\u30fb\u7167\u660e";
        }
        this.dumpFixedW31j(modelName, 20, FDFILLER);
    }

    void dumpBoneMotion(VmdMotion motion) throws IOException, IllegalTextExportException {
        this.intpltFiller = motion.hasFlagMotion() ? FILLER_00 : FILLER_01;
        Map<String, List<BoneMotion>> map = motion.getBonePartMap();
        LinkedList<BoneMotion> bmotionList = new LinkedList<BoneMotion>();
        for (List<BoneMotion> eachList : map.values()) {
            bmotionList.addAll(eachList);
        }
        this.dumpLeInt(bmotionList.size());
        for (BoneMotion boneMotion : bmotionList) {
            String boneName = boneMotion.getBoneName();
            this.dumpFixedW31j(boneName, 15, FDFILLER);
            int frame = boneMotion.getFrameNumber();
            this.dumpLeInt(frame);
            MkPos3D position = boneMotion.getPosition();
            this.dumpBonePosition(position);
            MkQuat rotation = boneMotion.getRotation();
            this.dumpBoneRotation(rotation);
            this.dumpBoneInterpolation(boneMotion);
        }
    }

    private void dumpBonePosition(MkPos3D position) throws IOException {
        float xPos = (float)position.getXpos();
        float yPos = (float)position.getYpos();
        float zPos = (float)position.getZpos();
        this.dumpLeFloat(xPos);
        this.dumpLeFloat(yPos);
        this.dumpLeFloat(zPos);
    }

    private void dumpBoneRotation(MkQuat rotation) throws IOException {
        float qx = (float)rotation.getQ1();
        float qy = (float)rotation.getQ2();
        float qz = (float)rotation.getQ3();
        float qw = (float)rotation.getQW();
        this.dumpLeFloat(qx);
        this.dumpLeFloat(qy);
        this.dumpLeFloat(qz);
        this.dumpLeFloat(qw);
    }

    private void dumpBoneInterpolation(BoneMotion boneMotion) throws IOException {
        PosCurve posCurve = boneMotion.getPosCurve();
        BezierParam xCurve = posCurve.getIntpltXpos();
        BezierParam yCurve = posCurve.getIntpltYpos();
        BezierParam zCurve = posCurve.getIntpltZpos();
        BezierParam rCurve = boneMotion.getIntpltRotation();
        this.intpltBuf.clear();
        this.intpltBuf.put(xCurve.getP1x());
        this.intpltBuf.put(yCurve.getP1x());
        this.intpltBuf.put(zCurve.getP1x());
        this.intpltBuf.put(rCurve.getP1x());
        this.intpltBuf.put(xCurve.getP1y());
        this.intpltBuf.put(yCurve.getP1y());
        this.intpltBuf.put(zCurve.getP1y());
        this.intpltBuf.put(rCurve.getP1y());
        this.intpltBuf.put(xCurve.getP2x());
        this.intpltBuf.put(yCurve.getP2x());
        this.intpltBuf.put(zCurve.getP2x());
        this.intpltBuf.put(rCurve.getP2x());
        this.intpltBuf.put(xCurve.getP2y());
        this.intpltBuf.put(yCurve.getP2y());
        this.intpltBuf.put(zCurve.getP2y());
        this.intpltBuf.put(rCurve.getP2y());
        assert (this.intpltBuf.position() == 16);
        this.redundantCopy();
        this.dumpByteArray(this.motionIntplt);
    }

    private void redundantCopy() {
        this.intpltBuf.position(16);
        for (int lack = 1; lack < 4; ++lack) {
            this.rdBuf.position(lack);
            this.intpltBuf.put(this.rdBuf);
            this.intpltBuf.put(this.intpltFiller, 0, lack);
        }
        assert (this.intpltBuf.position() == 64);
    }

    void dumpMorphMotion(VmdMotion motion) throws IOException, IllegalTextExportException {
        Map<String, List<MorphMotion>> map = motion.getMorphPartMap();
        LinkedList<MorphMotion> morphList = new LinkedList<MorphMotion>();
        for (List<MorphMotion> eachList : map.values()) {
            morphList.addAll(eachList);
        }
        this.dumpLeInt(morphList.size());
        for (MorphMotion morphMotion : morphList) {
            String morphName = morphMotion.getMorphName();
            this.dumpFixedW31j(morphName, 15, FDFILLER);
            int frame = morphMotion.getFrameNumber();
            this.dumpLeInt(frame);
            float flex = morphMotion.getFlex();
            this.dumpLeFloat(flex);
        }
    }

    static {
        assert (HEADFILLER.length() == HEADFILLER_OLD.length());
        assert (FILLER_00.length == FILLER_01.length);
    }
}

