/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.binio;

import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ParseStage;
import jp.sfjp.mikutoga.math.MkPos3D;
import jp.sfjp.mikutoga.math.MkQuat;
import jp.sfjp.mikutoga.vmd.model.BezierParam;
import jp.sfjp.mikutoga.vmd.model.BoneMotion;
import jp.sfjp.mikutoga.vmd.model.MorphMotion;
import jp.sfjp.mikutoga.vmd.model.PosCurve;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;
import jp.sfjp.mikutoga.vmd.parser.VmdBasicHandler;

class BasicLoader
implements VmdBasicHandler {
    private final VmdMotion vmdMotion;
    private BoneMotion currentBoneMotion;
    private MorphMotion currentMorphMotion;
    private boolean hasMoreData;

    BasicLoader(VmdMotion vmdMotion) {
        this.vmdMotion = vmdMotion;
        this.currentBoneMotion = null;
        this.currentMorphMotion = null;
        this.hasMoreData = false;
    }

    private static boolean isBoneMotionList(ParseStage stage) {
        return stage == VmdBasicHandler.BONEMOTION_LIST;
    }

    private static boolean isMorphList(ParseStage stage) {
        return stage == VmdBasicHandler.MORPH_LIST;
    }

    @Override
    public void vmdParseStart() throws MmdFormatException {
        assert (this.currentBoneMotion == null);
        assert (this.currentMorphMotion == null);
    }

    @Override
    public void vmdParseEnd(boolean hasMoreDataArg) throws MmdFormatException {
        this.hasMoreData = hasMoreDataArg;
        assert (this.currentBoneMotion == null);
        assert (this.currentMorphMotion == null);
    }

    @Override
    public void loopStart(ParseStage stage, int loops) throws MmdFormatException {
        if (BasicLoader.isBoneMotionList(stage)) {
            this.currentBoneMotion = new BoneMotion();
        } else if (BasicLoader.isMorphList(stage)) {
            this.currentMorphMotion = new MorphMotion();
        }
    }

    @Override
    public void loopNext(ParseStage stage) throws MmdFormatException {
        if (BasicLoader.isBoneMotionList(stage)) {
            this.vmdMotion.addBoneMotion(this.currentBoneMotion);
            this.currentBoneMotion = new BoneMotion();
        } else if (BasicLoader.isMorphList(stage)) {
            this.vmdMotion.addMorphMotion(this.currentMorphMotion);
            this.currentMorphMotion = new MorphMotion();
        }
    }

    @Override
    public void loopEnd(ParseStage stage) throws MmdFormatException {
        if (BasicLoader.isBoneMotionList(stage)) {
            this.currentBoneMotion = null;
        } else if (BasicLoader.isMorphList(stage)) {
            this.currentMorphMotion = null;
        }
    }

    @Override
    public void vmdHeaderInfo(byte[] header) throws MmdFormatException {
        assert (header != null);
    }

    @Override
    public void vmdModelName(String modelName) throws MmdFormatException {
        this.vmdMotion.setModelName(modelName);
    }

    @Override
    public void vmdBoneMotion(String boneName, int keyFrameNo) throws MmdFormatException {
        this.currentBoneMotion.setBoneName(boneName);
        this.currentBoneMotion.setFrameNumber(keyFrameNo);
    }

    @Override
    public void vmdBoneRotationQt(float qx, float qy, float qz, float qw) throws MmdFormatException {
        MkQuat rotation = this.currentBoneMotion.getRotation();
        rotation.setQ1(qx);
        rotation.setQ2(qy);
        rotation.setQ3(qz);
        rotation.setQW(qw);
    }

    @Override
    public void vmdBonePosition(float xPos, float yPos, float zPos) throws MmdFormatException {
        MkPos3D position = this.currentBoneMotion.getPosition();
        position.setPosition(xPos, yPos, zPos);
    }

    @Override
    public void vmdBoneIntpltRot(byte rP1x, byte rP1y, byte rP2x, byte rP2y) throws MmdFormatException {
        BezierParam bezier = this.currentBoneMotion.getIntpltRotation();
        bezier.setP1(rP1x, rP1y);
        bezier.setP2(rP2x, rP2y);
    }

    @Override
    public void vmdBoneIntpltXpos(byte xP1x, byte xP1y, byte xP2x, byte xP2y) throws MmdFormatException {
        PosCurve posCurve = this.currentBoneMotion.getPosCurve();
        BezierParam bezier = posCurve.getIntpltXpos();
        bezier.setP1(xP1x, xP1y);
        bezier.setP2(xP2x, xP2y);
    }

    @Override
    public void vmdBoneIntpltYpos(byte yP1x, byte yP1y, byte yP2x, byte yP2y) throws MmdFormatException {
        PosCurve posCurve = this.currentBoneMotion.getPosCurve();
        BezierParam bezier = posCurve.getIntpltYpos();
        bezier.setP1(yP1x, yP1y);
        bezier.setP2(yP2x, yP2y);
    }

    @Override
    public void vmdBoneIntpltZpos(byte zP1x, byte zP1y, byte zP2x, byte zP2y) throws MmdFormatException {
        PosCurve posCurve = this.currentBoneMotion.getPosCurve();
        BezierParam bezier = posCurve.getIntpltZpos();
        bezier.setP1(zP1x, zP1y);
        bezier.setP2(zP2x, zP2y);
    }

    @Override
    public void vmdMorphMotion(String morphName, int keyFrameNo, float flex) throws MmdFormatException {
        this.currentMorphMotion.setMorphName(morphName);
        this.currentMorphMotion.setFrameNumber(keyFrameNo);
        this.currentMorphMotion.setFlex(flex);
    }

    boolean hasMoreData() {
        return this.hasMoreData;
    }
}

