/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.model.binio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.sfjp.mikutoga.bin.export.BinaryExporter;
import jp.sfjp.mikutoga.bin.export.IllegalTextExportException;
import jp.sfjp.mikutoga.vmd.model.IkSwitch;
import jp.sfjp.mikutoga.vmd.model.NumberedVmdFlag;
import jp.sfjp.mikutoga.vmd.model.VmdMotion;

class BoolExporter
extends BinaryExporter {
    private static final byte[] FDFILLER = new byte[]{0, -3};

    BoolExporter(OutputStream stream) {
        super(stream);
    }

    void dumpNumberedFlagMotion(VmdMotion motion) throws IOException, IllegalTextExportException {
        List<NumberedVmdFlag> list = motion.getNumberedFlagList();
        if (list.isEmpty()) {
            return;
        }
        int count = list.size();
        this.dumpLeInt(count);
        for (NumberedVmdFlag flag : list) {
            int frameNo = flag.getFrameNumber();
            this.dumpLeInt(frameNo);
            byte showModel = flag.isModelShown() ? (byte)1 : 0;
            this.dumpByte(showModel);
            this.dumpIkSwitch(flag);
        }
    }

    private void dumpIkSwitch(NumberedVmdFlag flag) throws IOException, IllegalTextExportException {
        List<IkSwitch> swList = flag.getIkSwitchList();
        int swNo = swList.size();
        this.dumpLeInt(swNo);
        for (IkSwitch ikSwitch : swList) {
            String boneName = ikSwitch.getBoneName();
            this.dumpFixedW31j(boneName, 20, FDFILLER);
            byte ikValid = ikSwitch.isValid() ? (byte)1 : 0;
            this.dumpByte(ikValid);
        }
    }
}

